/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeTreeNode;
import org.tinymediamanager.ui.tvshows.TvShowSeasonTreeNode;
import org.tinymediamanager.ui.tvshows.TvShowTreeNode;

public class TvShowTreeCellRenderer
implements TreeCellRenderer {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Color EVEN_ROW_COLOR = new Color(241, 245, 250);
    private JPanel tvShowPanel = new JPanel();
    private JLabel tvShowTitle = new JLabel();
    private JLabel tvShowInfo = new JLabel();
    private JLabel tvShowNfoLabel = new JLabel();
    private JLabel tvShowImageLabel = new JLabel();
    private JPanel tvShowSeasonPanel = new JPanel();
    private JLabel tvShowSeasonTitle = new JLabel();
    private JPanel tvShowEpisodePanel = new JPanel();
    private JLabel tvShowEpisodeTitle = new JLabel();
    private JLabel tvShowEpisodeNfoLabel = new JLabel();
    private JLabel tvShowEpisodeImageLabel = new JLabel();
    private JLabel tvShowEpisodeSubtitleLabel = new JLabel();
    private DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();

    public TvShowTreeCellRenderer() {
        this.tvShowPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"min:grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"center:20px"), ColumnSpec.decode((String)"center:20px"), ColumnSpec.decode((String)"center:20px")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        TmmFontHelper.changeFont((JComponent)this.tvShowTitle, 1);
        this.tvShowTitle.setHorizontalAlignment(2);
        this.tvShowTitle.setMinimumSize(new Dimension(0, 0));
        this.tvShowTitle.setHorizontalTextPosition(10);
        this.tvShowPanel.add((Component)this.tvShowTitle, "1, 1");
        this.tvShowPanel.add((Component)this.tvShowNfoLabel, "3, 1, 1, 2");
        this.tvShowPanel.add((Component)this.tvShowImageLabel, "4, 1, 1, 2");
        TmmFontHelper.changeFont((JComponent)this.tvShowInfo, 0.816);
        this.tvShowInfo.setHorizontalAlignment(2);
        this.tvShowInfo.setMinimumSize(new Dimension(0, 0));
        this.tvShowPanel.add((Component)this.tvShowInfo, "1, 2");
        this.tvShowSeasonPanel.setLayout(new BoxLayout(this.tvShowSeasonPanel, 1));
        this.tvShowSeasonPanel.add(this.tvShowSeasonTitle);
        this.tvShowSeasonTitle.setHorizontalTextPosition(10);
        this.tvShowEpisodePanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"min:grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"center:20px"), ColumnSpec.decode((String)"center:20px"), ColumnSpec.decode((String)"center:20px")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC}));
        this.tvShowEpisodeTitle.setMinimumSize(new Dimension(0, 0));
        this.tvShowEpisodeTitle.setHorizontalTextPosition(10);
        this.tvShowEpisodePanel.add((Component)this.tvShowEpisodeTitle, "1, 1");
        this.tvShowEpisodePanel.add((Component)this.tvShowEpisodeNfoLabel, "3, 1");
        this.tvShowEpisodePanel.add((Component)this.tvShowEpisodeImageLabel, "4, 1");
        this.tvShowEpisodePanel.add((Component)this.tvShowEpisodeSubtitleLabel, "5, 1");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object userObject;
        Component returnValue = null;
        if (value != null && value instanceof TvShowTreeNode && (userObject = ((TvShowTreeNode)value).getUserObject()) instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            if (StringUtils.isBlank((CharSequence)tvShow.getYear()) || "0".equals(tvShow.getYear())) {
                this.tvShowTitle.setText(tvShow.getTitleSortable());
            } else {
                this.tvShowTitle.setText(tvShow.getTitleSortable() + " (" + tvShow.getYear() + ")");
            }
            if (StringUtils.isBlank((CharSequence)this.tvShowTitle.getText())) {
                this.tvShowTitle.setText(BUNDLE.getString("tmm.unknowntitle"));
            }
            if (tvShow.isNewlyAdded() || tvShow.hasNewlyAddedEpisodes()) {
                this.tvShowTitle.setIcon(IconManager.NEW);
            } else {
                this.tvShowTitle.setIcon(null);
            }
            this.tvShowInfo.setText(tvShow.getSeasons().size() + " " + BUNDLE.getString("metatag.seasons") + " - " + tvShow.getEpisodes().size() + " " + BUNDLE.getString("metatag.episodes"));
            this.tvShowNfoLabel.setIcon(tvShow.getHasNfoFile() != false ? IconManager.CHECKMARK : IconManager.CROSS);
            this.tvShowImageLabel.setIcon(tvShow.getHasImages() != false ? IconManager.CHECKMARK : IconManager.CROSS);
            this.tvShowPanel.setEnabled(tree.isEnabled());
            this.tvShowPanel.invalidate();
            returnValue = this.tvShowPanel;
        }
        if (value != null && value instanceof TvShowSeasonTreeNode && (userObject = ((TvShowSeasonTreeNode)value).getUserObject()) instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            this.tvShowSeasonTitle.setText(BUNDLE.getString("metatag.season") + " " + season.getSeason());
            this.tvShowSeasonPanel.setEnabled(tree.isEnabled());
            if (season.isNewlyAdded()) {
                this.tvShowSeasonTitle.setIcon(IconManager.NEW);
            } else {
                this.tvShowSeasonTitle.setIcon(null);
            }
            this.tvShowSeasonPanel.invalidate();
            returnValue = this.tvShowSeasonPanel;
        }
        if (value != null && value instanceof TvShowEpisodeTreeNode && (userObject = ((TvShowEpisodeTreeNode)value).getUserObject()) instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            if (episode.getEpisode() > 0) {
                this.tvShowEpisodeTitle.setText(episode.getEpisode() + ". " + episode.getTitle());
            } else {
                this.tvShowEpisodeTitle.setText(episode.getTitle());
            }
            if (StringUtils.isBlank((CharSequence)this.tvShowTitle.getText())) {
                this.tvShowEpisodeTitle.setText(BUNDLE.getString("tmm.unknowntitle"));
            }
            if (episode.isNewlyAdded()) {
                this.tvShowEpisodeTitle.setIcon(IconManager.NEW);
            } else {
                this.tvShowEpisodeTitle.setIcon(null);
            }
            this.tvShowEpisodePanel.setEnabled(tree.isEnabled());
            this.tvShowEpisodeNfoLabel.setIcon(episode.getHasNfoFile() != false ? IconManager.CHECKMARK : IconManager.CROSS);
            this.tvShowEpisodeImageLabel.setIcon(episode.getHasImages() != false ? IconManager.CHECKMARK : IconManager.CROSS);
            this.tvShowEpisodeSubtitleLabel.setIcon(episode.hasSubtitles() ? IconManager.CHECKMARK : IconManager.CROSS);
            this.tvShowEpisodePanel.invalidate();
            returnValue = this.tvShowEpisodePanel;
        }
        if (returnValue == null) {
            returnValue = this.defaultRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        if (selected) {
            returnValue.setBackground(this.defaultRenderer.getBackgroundSelectionColor());
        } else {
            returnValue.setBackground(row % 2 == 0 ? EVEN_ROW_COLOR : Color.WHITE);
        }
        return returnValue;
    }
}

