/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;

public class TvShowSelectionModel
extends AbstractModelObject {
    private static final String SELECTED_TV_SHOW = "selectedTvShow";
    private TvShow selectedTvShow;
    private TvShow initalTvShow;
    private PropertyChangeListener propertyChangeListener;
    private JTree tree;

    public TvShowSelectionModel(JTree tree) {
        this.selectedTvShow = this.initalTvShow = new TvShow();
        this.tree = tree;
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TvShowSelectionModel.this.firePropertyChange(evt);
            }
        };
    }

    public void setSelectedTvShow(TvShow tvShow) {
        TvShow oldValue = this.selectedTvShow;
        this.selectedTvShow = tvShow != null ? tvShow : this.initalTvShow;
        if (oldValue != null) {
            oldValue.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.selectedTvShow != null) {
            this.selectedTvShow.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.firePropertyChange(SELECTED_TV_SHOW, oldValue, this.selectedTvShow);
    }

    public TvShow getSelectedTvShow() {
        return this.selectedTvShow;
    }

    public List<TvShow> getSelectedTvShows() {
        ArrayList<TvShow> selectedTvShows = new ArrayList<TvShow>();
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                DefaultMutableTreeNode node;
                if (path.getPathCount() <= 1 || !((node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof TvShow)) continue;
                TvShow tvShow = (TvShow)node.getUserObject();
                selectedTvShows.add(tvShow);
            }
        }
        return selectedTvShows;
    }

    public List<TvShowEpisode> getSelectedEpisodes() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
        for (Object obj : this.getSelectedObjects()) {
            if (obj instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)obj;
                if (episodes.contains(episode)) continue;
                episodes.add(episode);
                continue;
            }
            if (obj instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)obj;
                for (TvShowEpisode episode : season.getEpisodes()) {
                    if (episodes.contains(episode)) continue;
                    episodes.add(episode);
                }
                continue;
            }
            if (!(obj instanceof TvShow)) continue;
            TvShow tvShow = (TvShow)obj;
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                if (episodes.contains(episode)) continue;
                episodes.add(episode);
            }
        }
        return episodes;
    }

    public List<Object> getSelectedObjects() {
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                if (path.getPathCount() <= 1) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                selectedObjects.add(node.getUserObject());
            }
        }
        return selectedObjects;
    }
}

