/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.util.ResourceBundle;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaEpisode;
import org.tinymediamanager.ui.UTF8Control;

public class TvShowEpisodeChooserModel
extends AbstractModelObject {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    public static final TvShowEpisodeChooserModel emptyResult = new TvShowEpisodeChooserModel();
    private MediaScraper mediaScraper;
    private MediaEpisode mediaEpisode;
    private String title = "";
    private String overview = "";
    private int season = -1;
    private int episode = -1;

    public TvShowEpisodeChooserModel(MediaScraper mediaScraper, MediaEpisode episode) {
        this.mediaScraper = mediaScraper;
        this.mediaEpisode = episode;
        this.setTitle(episode.title);
        this.setOverview(this.mediaEpisode.plot);
        this.setSeason(this.mediaEpisode.season);
        this.setEpisode(this.mediaEpisode.episode);
    }

    private TvShowEpisodeChooserModel() {
        this.setTitle(BUNDLE.getString("chooser.nothingfound"));
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        this.firePropertyChange("title", oldValue, title);
    }

    public void setOverview(String overview) {
        String oldValue = this.overview;
        this.overview = overview;
        this.firePropertyChange("overview", oldValue, overview);
    }

    public void setSeason(int season) {
        int oldValue = this.season;
        this.season = season;
        this.firePropertyChange("season", oldValue, season);
    }

    public void setEpisode(int episode) {
        int oldValue = this.episode;
        this.episode = episode;
        this.firePropertyChange("episode", oldValue, episode);
    }

    public String getTitle() {
        return this.title;
    }

    public String getOverview() {
        return this.overview;
    }

    public int getSeason() {
        return this.season;
    }

    public int getEpisode() {
        return this.episode;
    }

    public MediaEpisode getMediaEpisode() {
        return this.mediaEpisode;
    }
}

