/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowActor;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.ZebraJTable;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;

public class TvShowCastPanel
extends JPanel {
    private static final long serialVersionUID = 2374973082749248956L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final TvShowSelectionModel selectionModel;
    private EventList<TvShowActor> actorEventList = null;
    private DefaultEventTableModel<TvShowActor> actorTableModel = null;
    private JTable tableActors;
    private ImageLabel lblActorImage;

    public TvShowCastPanel(TvShowSelectionModel model) {
        this.selectionModel = model;
        this.actorEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(TvShowActor.class)));
        this.actorTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.actorEventList), (TableFormat)new ActorTableFormat());
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"125px")}, new RowSpec[]{FormFactory.NARROW_LINE_GAP_ROWSPEC, RowSpec.decode((String)"fill:max(125px;default):grow")}));
        this.lblActorImage = new ImageLabel();
        this.lblActorImage.setAlternativeText(BUNDLE.getString("image.notfound.thumb"));
        this.add((Component)this.lblActorImage, "4, 2");
        this.tableActors = new ZebraJTable((TableModel)this.actorTableModel);
        JScrollPane scrollPaneActors = ZebraJTable.createStripedJScrollPane(this.tableActors);
        scrollPaneActors.setViewportView(this.tableActors);
        this.add((Component)scrollPaneActors, "2, 2, fill, fill");
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                Object source = propertyChangeEvent.getSource();
                if (source.getClass() == TvShowSelectionModel.class && "selectedTvShow".equals(property) || source.getClass() == TvShow.class && "actors".equals(property)) {
                    TvShowCastPanel.this.actorEventList.clear();
                    TvShowCastPanel.this.actorEventList.addAll(TvShowCastPanel.this.selectionModel.getSelectedTvShow().getActors());
                    if (TvShowCastPanel.this.actorEventList.size() > 0) {
                        TvShowCastPanel.this.tableActors.getSelectionModel().setSelectionInterval(0, 0);
                    } else {
                        TvShowCastPanel.this.lblActorImage.setImageUrl("");
                    }
                }
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
        this.tableActors.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                int selectedRow;
                if (!arg0.getValueIsAdjusting() && (selectedRow = TvShowCastPanel.this.tableActors.convertRowIndexToModel(TvShowCastPanel.this.tableActors.getSelectedRow())) >= 0 && selectedRow < TvShowCastPanel.this.actorEventList.size()) {
                    TvShowActor actor = (TvShowActor)TvShowCastPanel.this.actorEventList.get(selectedRow);
                    Path p = ImageCache.getCachedFile(actor.getThumbUrl());
                    if (p == null) {
                        TvShowCastPanel.this.lblActorImage.setImageUrl(actor.getThumbUrl());
                    } else {
                        TvShowCastPanel.this.lblActorImage.setImagePath(p.toAbsolutePath().toString());
                    }
                }
            }
        });
    }

    private static class ActorTableFormat
    implements AdvancedTableFormat<TvShowActor> {
        private ActorTableFormat() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return BUNDLE.getString("metatag.name");
                }
                case 1: {
                    return BUNDLE.getString("metatag.role");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(TvShowActor actor, int column) {
            switch (column) {
                case 0: {
                    return actor.getName();
                }
                case 1: {
                    return actor.getCharacter();
                }
            }
            throw new IllegalStateException();
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: 
                case 1: {
                    return String.class;
                }
            }
            throw new IllegalStateException();
        }

        public Comparator getColumnComparator(int column) {
            return null;
        }
    }
}

