/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.tinymediamanager.ui.ButtonBarButtonUI;
import org.tinymediamanager.ui.ButtonBarUI;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.settings.TmmSettingsContainerPanel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class SettingsPanel
extends JPanel {
    private static final long serialVersionUID = -3509434882626534578L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private JPanel buttonBar;
    private ButtonGroup buttonGroup;
    private Component currentComponent;
    private JPanel panelTmmSettings;
    private JPanel panelMovieSettings;
    private JPanel panelTvShowSettings;

    public SettingsPanel() {
        this.setLayout(new BorderLayout());
        this.buttonBar = new JPanel();
        this.buttonBar.setUI(new ButtonBarUI());
        EqualsLayout layout = new EqualsLayout(2, 0);
        this.buttonBar.setLayout(layout);
        this.add("North", this.buttonBar);
        this.buttonGroup = new ButtonGroup();
        this.panelTmmSettings = new TmmSettingsContainerPanel();
        this.addButton(BUNDLE.getString("Settings.general"), new ImageIcon(SettingsPanel.class.getResource("/org/tinymediamanager/ui/images/Action-configure-icon.png")), this.panelTmmSettings);
        this.panelMovieSettings = MovieUIModule.getInstance().getSettingsPanel();
        this.addButton(BUNDLE.getString("Settings.movies"), new ImageIcon(SettingsPanel.class.getResource("/org/tinymediamanager/ui/images/show_reel.png")), this.panelMovieSettings);
        this.panelTvShowSettings = TvShowUIModule.getInstance().getSettingsPanel();
        this.addButton(BUNDLE.getString("Settings.tvshow"), new ImageIcon(SettingsPanel.class.getResource("/org/tinymediamanager/ui/images/tv_show.png")), this.panelTvShowSettings);
    }

    private void addButton(String title, ImageIcon icon, final Component component) {
        AbstractAction action = new AbstractAction(title, icon){
            private static final long serialVersionUID = -5307503386163952433L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsPanel.this.show(component);
            }
        };
        JToggleButton button = new JToggleButton(action);
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        button.setUI(new ButtonBarButtonUI());
        this.buttonBar.add(button);
        this.buttonGroup.add(button);
        if (this.buttonGroup.getSelection() == null) {
            button.setSelected(true);
            this.show(component);
        }
    }

    private void show(Component component) {
        if (this.currentComponent != null) {
            this.remove(this.currentComponent);
        }
        this.currentComponent = component;
        this.add("Center", this.currentComponent);
        this.revalidate();
        this.repaint();
    }
}

