/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.dialogs;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.LocaleUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.IMovieSetMetadataProvider;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.moviesets.MovieSetChooserModel;

public class MovieSetChooserDialog
extends TmmDialog
implements ActionListener {
    private static final long serialVersionUID = -1023959850452480592L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetChooserDialog.class);
    private MovieSet movieSetToScrape;
    private List<MovieSetChooserModel> movieSetsFound = ObservableCollections.observableList(new ArrayList());
    private final Action actionSearch = new SearchAction();
    private boolean continueQueue = true;
    private JLabel lblProgressAction;
    private JProgressBar progressBar;
    private JTextField tfMovieSetName;
    private JTable tableMovieSets;
    private JTextArea lblMovieSetName;
    private ImageLabel lblMovieSetPoster;
    private JTable tableMovies;
    private JCheckBox cbAssignMovies;
    private JButton btnOk;

    public MovieSetChooserDialog(MovieSet movieSet, boolean inQueue) {
        super(BUNDLE.getString("movieset.search"), "movieSetChooser");
        this.setBounds(5, 5, 865, 578);
        this.movieSetToScrape = movieSet;
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panelHeader = new JPanel();
        this.getContentPane().add((Component)panelHeader, "North");
        panelHeader.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"114px:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100px"), ColumnSpec.decode((String)"2dlu")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"25px"), FormFactory.RELATED_GAP_ROWSPEC}));
        this.tfMovieSetName = new JTextField();
        panelHeader.add((Component)this.tfMovieSetName, "2, 2, fill, fill");
        this.tfMovieSetName.setColumns(10);
        JButton btnSearch = new JButton("");
        btnSearch.setAction(this.actionSearch);
        panelHeader.add((Component)btnSearch, "4, 2, fill, top");
        JSplitPane splitPane = new JSplitPane();
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(0.5);
        this.getContentPane().add((Component)splitPane, "Center");
        JPanel panelResults = new JPanel();
        panelResults.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"300px:grow")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"fill:403px:grow")}));
        JScrollPane panelSearchResults = new JScrollPane();
        panelResults.add((Component)panelSearchResults, "2, 2, fill, fill");
        splitPane.setLeftComponent(panelResults);
        this.tableMovieSets = new JTable();
        panelSearchResults.setViewportView(this.tableMovieSets);
        this.tableMovieSets.setSelectionMode(0);
        this.tableMovieSets.setBorder(new LineBorder(new Color(0, 0, 0)));
        ListSelectionModel rowSM = this.tableMovieSets.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    selectedRow = MovieSetChooserDialog.this.tableMovieSets.convertRowIndexToModel(selectedRow);
                    try {
                        MovieSetChooserModel model = (MovieSetChooserModel)MovieSetChooserDialog.this.movieSetsFound.get(selectedRow);
                        if (model != MovieSetChooserModel.emptyResult && !model.isScraped()) {
                            ScrapeTask task = new ScrapeTask(model);
                            task.execute();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn(ex.getMessage());
                    }
                }
            }
        });
        JPanel panelSearchDetail = new JPanel();
        splitPane.setRightComponent(panelSearchDetail);
        panelSearchDetail.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"left:150px"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(300px;default):grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"250px"), FormFactory.PARAGRAPH_GAP_ROWSPEC, RowSpec.decode((String)"top:default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        this.lblMovieSetName = new JTextArea("");
        this.lblMovieSetName.setLineWrap(true);
        this.lblMovieSetName.setOpaque(false);
        this.lblMovieSetName.setWrapStyleWord(true);
        TmmFontHelper.changeFont(this.lblMovieSetName, 1.166, 1);
        panelSearchDetail.add((Component)this.lblMovieSetName, "2, 1, 3, 1, fill, top");
        this.lblMovieSetPoster = new ImageLabel();
        this.lblMovieSetPoster.setAlternativeText(BUNDLE.getString("image.notfound.poster"));
        panelSearchDetail.add((Component)this.lblMovieSetPoster, "2, 3, fill, fill");
        JPanel panel = new JPanel();
        panelSearchDetail.add((Component)panel, "4, 3, fill, fill");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JScrollPane scrollPane = new JScrollPane();
        panelSearchDetail.add((Component)scrollPane, "2, 5, 3, 1, fill, fill");
        this.tableMovies = new JTable();
        scrollPane.setViewportView(this.tableMovies);
        this.cbAssignMovies = new JCheckBox(BUNDLE.getString("movieset.movie.assign"));
        this.cbAssignMovies.setSelected(true);
        panelSearchDetail.add((Component)this.cbAssignMovies, "2, 7, 3, 1");
        JPanel bottomPane = new JPanel();
        this.getContentPane().add((Component)bottomPane, "South");
        bottomPane.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"2dlu"), ColumnSpec.decode((String)"185px"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"18px:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, ColumnSpec.decode((String)"2dlu")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC}));
        this.progressBar = new JProgressBar();
        bottomPane.add((Component)this.progressBar, "2, 2, fill, center");
        this.lblProgressAction = new JLabel("");
        bottomPane.add((Component)this.lblProgressAction, "4, 2, fill, center");
        JPanel buttonPane = new JPanel();
        bottomPane.add((Component)buttonPane, "6, 2, fill, fill");
        EqualsLayout layout = new EqualsLayout(5);
        buttonPane.setBorder(new EmptyBorder(4, 4, 4, 4));
        layout.setMinWidth(100);
        buttonPane.setLayout(layout);
        this.btnOk = new JButton(BUNDLE.getString("Button.ok"));
        this.btnOk.setActionCommand("Save");
        this.btnOk.setToolTipText(BUNDLE.getString("Button.ok"));
        this.btnOk.setIcon(IconManager.APPLY);
        this.btnOk.addActionListener(this);
        buttonPane.add(this.btnOk);
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.setActionCommand("Cancel");
        btnCancel.setToolTipText(BUNDLE.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL);
        btnCancel.addActionListener(this);
        buttonPane.add(btnCancel);
        if (inQueue) {
            JButton btnAbort = new JButton(BUNDLE.getString("Button.abortqueue"));
            btnAbort.setActionCommand("Abort");
            btnAbort.setToolTipText(BUNDLE.getString("Button.abortqueue"));
            btnAbort.setIcon(IconManager.PROCESS_STOP);
            btnAbort.addActionListener(this);
            buttonPane.add((Component)btnAbort, "6, 1, fill, top");
        }
        this.initDataBindings();
        this.tableMovies.getSelectionModel().setSelectionMode(0);
        this.tableMovies.setAutoResizeMode(4);
        this.tableMovieSets.getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("chooser.searchresult"));
        this.tfMovieSetName.setText(movieSet.getTitle());
        this.searchMovie();
    }

    private void searchMovie() {
        SearchTask task = new SearchTask(this.tfMovieSetName.getText());
        task.execute();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        int row;
        if ("Cancel".equals(arg0.getActionCommand())) {
            this.setVisible(false);
        }
        if ("Save".equals(arg0.getActionCommand()) && (row = this.tableMovieSets.getSelectedRow()) >= 0) {
            MovieSetChooserModel model = this.movieSetsFound.get(row);
            if (model != MovieSetChooserModel.emptyResult) {
                this.movieSetToScrape.setTitle(model.getName());
                this.movieSetToScrape.setPlot(model.getOverview());
                this.movieSetToScrape.setTmdbId(model.getTmdbId());
                this.movieSetToScrape.saveToDb();
                if (this.cbAssignMovies.isSelected()) {
                    this.movieSetToScrape.removeAllMovies();
                    for (int i = 0; i < model.getMovies().size(); ++i) {
                        MovieSetChooserModel.MovieInSet movieInSet = model.getMovies().get(i);
                        Movie movie = movieInSet.getMovie();
                        if (movie == null) continue;
                        if (movie.getMovieSet() != null) {
                            MovieSet mSet = movie.getMovieSet();
                            mSet.removeMovie(movie, true);
                        }
                        movie.setMovieSet(this.movieSetToScrape);
                        movie.writeNFO();
                        movie.saveToDb();
                        this.movieSetToScrape.addMovie(movie);
                    }
                    this.movieSetToScrape.saveToDb();
                }
                if (Globals.settings.getMovieScraperMetadataConfig().isArtwork()) {
                    model.startArtworkScrapeTask(this.movieSetToScrape, Globals.settings.getMovieScraperMetadataConfig());
                }
            }
            this.setVisible(false);
        }
        if ("Abort".equals(arg0.getActionCommand())) {
            this.continueQueue = false;
            this.setVisible(false);
        }
    }

    private void startProgressBar(final String description) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MovieSetChooserDialog.this.lblProgressAction.setText(description);
                MovieSetChooserDialog.this.progressBar.setVisible(true);
                MovieSetChooserDialog.this.progressBar.setIndeterminate(true);
            }
        });
    }

    private void stopProgressBar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MovieSetChooserDialog.this.lblProgressAction.setText("");
                MovieSetChooserDialog.this.progressBar.setVisible(false);
                MovieSetChooserDialog.this.progressBar.setIndeterminate(false);
            }
        });
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.movieSetsFound, (JTable)this.tableMovieSets);
        BeanProperty movieSetChooserModelBeanProperty = BeanProperty.create((String)"name");
        jTableBinding.addColumnBinding((Property)movieSetChooserModelBeanProperty).setEditable(false);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.movies");
        JTableBinding jTableBinding_1 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableMovieSets, (Property)jTableBeanProperty, (JTable)this.tableMovies);
        BeanProperty movieInSetBeanProperty = BeanProperty.create((String)"name");
        jTableBinding_1.addColumnBinding((Property)movieInSetBeanProperty).setColumnName(BUNDLE.getString("tmm.movie")).setEditable(false);
        BeanProperty movieInSetBeanProperty_2 = BeanProperty.create((String)"movie.title");
        jTableBinding_1.addColumnBinding((Property)movieInSetBeanProperty_2).setColumnName(BUNDLE.getString("movieset.movie.matched")).setEditable(false);
        jTableBinding_1.bind();
        BeanProperty jTableBeanProperty_1 = BeanProperty.create((String)"selectedElement.name");
        BeanProperty jTextAreaBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableMovieSets, (Property)jTableBeanProperty_1, (Object)this.lblMovieSetName, (Property)jTextAreaBeanProperty);
        autoBinding.bind();
        BeanProperty jTableBeanProperty_2 = BeanProperty.create((String)"selectedElement.posterUrl");
        BeanProperty imageLabelBeanProperty = BeanProperty.create((String)"imageUrl");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableMovieSets, (Property)jTableBeanProperty_2, (Object)this.lblMovieSetPoster, (Property)imageLabelBeanProperty);
        autoBinding_1.bind();
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    @Override
    public void pack() {
    }

    private class ScrapeTask
    extends SwingWorker<Void, Void> {
        private MovieSetChooserModel model;

        public ScrapeTask(MovieSetChooserModel model) {
            this.model = model;
        }

        @Override
        public Void doInBackground() {
            MovieSetChooserDialog.this.startProgressBar(BUNDLE.getString("chooser.scrapeing") + " " + this.model.getName());
            MovieSetChooserDialog.this.btnOk.setEnabled(false);
            this.model.scrapeMetadata();
            MovieSetChooserDialog.this.btnOk.setEnabled(true);
            return null;
        }

        @Override
        public void done() {
            MovieSetChooserDialog.this.stopProgressBar();
        }
    }

    private class SearchAction
    extends AbstractAction {
        private static final long serialVersionUID = -6561883838396668177L;

        public SearchAction() {
            this.putValue("Name", BUNDLE.getString("Button.search"));
            this.putValue("ShortDescription", BUNDLE.getString("movieset.search"));
            this.putValue("SmallIcon", IconManager.SEARCH);
            this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieSetChooserDialog.this.searchMovie();
        }
    }

    private class SearchTask
    extends SwingWorker<Void, Void> {
        private String searchTerm;

        public SearchTask(String searchTerm) {
            this.searchTerm = searchTerm;
        }

        @Override
        public Void doInBackground() {
            MovieSetChooserDialog.this.startProgressBar(BUNDLE.getString("chooser.searchingfor") + " " + this.searchTerm);
            try {
                List<MediaScraper> sets = MediaScraper.getMediaScrapers(ScraperType.MOVIE_SET);
                if (sets != null && sets.size() > 0) {
                    MediaScraper first = sets.get(0);
                    IMovieSetMetadataProvider mp = (IMovieSetMetadataProvider)first.getMediaProvider();
                    MediaSearchOptions options = new MediaSearchOptions(MediaType.MOVIE_SET, this.searchTerm);
                    options.setLanguage(LocaleUtils.toLocale((String)MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().name()));
                    List movieSets = mp.search(options);
                    MovieSetChooserDialog.this.movieSetsFound.clear();
                    if (movieSets.size() == 0) {
                        MovieSetChooserDialog.this.movieSetsFound.add(MovieSetChooserModel.emptyResult);
                    } else {
                        for (MediaSearchResult collection : movieSets) {
                            MovieSetChooserModel model = new MovieSetChooserModel(collection);
                            MovieSetChooserDialog.this.movieSetsFound.add(model);
                        }
                    }
                }
            }
            catch (Exception e1) {
                LOGGER.warn("SearchTask", (Throwable)e1);
            }
            return null;
        }

        @Override
        public void done() {
            MovieSetChooserDialog.this.stopProgressBar();
        }
    }
}

