/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.japura.gui.CheckComboBox;
import org.japura.gui.model.ListCheckModel;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.MediaScraperComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.movies.MovieScraperMetadataPanel;

public class MovieScrapeMetadataDialog
extends TmmDialog {
    private static final long serialVersionUID = 3826984454317979241L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSearchAndScrapeOptions movieSearchAndScrapeConfig = new MovieSearchAndScrapeOptions();
    private MediaScraperComboBox cbMetadataScraper;
    private CheckComboBox cbArtworkScraper;
    private CheckComboBox cbTrailerScraper;
    private boolean startScrape = false;

    public MovieScrapeMetadataDialog(String title) {
        super(title, "updateMetadata");
        this.setBounds(5, 5, 550, 280);
        this.setMinimumSize(new Dimension(this.getWidth(), this.getHeight()));
        MovieScraperMetadataConfig settings = Globals.settings.getMovieScraperMetadataConfig();
        MovieScraperMetadataConfig scraperMetadataConfig = new MovieScraperMetadataConfig();
        scraperMetadataConfig.setTitle(settings.isTitle());
        scraperMetadataConfig.setOriginalTitle(settings.isOriginalTitle());
        scraperMetadataConfig.setTagline(settings.isTagline());
        scraperMetadataConfig.setPlot(settings.isPlot());
        scraperMetadataConfig.setRating(settings.isRating());
        scraperMetadataConfig.setRuntime(settings.isRuntime());
        scraperMetadataConfig.setYear(settings.isYear());
        scraperMetadataConfig.setCertification(settings.isCertification());
        scraperMetadataConfig.setCast(settings.isCast());
        scraperMetadataConfig.setGenres(settings.isGenres());
        scraperMetadataConfig.setArtwork(settings.isArtwork());
        scraperMetadataConfig.setTrailer(settings.isTrailer());
        scraperMetadataConfig.setCollection(settings.isCollection());
        scraperMetadataConfig.setTags(settings.isTags());
        this.movieSearchAndScrapeConfig.setScraperMetadataConfig(scraperMetadataConfig);
        JPanel panelCenter = new JPanel();
        this.getContentPane().add((Component)panelCenter, "Center");
        panelCenter.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JPanel panelScraper = new JPanel();
        panelCenter.add((Component)panelScraper, "2, 2, default, fill");
        panelScraper.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.PARAGRAPH_GAP_ROWSPEC}));
        JLabel lblMetadataScraperT = new JLabel(BUNDLE.getString("scraper.metadata"));
        panelScraper.add((Component)lblMetadataScraperT, "2, 2, right, default");
        this.cbMetadataScraper = new MediaScraperComboBox(MovieList.getInstance().getAvailableMediaScrapers());
        panelScraper.add((Component)this.cbMetadataScraper, "4, 2, 5, 1");
        JLabel lblArtworkScraper = new JLabel(BUNDLE.getString("scraper.artwork"));
        panelScraper.add((Component)lblArtworkScraper, "2, 4, right, default");
        this.cbArtworkScraper = new MediaScraperCheckComboBox();
        this.cbArtworkScraper.setTextFor(CheckComboBox.NONE, BUNDLE.getString("scraper.selected.none"));
        this.cbArtworkScraper.setTextFor(CheckComboBox.MULTIPLE, BUNDLE.getString("scraper.selected.multiple"));
        this.cbArtworkScraper.setTextFor(CheckComboBox.ALL, BUNDLE.getString("scraper.selected.all"));
        panelScraper.add((Component)this.cbArtworkScraper, "4, 4, 5, 1");
        JLabel lblTrailerScraper = new JLabel(BUNDLE.getString("scraper.trailer"));
        panelScraper.add((Component)lblTrailerScraper, "2, 6, right, default");
        this.cbTrailerScraper = new MediaScraperCheckComboBox();
        this.cbTrailerScraper.setTextFor(CheckComboBox.NONE, BUNDLE.getString("scraper.selected.none"));
        this.cbTrailerScraper.setTextFor(CheckComboBox.MULTIPLE, BUNDLE.getString("scraper.selected.multiple"));
        this.cbTrailerScraper.setTextFor(CheckComboBox.ALL, BUNDLE.getString("scraper.selected.all"));
        panelScraper.add((Component)this.cbTrailerScraper, "4, 6, 5, 1");
        MovieScraperMetadataPanel panelScraperMetadataSetting = new MovieScraperMetadataPanel(this.movieSearchAndScrapeConfig.getScraperMetadataConfig());
        panelScraperMetadataSetting.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), BUNDLE.getString("scraper.metadata.select"), 4, 2, null, null));
        panelCenter.add((Component)panelScraperMetadataSetting, "2, 4, default, fill");
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new EqualsLayout(5));
        panelButtons.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.getContentPane().add((Component)panelButtons, "South");
        JButton btnStart = new JButton(BUNDLE.getString("scraper.start"));
        btnStart.setIcon(IconManager.APPLY);
        btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieScrapeMetadataDialog.this.startScrape = true;
                MovieScrapeMetadataDialog.this.setVisible(false);
            }
        });
        panelButtons.add(btnStart);
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieScrapeMetadataDialog.this.startScrape = false;
                MovieScrapeMetadataDialog.this.setVisible(false);
            }
        });
        panelButtons.add(btnCancel);
        MediaScraper defaultScraper = MediaScraper.getMediaScraperById(MovieModuleManager.MOVIE_SETTINGS.getMovieScraper(), ScraperType.MOVIE);
        this.cbMetadataScraper.setSelectedItem(defaultScraper);
        ListCheckModel model = this.cbArtworkScraper.getModel();
        for (MediaScraper artworkScraper : MovieList.getInstance().getAvailableArtworkScrapers()) {
            model.addElement(new Object[]{artworkScraper});
            if (!MovieModuleManager.MOVIE_SETTINGS.getMovieArtworkScrapers().contains(artworkScraper.getId())) continue;
            model.addCheck(new Object[]{artworkScraper});
        }
        model = this.cbTrailerScraper.getModel();
        for (MediaScraper trailerScraper : MovieList.getInstance().getAvailableTrailerScrapers()) {
            model.addElement(new Object[]{trailerScraper});
            if (!MovieModuleManager.MOVIE_SETTINGS.getMovieTrailerScrapers().contains(trailerScraper.getId())) continue;
            model.addCheck(new Object[]{trailerScraper});
        }
    }

    public MovieSearchAndScrapeOptions getMovieSearchAndScrapeConfig() {
        this.movieSearchAndScrapeConfig.setMetadataScraper((MediaScraper)this.cbMetadataScraper.getSelectedItem());
        ListCheckModel model = this.cbArtworkScraper.getModel();
        for (Object checked : model.getCheckeds()) {
            if (checked == null || !(checked instanceof MediaScraper)) continue;
            this.movieSearchAndScrapeConfig.addArtworkScraper((MediaScraper)checked);
        }
        model = this.cbTrailerScraper.getModel();
        for (Object checked : model.getCheckeds()) {
            if (checked == null || !(checked instanceof MediaScraper)) continue;
            this.movieSearchAndScrapeConfig.addTrailerScraper((MediaScraper)checked);
        }
        return this.movieSearchAndScrapeConfig;
    }

    public boolean shouldStartScrape() {
        return this.startScrape;
    }
}

