/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieEditorDialog;

public class MovieEditAction
extends AbstractAction {
    private static final long serialVersionUID = -8473181347332963044L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieEditAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("movie.edit"));
        }
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("ShortDescription", BUNDLE.getString("movie.edit"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Movie movie;
        MovieEditorDialog dialogMovieEditor;
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        Iterator i$ = selectedMovies.iterator();
        while (i$.hasNext() && (dialogMovieEditor = new MovieEditorDialog(movie = (Movie)i$.next(), selectedMovies.size() > 1)).showDialog()) {
        }
    }
}

