/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieAssignMovieSetTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieAssignMovieSetAction
extends AbstractAction {
    private static final long serialVersionUID = -4213315298837335636L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieAssignMovieSetAction() {
        this.putValue("Name", BUNDLE.getString("movie.assignmovieset"));
        this.putValue("ShortDescription", BUNDLE.getString("movie.assignmovieset.desc"));
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.size() > 0) {
            MovieAssignMovieSetTask scrapeTask = new MovieAssignMovieSetTask(selectedMovies);
            if (TmmTaskManager.getInstance().addMainTask(scrapeTask)) {
                JOptionPane.showMessageDialog(null, BUNDLE.getString("onlyoneoperation"));
            }
        }
    }
}

