/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.plaf.ButtonUI;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.mediaprovider.IMediaArtworkProvider;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.ToggleButtonUI;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.WrapLayout;
import org.tinymediamanager.ui.components.EnhancedTextField;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.dialogs.ImagePreviewDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class ImageChooserDialog
extends TmmDialog {
    private static final long serialVersionUID = 8193355920006275933L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageChooserDialog.class);
    private static final String DIALOG_ID = "imageChooser";
    private DownloadTask task;
    private List<MediaScraper> artworkScrapers;
    private List<String> extraThumbs;
    private List<String> extraFanarts;
    private final JPanel contentPanel = new JPanel();
    private JProgressBar progressBar;
    private JLabel lblProgressAction;
    private JPanel panelImages;
    private ImageLabel imageLabel;
    private JScrollPane scrollPane;
    private ImageType type;
    private MediaType mediaType;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private List<JToggleButton> buttons = new ArrayList<JToggleButton>();
    private final Action actionOK = new OkAction();
    private final Action actionCancel = new CancelAction();
    private final ToggleButtonUI toggleButtonUI = new ToggleButtonUI();
    private final Action actionLocalFile = new LocalFileChooseAction();
    private JTextField tfImageUrl;

    public ImageChooserDialog(HashMap<String, Object> ids, ImageType type, List<MediaScraper> artworkScrapers, ImageLabel imageLabel, List<String> extraThumbs, List<String> extraFanarts, MediaType mediaType) {
        super("", DIALOG_ID);
        this.imageLabel = imageLabel;
        this.type = type;
        this.mediaType = mediaType;
        this.artworkScrapers = artworkScrapers;
        this.extraThumbs = extraThumbs;
        this.extraFanarts = extraFanarts;
        switch (type) {
            case FANART: {
                this.setTitle(BUNDLE.getString("image.choose.fanart"));
                break;
            }
            case POSTER: {
                this.setTitle(BUNDLE.getString("image.choose.poster"));
                break;
            }
            case BANNER: {
                this.setTitle(BUNDLE.getString("image.choose.banner"));
                break;
            }
            case SEASON: {
                Object season = ids.get("tvShowSeason");
                if (season != null) {
                    this.setTitle(BUNDLE.getString("image.choose.season") + " - " + BUNDLE.getString("metatag.season") + " " + season);
                    break;
                }
                this.setTitle(BUNDLE.getString("image.choose.season"));
                break;
            }
            case CLEARART: {
                this.setTitle(BUNDLE.getString("image.choose.clearart"));
                break;
            }
            case DISC: {
                this.setTitle(BUNDLE.getString("image.choose.disc"));
                break;
            }
            case LOGO: {
                this.setTitle(BUNDLE.getString("image.choose.logo"));
                break;
            }
            case CLEARLOGO: {
                this.setTitle(BUNDLE.getString("image.choose.clearlogo"));
                break;
            }
            case THUMB: {
                this.setTitle(BUNDLE.getString("image.choose.thumb"));
            }
        }
        this.setBounds(5, 5, 1000, 590);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"258px:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"fill:266px:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.contentPanel.add((Component)this.scrollPane, "2, 2, 3, 1, fill, fill");
        this.panelImages = new JPanel();
        this.scrollPane.setViewportView(this.panelImages);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.panelImages.setLayout(new WrapLayout(0));
        this.tfImageUrl = new EnhancedTextField(BUNDLE.getString("image.inserturl"));
        this.contentPanel.add((Component)this.tfImageUrl, "2, 4, fill, default");
        this.tfImageUrl.setColumns(10);
        JButton btnAddImage = new JButton(BUNDLE.getString("image.downloadimage"));
        btnAddImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtils.isNotBlank((CharSequence)ImageChooserDialog.this.tfImageUrl.getText())) {
                    ImageChooserDialog.this.downloadAndPreviewImage(ImageChooserDialog.this.tfImageUrl.getText());
                }
            }
        });
        this.contentPanel.add((Component)btnAddImage, "4, 4");
        JPanel bottomPane = new JPanel();
        this.getContentPane().add((Component)bottomPane, "South");
        bottomPane.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, RowSpec.decode((String)"23px:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        if (type == ImageType.FANART && extraFanarts != null && extraThumbs != null) {
            JPanel panelExtraButtons = new JPanel();
            bottomPane.add((Component)panelExtraButtons, "2, 2, fill, bottom");
            panelExtraButtons.setLayout(new FlowLayout(0, 2, 0));
            if (mediaType == MediaType.MOVIE && MovieModuleManager.MOVIE_SETTINGS.isImageExtraThumbs()) {
                JLabel labelThumbs = new JLabel("Extrathumbs:");
                panelExtraButtons.add(labelThumbs);
                JButton btnMarkExtrathumbs = new JButton("");
                btnMarkExtrathumbs.setMargin(new Insets(0, 0, 0, 0));
                btnMarkExtrathumbs.setIcon(IconManager.CHECK_ALL);
                btnMarkExtrathumbs.setToolTipText(BUNDLE.getString("image.extrathumbs.markall"));
                btnMarkExtrathumbs.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        for (JToggleButton button : ImageChooserDialog.this.buttons) {
                            if (!(button.getClientProperty("MediaArtworkExtrathumb") instanceof JCheckBox)) continue;
                            JCheckBox chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrathumb");
                            chkbx.setSelected(true);
                        }
                    }
                });
                panelExtraButtons.add(btnMarkExtrathumbs);
                JButton btnUnMarkExtrathumbs = new JButton("");
                btnUnMarkExtrathumbs.setMargin(new Insets(0, 0, 0, 0));
                btnUnMarkExtrathumbs.setIcon(IconManager.UNCHECK_ALL);
                btnUnMarkExtrathumbs.setToolTipText(BUNDLE.getString("image.extrathumbs.unmarkall"));
                btnUnMarkExtrathumbs.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        for (JToggleButton button : ImageChooserDialog.this.buttons) {
                            if (!(button.getClientProperty("MediaArtworkExtrathumb") instanceof JCheckBox)) continue;
                            JCheckBox chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrathumb");
                            chkbx.setSelected(false);
                        }
                    }
                });
                panelExtraButtons.add(btnUnMarkExtrathumbs);
            }
            if (mediaType == MediaType.MOVIE && MovieModuleManager.MOVIE_SETTINGS.isImageExtraThumbs() && MovieModuleManager.MOVIE_SETTINGS.isImageExtraFanart()) {
                JSeparator separator = new JSeparator(1);
                separator.setPreferredSize(new Dimension(2, 16));
                panelExtraButtons.add(separator);
            }
            if (mediaType == MediaType.MOVIE && MovieModuleManager.MOVIE_SETTINGS.isImageExtraFanart()) {
                JLabel labelFanart = new JLabel("Extrafanart:");
                panelExtraButtons.add(labelFanart);
                JButton btnMarkExtrafanart = new JButton("");
                btnMarkExtrafanart.setMargin(new Insets(0, 0, 0, 0));
                btnMarkExtrafanart.setIcon(IconManager.CHECK_ALL);
                btnMarkExtrafanart.setToolTipText(BUNDLE.getString("image.extrafanart.markall"));
                btnMarkExtrafanart.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        for (JToggleButton button : ImageChooserDialog.this.buttons) {
                            if (!(button.getClientProperty("MediaArtworkExtrafanart") instanceof JCheckBox)) continue;
                            JCheckBox chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrafanart");
                            chkbx.setSelected(true);
                        }
                    }
                });
                panelExtraButtons.add(btnMarkExtrafanart);
                JButton btnUnMarkExtrafanart = new JButton("");
                btnUnMarkExtrafanart.setMargin(new Insets(0, 0, 0, 0));
                btnUnMarkExtrafanart.setIcon(IconManager.UNCHECK_ALL);
                btnUnMarkExtrafanart.setToolTipText(BUNDLE.getString("image.extrafanart.unmarkall"));
                btnUnMarkExtrafanart.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        for (JToggleButton button : ImageChooserDialog.this.buttons) {
                            if (!(button.getClientProperty("MediaArtworkExtrafanart") instanceof JCheckBox)) continue;
                            JCheckBox chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrafanart");
                            chkbx.setSelected(false);
                        }
                    }
                });
                panelExtraButtons.add(btnUnMarkExtrafanart);
            }
        }
        this.progressBar = new JProgressBar();
        bottomPane.add((Component)this.progressBar, "2, 4");
        this.lblProgressAction = new JLabel("");
        bottomPane.add((Component)this.lblProgressAction, "4, 4");
        JPanel buttonPane = new JPanel();
        EqualsLayout layout = new EqualsLayout(5);
        buttonPane.setLayout(layout);
        layout.setMinWidth(100);
        bottomPane.add((Component)buttonPane, "6, 4, fill, top");
        JButton okButton = new JButton(BUNDLE.getString("Button.ok"));
        okButton.setAction(this.actionOK);
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton btnAddFile = new JButton(BUNDLE.getString("Button.addfile"));
        btnAddFile.setAction(this.actionLocalFile);
        buttonPane.add(btnAddFile);
        JButton cancelButton = new JButton(BUNDLE.getString("Button.cancel"));
        cancelButton.setAction(this.actionCancel);
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        this.task = new DownloadTask(ids, this.artworkScrapers);
        this.task.execute();
    }

    private void startProgressBar(String description) {
        this.lblProgressAction.setText(description);
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(true);
    }

    private void stopProgressBar() {
        this.lblProgressAction.setText("");
        this.progressBar.setVisible(false);
        this.progressBar.setIndeterminate(false);
    }

    private void addImage(BufferedImage originalImage, final MediaArtwork artwork) {
        JCheckBox chkbx;
        JLabel label;
        Point size = null;
        GridBagLayout gbl = new GridBagLayout();
        switch (this.type) {
            case FANART: 
            case CLEARART: 
            case DISC: 
            case THUMB: {
                gbl.columnWidths = new int[]{130};
                gbl.rowHeights = new int[]{180};
                size = ImageCache.calculateSize(300, 150, originalImage.getWidth(), originalImage.getHeight(), true);
                break;
            }
            case BANNER: 
            case LOGO: 
            case CLEARLOGO: {
                gbl.columnWidths = new int[]{130};
                gbl.rowHeights = new int[]{120};
                size = ImageCache.calculateSize(300, 100, originalImage.getWidth(), originalImage.getHeight(), true);
                break;
            }
            default: {
                gbl.columnWidths = new int[]{180};
                gbl.rowHeights = new int[]{270};
                size = ImageCache.calculateSize(150, 250, originalImage.getWidth(), originalImage.getHeight(), true);
            }
        }
        gbl.columnWeights = new double[]{Double.MIN_VALUE};
        gbl.rowWeights = new double[]{Double.MIN_VALUE};
        JPanel imagePanel = new JPanel();
        imagePanel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(5, 5, 5, 5);
        JToggleButton button = new JToggleButton();
        button.setBackground(Color.white);
        button.setUI((ButtonUI)((Object)this.toggleButtonUI));
        button.setMargin(new Insets(10, 10, 10, 10));
        ImageIcon imageIcon = new ImageIcon(Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.BALANCED, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)size.x, (int)size.y, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS}));
        button.setIcon(imageIcon);
        button.putClientProperty("MediaArtwork", artwork);
        this.buttonGroup.add(button);
        this.buttons.add(button);
        imagePanel.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 25;
        gbc.insets = new Insets(0, 5, 0, 0);
        JComboBox<Object> cb = null;
        cb = artwork.getImageSizes().size() > 0 ? new JComboBox<Object>(artwork.getImageSizes().toArray()) : new JComboBox<String>(new String[]{originalImage.getWidth() + "x" + originalImage.getHeight()});
        button.putClientProperty("MediaArtworkSize", cb);
        imagePanel.add(cb, gbc);
        if (this.mediaType == MediaType.MOVIE && this.type == ImageType.FANART && MovieModuleManager.MOVIE_SETTINGS.isImageExtraThumbs()) {
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.anchor = 22;
            label = new JLabel("Extrathumb");
            imagePanel.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.anchor = 22;
            chkbx = new JCheckBox();
            button.putClientProperty("MediaArtworkExtrathumb", chkbx);
            imagePanel.add((Component)chkbx, gbc);
        }
        if (this.mediaType == MediaType.MOVIE && this.type == ImageType.FANART && MovieModuleManager.MOVIE_SETTINGS.isImageExtraFanart()) {
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = MovieModuleManager.MOVIE_SETTINGS.isImageExtraThumbs() ? 2 : 1;
            gbc.anchor = 22;
            label = new JLabel("Extrafanart");
            imagePanel.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = MovieModuleManager.MOVIE_SETTINGS.isImageExtraThumbs() ? 2 : 1;
            gbc.anchor = 22;
            chkbx = new JCheckBox();
            button.putClientProperty("MediaArtworkExtrafanart", chkbx);
            imagePanel.add((Component)chkbx, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 25;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        JButton btnShowImage = new JButton("<html><font color=\"#0000CF\"><u>" + BUNDLE.getString("image.showoriginal") + "</u></font></html>");
        btnShowImage.setBorderPainted(false);
        btnShowImage.setFocusPainted(false);
        btnShowImage.setContentAreaFilled(false);
        btnShowImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImagePreviewDialog dialog = new ImagePreviewDialog(artwork.getDefaultUrl());
                dialog.setVisible(true);
            }
        });
        imagePanel.add((Component)btnShowImage, gbc);
        this.panelImages.add(imagePanel);
        this.panelImages.validate();
        this.panelImages.getParent().validate();
    }

    private void downloadAndPreviewImage(String url) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    MediaArtwork art;
                    switch (ImageChooserDialog.this.type) {
                        case BANNER: {
                            art = new MediaArtwork("", MediaArtwork.MediaArtworkType.BANNER);
                            break;
                        }
                        case CLEARART: {
                            art = new MediaArtwork("", MediaArtwork.MediaArtworkType.CLEARART);
                            break;
                        }
                        case DISC: {
                            art = new MediaArtwork("", MediaArtwork.MediaArtworkType.DISC);
                            break;
                        }
                        case FANART: {
                            art = new MediaArtwork("", MediaArtwork.MediaArtworkType.BACKGROUND);
                            break;
                        }
                        case LOGO: {
                            art = new MediaArtwork("", MediaArtwork.MediaArtworkType.LOGO);
                            break;
                        }
                        case CLEARLOGO: {
                            art = new MediaArtwork("", MediaArtwork.MediaArtworkType.CLEARLOGO);
                            break;
                        }
                        case POSTER: {
                            art = new MediaArtwork("", MediaArtwork.MediaArtworkType.POSTER);
                            break;
                        }
                        case SEASON: {
                            art = new MediaArtwork("", MediaArtwork.MediaArtworkType.SEASON);
                            break;
                        }
                        case THUMB: {
                            art = new MediaArtwork("", MediaArtwork.MediaArtworkType.THUMB);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    art.setDefaultUrl(ImageChooserDialog.this.tfImageUrl.getText());
                    art.setPreviewUrl(ImageChooserDialog.this.tfImageUrl.getText());
                    Url url = new Url(art.getPreviewUrl());
                    final BufferedImage bufferedImage = ImageCache.createImage(url.getBytes());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ImageChooserDialog.this.addImage(bufferedImage, art);
                            JScrollBar vertical = ImageChooserDialog.this.scrollPane.getVerticalScrollBar();
                            vertical.setValue(vertical.getMaximum());
                        }
                    });
                    ImageChooserDialog.this.tfImageUrl.setText("");
                }
                catch (Exception e) {
                    LOGGER.error("could not download manually entered image url: " + ImageChooserDialog.this.tfImageUrl.getText());
                }
            }
        };
        task.run();
    }

    @Override
    public void pack() {
    }

    private class LocalFileChooseAction
    extends AbstractAction {
        private static final long serialVersionUID = -1178325861474276709L;

        public LocalFileChooseAction() {
            this.putValue("Name", BUNDLE.getString("image.choose.file"));
            this.putValue("ShortDescription", BUNDLE.getString("image.choose.file"));
            this.putValue("SmallIcon", IconManager.FILE_OPEN);
            this.putValue("SwingLargeIconKey", IconManager.FILE_OPEN);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String path = TmmProperties.getInstance().getProperty("imageChooser.path");
            Path file = TmmUIHelper.selectFile(BUNDLE.getString("image.choose"), path);
            if (file != null && Utils.isRegularFile(file)) {
                String fileName = file.toAbsolutePath().toString();
                ImageChooserDialog.this.imageLabel.clearImage();
                ImageChooserDialog.this.imageLabel.setImageUrl("file:/" + fileName);
                ImageChooserDialog.this.task.cancel(true);
                TmmProperties.getInstance().putProperty("imageChooser.path", fileName);
                ImageChooserDialog.this.setVisible(false);
            }
        }
    }

    private class DownloadChunk {
        private BufferedImage image;
        private MediaArtwork artwork;

        private DownloadChunk() {
        }
    }

    private class DownloadTask
    extends SwingWorker<Void, DownloadChunk> {
        private HashMap<String, Object> ids;
        private List<MediaScraper> artworkScrapers;
        private boolean imagesFound = false;

        public DownloadTask(HashMap<String, Object> ids, List<MediaScraper> artworkScrapers) {
            this.ids = ids;
            this.artworkScrapers = artworkScrapers;
        }

        @Override
        public Void doInBackground() {
            if (this.ids.isEmpty()) {
                JOptionPane.showMessageDialog(null, BUNDLE.getString("image.download.noid"));
                return null;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageChooserDialog.this.startProgressBar(BUNDLE.getString("image.download.progress"));
                }
            });
            if (this.artworkScrapers == null || this.artworkScrapers.size() == 0) {
                return null;
            }
            for (MediaScraper scraper : this.artworkScrapers) {
                try {
                    IMediaArtworkProvider artworkProvider = (IMediaArtworkProvider)scraper.getMediaProvider();
                    MediaScrapeOptions options = new MediaScrapeOptions(ImageChooserDialog.this.mediaType);
                    if (ImageChooserDialog.this.mediaType == MediaType.MOVIE || ImageChooserDialog.this.mediaType == MediaType.MOVIE_SET) {
                        options.setLanguage(LocaleUtils.toLocale((String)MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().name()));
                        options.setCountry(MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry());
                        options.setFanartSize(MovieModuleManager.MOVIE_SETTINGS.getImageFanartSize());
                        options.setPosterSize(MovieModuleManager.MOVIE_SETTINGS.getImagePosterSize());
                    } else {
                        if (ImageChooserDialog.this.mediaType != MediaType.TV_SHOW) continue;
                        options.setLanguage(LocaleUtils.toLocale((String)TvShowModuleManager.SETTINGS.getScraperLanguage().name()));
                        options.setCountry(TvShowModuleManager.SETTINGS.getCertificationCountry());
                    }
                    switch (ImageChooserDialog.this.type) {
                        case POSTER: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.POSTER);
                            break;
                        }
                        case FANART: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.BACKGROUND);
                            break;
                        }
                        case BANNER: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.BANNER);
                            break;
                        }
                        case SEASON: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.SEASON);
                            break;
                        }
                        case CLEARART: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.CLEARART);
                            break;
                        }
                        case DISC: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.DISC);
                            break;
                        }
                        case LOGO: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.LOGO);
                            break;
                        }
                        case CLEARLOGO: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.CLEARLOGO);
                            break;
                        }
                        case THUMB: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.THUMB);
                        }
                    }
                    for (Map.Entry<String, Object> entry : this.ids.entrySet()) {
                        Object v = entry.getValue();
                        if (v == null) continue;
                        options.setId(entry.getKey(), v.toString());
                    }
                    List artwork = artworkProvider.getArtwork(options);
                    if (artwork == null) continue;
                    for (MediaArtwork art : artwork) {
                        if (this.isCancelled()) {
                            return null;
                        }
                        Url url = null;
                        try {
                            url = new Url(art.getPreviewUrl());
                            BufferedImage bufferedImage = ImageCache.createImage(url.getBytes());
                            DownloadChunk chunk = new DownloadChunk();
                            chunk.artwork = art;
                            chunk.image = bufferedImage;
                            this.publish(chunk);
                            this.imagesFound = true;
                        }
                        catch (InterruptedException ingored) {
                            LOGGER.warn("Thread interrupted");
                        }
                        catch (Exception e) {
                            LOGGER.error("DownloadTask displaying", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("DownloadTask", (Throwable)e);
                }
            }
            return null;
        }

        @Override
        protected void process(List<DownloadChunk> chunks) {
            for (DownloadChunk chunk : chunks) {
                ImageChooserDialog.this.addImage(chunk.image, chunk.artwork);
            }
        }

        @Override
        public void done() {
            if (!this.imagesFound) {
                JLabel lblNothingFound = new JLabel(BUNDLE.getString("image.download.nothingfound"));
                TmmFontHelper.changeFont((JComponent)lblNothingFound, 1.33);
                ImageChooserDialog.this.panelImages.add(lblNothingFound);
                ImageChooserDialog.this.panelImages.validate();
                ImageChooserDialog.this.panelImages.getParent().validate();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageChooserDialog.this.stopProgressBar();
                }
            });
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 403327079655572423L;

        public CancelAction() {
            this.putValue("Name", BUNDLE.getString("Button.cancel"));
            this.putValue("ShortDescription", BUNDLE.getString("Button.cancel"));
            this.putValue("SmallIcon", IconManager.CANCEL);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageChooserDialog.this.task.cancel(true);
            ImageChooserDialog.this.setVisible(false);
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = -1255049344169945137L;

        public OkAction() {
            this.putValue("Name", BUNDLE.getString("Button.ok"));
            this.putValue("ShortDescription", BUNDLE.getString("image.seteselected"));
            this.putValue("SmallIcon", IconManager.APPLY);
            this.putValue("SwingLargeIconKey", IconManager.APPLY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaArtwork artwork = null;
            MediaArtwork.ImageSizeAndUrl resolution = null;
            for (JToggleButton button : ImageChooserDialog.this.buttons) {
                JComboBox cb;
                Object clientProperty;
                if (!button.isSelected() || !((clientProperty = button.getClientProperty("MediaArtwork")) instanceof MediaArtwork)) continue;
                artwork = (MediaArtwork)clientProperty;
                clientProperty = button.getClientProperty("MediaArtworkSize");
                if (!(clientProperty instanceof JComboBox) || !((cb = (JComboBox)clientProperty).getSelectedItem() instanceof MediaArtwork.ImageSizeAndUrl)) break;
                resolution = (MediaArtwork.ImageSizeAndUrl)cb.getSelectedItem();
                break;
            }
            if (artwork == null) {
                JOptionPane.showMessageDialog(null, BUNDLE.getString("image.noneselected"));
                return;
            }
            if (artwork != null) {
                ImageChooserDialog.this.imageLabel.clearImage();
                if (resolution != null) {
                    ImageChooserDialog.this.imageLabel.setImageUrl(resolution.getUrl());
                } else {
                    ImageChooserDialog.this.imageLabel.setImageUrl(artwork.getDefaultUrl());
                }
            }
            if (ImageChooserDialog.this.mediaType == MediaType.MOVIE && ImageChooserDialog.this.type == ImageType.FANART && ImageChooserDialog.this.extraThumbs != null && MovieModuleManager.MOVIE_SETTINGS.isImageExtraThumbs()) {
                this.processExtraThumbs();
            }
            if (ImageChooserDialog.this.mediaType == MediaType.MOVIE && ImageChooserDialog.this.type == ImageType.FANART && ImageChooserDialog.this.extraThumbs != null && MovieModuleManager.MOVIE_SETTINGS.isImageExtraFanart()) {
                this.processExtraFanart();
            }
            ImageChooserDialog.this.task.cancel(true);
            ImageChooserDialog.this.setVisible(false);
        }

        private void processExtraThumbs() {
            ImageChooserDialog.this.extraThumbs.clear();
            for (JToggleButton button : ImageChooserDialog.this.buttons) {
                JCheckBox chkbx;
                if (!(button.getClientProperty("MediaArtworkExtrathumb") instanceof JCheckBox) || !(button.getClientProperty("MediaArtwork") instanceof MediaArtwork) || !(button.getClientProperty("MediaArtworkSize") instanceof JComboBox) || !(chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrathumb")).isSelected()) continue;
                MediaArtwork artwork = (MediaArtwork)button.getClientProperty("MediaArtwork");
                JComboBox cb = (JComboBox)button.getClientProperty("MediaArtworkSize");
                if (cb.getSelectedItem() instanceof MediaArtwork.ImageSizeAndUrl) {
                    MediaArtwork.ImageSizeAndUrl size = (MediaArtwork.ImageSizeAndUrl)cb.getSelectedItem();
                    if (size != null) {
                        ImageChooserDialog.this.extraThumbs.add(size.getUrl());
                        continue;
                    }
                    ImageChooserDialog.this.extraThumbs.add(artwork.getDefaultUrl());
                    continue;
                }
                if (!(cb.getSelectedItem() instanceof String)) continue;
                ImageChooserDialog.this.extraThumbs.add(artwork.getDefaultUrl());
            }
        }

        private void processExtraFanart() {
            ImageChooserDialog.this.extraFanarts.clear();
            for (JToggleButton button : ImageChooserDialog.this.buttons) {
                JCheckBox chkbx;
                if (!(button.getClientProperty("MediaArtworkExtrafanart") instanceof JCheckBox) || !(button.getClientProperty("MediaArtwork") instanceof MediaArtwork) || !(button.getClientProperty("MediaArtworkSize") instanceof JComboBox) || !(chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrafanart")).isSelected()) continue;
                MediaArtwork artwork = (MediaArtwork)button.getClientProperty("MediaArtwork");
                JComboBox cb = (JComboBox)button.getClientProperty("MediaArtworkSize");
                if (cb.getSelectedItem() instanceof MediaArtwork.ImageSizeAndUrl) {
                    MediaArtwork.ImageSizeAndUrl size = (MediaArtwork.ImageSizeAndUrl)cb.getSelectedItem();
                    if (size != null) {
                        ImageChooserDialog.this.extraFanarts.add(size.getUrl());
                        continue;
                    }
                    ImageChooserDialog.this.extraFanarts.add(artwork.getDefaultUrl());
                    continue;
                }
                if (!(cb.getSelectedItem() instanceof String)) continue;
                ImageChooserDialog.this.extraFanarts.add(artwork.getDefaultUrl());
            }
        }
    }

    public static enum ImageType {
        POSTER,
        FANART,
        BANNER,
        SEASON,
        LOGO,
        CLEARLOGO,
        CLEARART,
        DISC,
        THUMB;

    }
}

