/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class VerticalTextIcon
extends JComponent
implements Icon,
SwingConstants {
    private static final long serialVersionUID = -1386867808010437959L;
    private FontMetrics fm;
    private String text;
    private int width;
    private int height;
    private boolean clockwize;

    public VerticalTextIcon(String text, boolean clockwize) {
        Font font = UIManager.getFont("Label.font").deriveFont(1);
        this.fm = this.getFontMetrics(font);
        this.text = text;
        this.width = SwingUtilities.computeStringWidth(this.fm, text);
        this.height = this.fm.getHeight();
        this.clockwize = clockwize;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        Color oldColor = g.getColor();
        AffineTransform oldTransform = g2.getTransform();
        Object oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        g.setColor(Color.black);
        if (this.clockwize) {
            g2.translate(x + this.getIconWidth(), y);
            g2.rotate(1.5707963267948966);
        } else {
            g2.translate(x, y + this.getIconHeight());
            g2.rotate(-1.5707963267948966);
        }
        int offset = (this.width - this.getFontMetrics(g2.getFont()).stringWidth(this.text)) / 2;
        try {
            Class<?> swingUtilities2Class = Class.forName("sun.swing.SwingUtilities2");
            Class[] classParams = new Class[]{JComponent.class, Graphics.class, String.class, Integer.TYPE, Integer.TYPE};
            Method m = swingUtilities2Class.getMethod("drawString", classParams);
            Object[] methodParams = new Object[]{c, g, this.text, offset, this.fm.getLeading() + this.fm.getAscent()};
            m.invoke(null, methodParams);
        }
        catch (Exception ex) {
            g.drawString(this.text, offset, this.fm.getLeading() + this.fm.getAscent());
        }
        g.setColor(oldColor);
        g2.setTransform(oldTransform);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
    }

    @Override
    public int getIconWidth() {
        return this.height;
    }

    @Override
    public int getIconHeight() {
        return this.width;
    }

    public static JTabbedPane createTabbedPane(int tabPlacement) {
        switch (tabPlacement) {
            case 2: 
            case 4: {
                Object textIconGap = UIManager.get("TabbedPane.textIconGap");
                Insets tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
                UIManager.put("TabbedPane.textIconGap", 1);
                UIManager.put("TabbedPane.tabInsets", new Insets(tabInsets.left, tabInsets.top, tabInsets.right, tabInsets.bottom));
                JTabbedPane tabPane = new JTabbedPane(tabPlacement);
                UIManager.put("TabbedPane.textIconGap", textIconGap);
                UIManager.put("TabbedPane.tabInsets", tabInsets);
                return tabPane;
            }
        }
        return new JTabbedPane(tabPlacement);
    }

    public static void addTab(JTabbedPane tabPane, String text, Component comp) {
        int tabPlacement = tabPane.getTabPlacement();
        switch (tabPlacement) {
            case 2: 
            case 4: {
                tabPane.addTab(null, new VerticalTextIcon(text, tabPlacement == 4), comp);
                return;
            }
        }
        tabPane.addTab(text, null, comp);
    }
}

