/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskListener;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIMessageCollector;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.PopupPane;
import org.tinymediamanager.ui.components.TaskListComponent;
import org.tinymediamanager.ui.dialogs.MessageHistoryDialog;

public class StatusBar
extends JPanel
implements TmmTaskListener {
    private static final long serialVersionUID = -6375900257553323558L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private Map<TmmTaskHandle, TaskListComponent> taskMap;
    private TmmTaskHandle activeTask;
    private JProgressBar bar;
    private JLabel label;
    private JButton closeButton;
    private JPopupMenu popup;
    private PopupPane pane;
    private JButton btnNotifications;
    private Component verticalStrut;
    private JLabel memory;

    public StatusBar() {
        this.initComponents();
    }

    private void initComponents() {
        this.taskMap = new HashMap<TmmTaskHandle, TaskListComponent>();
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, ColumnSpec.decode((String)"15dlu"), FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC}, new RowSpec[]{FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC}));
        this.label = new JLabel();
        this.bar = new JProgressBar();
        this.bar.addMouseListener(new MListener());
        this.closeButton = new JButton(IconManager.PROCESS_STOP);
        this.closeButton.setBorderPainted(false);
        this.closeButton.setBorder(BorderFactory.createEmptyBorder());
        this.closeButton.setOpaque(false);
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.setAction(new CancelAction());
        this.label.setText("XYZ");
        this.bar.setString("XYZ");
        this.verticalStrut = Box.createVerticalStrut(Math.max(Math.max(this.label.getPreferredSize().height, this.bar.getPreferredSize().height), this.closeButton.getPreferredSize().height));
        this.bar.setString(null);
        this.label.setText(null);
        this.pane = new PopupPane();
        this.pane.getActionMap().put("HidePopup", new AbstractAction(){
            private static final long serialVersionUID = -5945688032617664909L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatusBar.this.hidePopup();
            }
        });
        this.pane.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "HidePopup");
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "HidePopup");
        this.memory = new JLabel(this.printMemory());
        this.add((Component)this.memory, "2, 2");
        this.add(this.verticalStrut, "4, 2");
        this.add((Component)this.label, "5, 2");
        this.add((Component)this.bar, "7, 2");
        this.add((Component)this.closeButton, "9, 2");
        this.label.setVisible(false);
        this.bar.setVisible(false);
        this.closeButton.setVisible(false);
        this.popup = new JPopupMenu();
        this.popup.setInvoker(this.bar);
        this.popup.add(this.pane);
        TmmTaskManager.getInstance().addTaskListener(this);
        this.btnNotifications = new JButton(IconManager.INFO);
        this.btnNotifications.setBorderPainted(false);
        this.btnNotifications.setOpaque(false);
        this.btnNotifications.setContentAreaFilled(false);
        this.btnNotifications.setBorder(BorderFactory.createEmptyBorder());
        this.btnNotifications.setFocusPainted(false);
        this.btnNotifications.setVisible(false);
        this.btnNotifications.setEnabled(false);
        this.btnNotifications.setToolTipText(BUNDLE.getString("notifications.new"));
        this.btnNotifications.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                StatusBar.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                StatusBar.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.btnNotifications.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageHistoryDialog dialog = MessageHistoryDialog.getInstance();
                dialog.setVisible(true);
            }
        });
        this.add((Component)this.btnNotifications, "11, 2");
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("messages".equals(evt.getPropertyName())) {
                    if (TmmUIMessageCollector.instance.getNewMessagesCount() > 0) {
                        StatusBar.this.btnNotifications.setVisible(true);
                        StatusBar.this.btnNotifications.setEnabled(true);
                        StatusBar.this.btnNotifications.setText("" + TmmUIMessageCollector.instance.getNewMessagesCount());
                    } else {
                        StatusBar.this.btnNotifications.setVisible(false);
                        StatusBar.this.btnNotifications.setEnabled(false);
                    }
                    StatusBar.this.btnNotifications.repaint();
                }
            }
        };
        TmmUIMessageCollector.instance.addPropertyChangeListener(propertyChangeListener);
        Timer m = new Timer(2000, null);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusBar.this.memory.setText(StatusBar.this.printMemory());
            }
        };
        m.addActionListener(listener);
        m.start();
    }

    public void showPopup() {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        if (this.taskMap.size() == 0) {
            return;
        }
        this.resizePopup();
        this.popup.setVisible(true);
    }

    public void hidePopup() {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
    }

    private void resizePopup() {
        this.pane.invalidate();
        this.popup.pack();
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, this);
        Dimension dim = this.popup.getPreferredSize();
        Rectangle usableRect = this.getUsableScreenBounds();
        Point loc = new Point(point.x + this.getSize().width - dim.width - 10, point.y - dim.height - 5);
        if (!usableRect.contains(loc)) {
            loc = new Point(loc.x, point.y + 5 + this.getSize().height);
        }
        this.popup.setLocation(loc);
    }

    private Rectangle getUsableScreenBounds() {
        GraphicsConfiguration gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Rectangle bounds = new Rectangle(gconf.getBounds());
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Insets insets = toolkit.getScreenInsets(gconf);
            bounds.y += insets.top;
            bounds.x += insets.left;
            bounds.height -= insets.top + insets.bottom;
            bounds.width -= insets.left + insets.right;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bounds;
    }

    @Override
    public synchronized void processTaskEvent(final TmmTaskHandle task) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (task.getState() == TmmTaskHandle.TaskState.CREATED || task.getState() == TmmTaskHandle.TaskState.QUEUED) {
                    StatusBar.this.createListItem(task);
                } else if (task.getState() == TmmTaskHandle.TaskState.STARTED) {
                    TaskListComponent comp = (TaskListComponent)StatusBar.this.taskMap.get(task);
                    if (comp == null) {
                        StatusBar.this.createListItem(task);
                        comp = (TaskListComponent)StatusBar.this.taskMap.get(task);
                    }
                    comp.updateTaskInformation();
                } else if (task.getState() == TmmTaskHandle.TaskState.CANCELLED || task.getState() == TmmTaskHandle.TaskState.FINISHED) {
                    StatusBar.this.removeListItem(task);
                }
                if (StatusBar.this.activeTask == null || StatusBar.this.activeTask.getState() == TmmTaskHandle.TaskState.FINISHED || StatusBar.this.activeTask.getState() == TmmTaskHandle.TaskState.CANCELLED) {
                    TmmTaskHandle handle;
                    StatusBar.this.activeTask = null;
                    for (Map.Entry entry : StatusBar.this.taskMap.entrySet()) {
                        handle = (TmmTaskHandle)entry.getKey();
                        if (handle.getType() != TmmTaskHandle.TaskType.MAIN_TASK || handle.getState() != TmmTaskHandle.TaskState.STARTED) continue;
                        StatusBar.this.activeTask = handle;
                        break;
                    }
                    if (StatusBar.this.activeTask == null) {
                        for (Map.Entry entry : StatusBar.this.taskMap.entrySet()) {
                            handle = (TmmTaskHandle)entry.getKey();
                            if (handle.getState() != TmmTaskHandle.TaskState.STARTED) continue;
                            StatusBar.this.activeTask = handle;
                            break;
                        }
                    }
                }
                if (StatusBar.this.activeTask == null) {
                    StatusBar.this.label.setVisible(false);
                    StatusBar.this.closeButton.setVisible(false);
                    StatusBar.this.bar.setVisible(false);
                } else {
                    StatusBar.this.label.setVisible(true);
                    StatusBar.this.bar.setVisible(true);
                    if (StatusBar.this.activeTask.getType() == TmmTaskHandle.TaskType.MAIN_TASK) {
                        StatusBar.this.closeButton.setVisible(true);
                    } else {
                        StatusBar.this.closeButton.setVisible(false);
                    }
                    StatusBar.this.label.setText(StatusBar.this.activeTask.getTaskName());
                    if (StatusBar.this.activeTask.getWorkUnits() > 0) {
                        StatusBar.this.bar.setIndeterminate(false);
                        StatusBar.this.bar.setMaximum(StatusBar.this.activeTask.getWorkUnits());
                        StatusBar.this.bar.setValue(StatusBar.this.activeTask.getProgressDone());
                    } else {
                        StatusBar.this.bar.setIndeterminate(true);
                    }
                }
            }
        });
    }

    private void createListItem(TmmTaskHandle handle) {
        TaskListComponent comp;
        if (this.taskMap.containsKey(handle)) {
            comp = this.taskMap.get(handle);
        } else {
            comp = new TaskListComponent(handle);
            this.taskMap.put(handle, comp);
        }
        this.pane.addListComponent(comp);
        if (this.popup.isShowing()) {
            this.resizePopup();
        }
    }

    private void removeListItem(TmmTaskHandle handle) {
        this.taskMap.remove(handle);
        this.pane.removeListComponent(handle);
        if (this.popup.isShowing() && this.taskMap.isEmpty()) {
            this.hidePopup();
        } else if (this.popup.isShowing()) {
            this.resizePopup();
        }
    }

    private String printMemory() {
        Runtime rt = Runtime.getRuntime();
        long totalMem = rt.totalMemory();
        long maxMem = rt.maxMemory();
        long freeMem = rt.freeMemory();
        long megs = 0x100000L;
        long used = totalMem - freeMem;
        long free = maxMem - used;
        String phys = "";
        return "Memory used: " + used / megs + " MiB  /  free: " + free / megs + " MiB  /  max: " + maxMem / megs + " MiB" + phys;
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -3021931797641209077L;

        public CancelAction() {
            this.putValue("SmallIcon", IconManager.PROCESS_STOP);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (StatusBar.this.activeTask instanceof TmmTask) {
                StatusBar.this.activeTask.cancel();
            }
        }
    }

    private class MListener
    extends MouseAdapter {
        private MListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (StatusBar.this.popup.isShowing()) {
                StatusBar.this.hidePopup();
            } else {
                StatusBar.this.showPopup();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            StatusBar.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            StatusBar.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

