/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;

public class EnhancedTextField
extends JTextField
implements FocusListener {
    private static final long serialVersionUID = 5397356153111919435L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private Icon icon;
    private String textWhenNotFocused;
    private Insets dummyInsets;

    public EnhancedTextField() {
        this(null, null);
    }

    public EnhancedTextField(String textWhenNotFocused) {
        this(textWhenNotFocused, null);
    }

    public EnhancedTextField(Icon icon) {
        this(null, icon);
    }

    public EnhancedTextField(String textWhenNotFocused, Icon icon) {
        this.icon = icon != null ? icon : IconManager.EMPTY_IMAGE;
        this.textWhenNotFocused = textWhenNotFocused != null ? textWhenNotFocused : "";
        if (StringUtils.isNotBlank((CharSequence)textWhenNotFocused)) {
            this.addFocusListener(this);
        }
        Border border = UIManager.getBorder("TextField.border");
        JTextField dummy = new JTextField();
        this.dummyInsets = border.getBorderInsets(dummy);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int textX = 2;
        if (this.icon != null) {
            int iconWidth = this.icon.getIconWidth();
            int iconHeight = this.icon.getIconHeight();
            int x = this.getWidth() - this.dummyInsets.right - iconWidth - 5;
            textX = x + iconWidth + 2;
            int y = (this.getHeight() - iconHeight) / 2;
            this.icon.paintIcon(this, g, x, y);
        }
        this.setMargin(new Insets(2, textX, 2, 2));
        if (!this.hasFocus() && StringUtils.isEmpty((CharSequence)this.getText())) {
            int height = this.getHeight();
            Font prev = g.getFont();
            Font italic = prev.deriveFont(2);
            Color prevColor = g.getColor();
            g.setFont(italic);
            g.setColor(UIManager.getColor("textInactiveText"));
            int h = g.getFontMetrics().getHeight();
            int textBottom = (height - h) / 2 + h - 4;
            int x = this.getInsets().left;
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints hints = g2d.getRenderingHints();
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.drawString(this.textWhenNotFocused, x, textBottom);
            g2d.setRenderingHints(hints);
            g.setFont(prev);
            g.setColor(prevColor);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    public static EnhancedTextField createSearchTextField() {
        return new EnhancedTextField(BUNDLE.getString("tmm.searchfield"), null);
    }
}

