/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;

public class MediaIdUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaIdUtil.class);

    public static String getImdbIdFromTvdbId(String tvdbId) {
        if (StringUtils.isBlank((CharSequence)tvdbId)) {
            return "";
        }
        String imdbId = "";
        try {
            MediaScraper scraper = MediaScraper.getMediaScraperById("tvdb", ScraperType.TV_SHOW);
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.TV_SHOW);
            options.setId("tvdb", tvdbId);
            MediaMetadata md = ((ITvShowMetadataProvider)scraper.getMediaProvider()).getMetadata(options);
            imdbId = (String)md.getId("imdb");
        }
        catch (Exception e) {
            LOGGER.error("could not get imdb id from tvdb id: " + e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            return "";
        }
        return imdbId;
    }
}

