/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakttv;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.TraktV2Interceptor;
import com.uwetrottmann.trakt5.entities.AccessToken;
import com.uwetrottmann.trakt5.entities.BaseEpisode;
import com.uwetrottmann.trakt5.entities.BaseMovie;
import com.uwetrottmann.trakt5.entities.BaseSeason;
import com.uwetrottmann.trakt5.entities.BaseShow;
import com.uwetrottmann.trakt5.entities.MovieIds;
import com.uwetrottmann.trakt5.entities.ShowIds;
import com.uwetrottmann.trakt5.entities.SyncEpisode;
import com.uwetrottmann.trakt5.entities.SyncErrors;
import com.uwetrottmann.trakt5.entities.SyncItems;
import com.uwetrottmann.trakt5.entities.SyncMovie;
import com.uwetrottmann.trakt5.entities.SyncResponse;
import com.uwetrottmann.trakt5.entities.SyncSeason;
import com.uwetrottmann.trakt5.entities.SyncShow;
import com.uwetrottmann.trakt5.entities.SyncStats;
import com.uwetrottmann.trakt5.enums.Extended;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.util.ApiKey;
import retrofit2.Response;

public class TraktTv {
    private static final String CLIENT_ID = "a8e7e30fd7fd3f397b6e079f9f023e790f9cbd80a2be57c104089174fa8c6d89";
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktTv.class);
    private static final TraktV2 TRAKT = TraktTv.createTraktApi();
    private static TraktTv instance;
    private static MediaProviderInfo providerInfo;

    private static TraktV2 createTraktApi() {
        TraktV2 api = new TraktV2(CLIENT_ID, ApiKey.decryptApikey((String)"VD2h4jmnrrYWnP1Nk49UtTNRILiWsuelJKdza7DAw+ROh1wtVf2U6PQScm7QWCOTsxN0K3QluIykKs2ZT1af1GcPz1401005bDBDss1Pz2c="), "urn:ietf:wg:oauth:2.0:oob"){

            protected synchronized OkHttpClient okHttpClient() {
                OkHttpClient.Builder builder = TmmHttpClient.newBuilder();
                builder.addInterceptor((Interceptor)new TraktV2Interceptor((TraktV2)this));
                return builder.build();
            }
        };
        return api;
    }

    public static synchronized TraktTv getInstance() {
        if (instance == null) {
            instance = new TraktTv();
        }
        return instance;
    }

    public static Map<String, String> authenticateViaPin(String pin) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Response response = TRAKT.exchangeCodeForAccessToken(pin);
        String accessToken = ((AccessToken)response.body()).access_token;
        String refreshToken = ((AccessToken)response.body()).refresh_token;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken, refreshToken})) {
            result.put("accessToken", accessToken);
            result.put("refreshToken", refreshToken);
        }
        return result;
    }

    public static void refreshAccessToken() throws Exception {
        if (StringUtils.isBlank((CharSequence)Globals.settings.getTraktRefreshToken())) {
            throw new Exception("not trakt.tv refresh token found");
        }
        Response response = TRAKT.refreshToken(Globals.settings.getTraktRefreshToken()).refreshAccessToken();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{((AccessToken)response.body()).access_token, ((AccessToken)response.body()).refresh_token})) {
            Globals.settings.setTraktAccessToken(((AccessToken)response.body()).access_token);
            Globals.settings.setTraktRefreshToken(((AccessToken)response.body()).refresh_token);
            TRAKT.accessToken(Globals.settings.getTraktAccessToken());
        }
    }

    private boolean isEnabled() {
        if (!Globals.isDonator()) {
            LOGGER.warn("Won't spawn TRAKT.TV since you are not a donator!");
            return false;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{Globals.settings.getTraktAccessToken(), Globals.settings.getTraktRefreshToken()})) {
            TRAKT.accessToken(Globals.settings.getTraktAccessToken());
            return true;
        }
        return false;
    }

    public void syncTraktMovieCollection(List<Movie> moviesInTmm) {
        List traktMovies;
        if (!this.isEnabled()) {
            return;
        }
        ArrayList<Movie> tmmMovies = new ArrayList<Movie>(moviesInTmm);
        LOGGER.info("got up to " + tmmMovies.size() + " movies for Trakt.tv collection sync");
        try {
            Response response = TRAKT.sync().collectionMovies(Extended.DEFAULT_MIN).execute();
            if (!response.isSuccessful() && response.code() == 401) {
                TraktTv.refreshAccessToken();
                response = TRAKT.sync().collectionMovies(Extended.DEFAULT_MIN).execute();
            }
            if (!response.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + response.message());
                return;
            }
            traktMovies = (List)response.body();
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
            return;
        }
        LOGGER.info("You have " + traktMovies.size() + " movies in your Trakt.tv collection");
        for (BaseMovie traktMovie : traktMovies) {
            for (int i = tmmMovies.size() - 1; i >= 0; --i) {
                Movie tmmMovie = (Movie)tmmMovies.get(i);
                if (!this.matches(tmmMovie, traktMovie.movie.ids)) continue;
                boolean dirty = this.updateIDs(tmmMovie, traktMovie.movie.ids);
                if (traktMovie.collected_at != null && !traktMovie.collected_at.toDate().equals(tmmMovie.getDateAdded())) {
                    LOGGER.trace("Marking movie '" + tmmMovie.getTitle() + "' as collected on " + traktMovie.collected_at.toDate() + " (was " + tmmMovie.getDateAddedAsString() + ")");
                    tmmMovie.setDateAdded(traktMovie.collected_at.toDate());
                    dirty = true;
                }
                if (dirty) {
                    tmmMovie.writeNFO();
                    tmmMovie.saveToDb();
                }
                tmmMovies.remove(i);
            }
        }
        if (tmmMovies.size() == 0) {
            LOGGER.info("Already up-to-date - no need to add anything :)");
            return;
        }
        LOGGER.debug("prepare " + tmmMovies.size() + " movies for Trakt.tv collection sync");
        ArrayList<SyncMovie> movies = new ArrayList<SyncMovie>();
        int nosync = 0;
        for (Movie tmmMovie : tmmMovies) {
            if (tmmMovie.getIdAsInt(providerInfo.getId()) != 0 || !tmmMovie.getIdAsString("imdb").isEmpty() || tmmMovie.getIdAsInt("tmdb") != 0) {
                movies.add(this.toSyncMovie(tmmMovie, false));
                continue;
            }
            ++nosync;
        }
        if (nosync > 0) {
            LOGGER.debug("skipping " + nosync + " movies, because they have not been scraped yet!");
        }
        if (movies.size() == 0) {
            LOGGER.info("no new movies for Trakt collection sync found.");
            return;
        }
        try {
            LOGGER.info("Adding " + movies.size() + " movies to Trakt.tv collection");
            SyncItems items = new SyncItems().movies(movies);
            Response response = TRAKT.sync().addItemsToCollection(items).execute();
            if (!response.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + response.message());
                return;
            }
            LOGGER.info("Trakt add-to-library status:");
            this.printStatus((SyncResponse)response.body());
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
            return;
        }
    }

    public void syncTraktMovieCollection() {
        if (!this.isEnabled()) {
            return;
        }
        this.syncTraktMovieCollection(new ArrayList<Movie>(MovieList.getInstance().getMovies()));
    }

    public void clearTraktMovies() {
        Response response;
        SyncItems items;
        List traktWatched;
        List traktCollection;
        try {
            Response traktCollectionResponse = TRAKT.sync().collectionMovies(Extended.DEFAULT_MIN).execute();
            if (!traktCollectionResponse.isSuccessful() && traktCollectionResponse.code() == 401) {
                TraktTv.refreshAccessToken();
                traktCollectionResponse = TRAKT.sync().collectionMovies(Extended.DEFAULT_MIN).execute();
            }
            if (!traktCollectionResponse.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + traktCollectionResponse.message());
                return;
            }
            traktCollection = (List)traktCollectionResponse.body();
            Response traktWatchedResponse = TRAKT.sync().watchedMovies(Extended.DEFAULT_MIN).execute();
            if (!traktWatchedResponse.isSuccessful() && traktWatchedResponse.code() == 401) {
                TraktTv.refreshAccessToken();
                traktWatchedResponse = TRAKT.sync().watchedMovies(Extended.DEFAULT_MIN).execute();
            }
            if (!traktWatchedResponse.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + traktWatchedResponse.message());
                return;
            }
            traktWatched = (List)traktWatchedResponse.body();
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
            return;
        }
        LOGGER.info("You have " + traktCollection.size() + " movies in your Trakt.tv collection");
        LOGGER.info("You have " + traktWatched.size() + " movies watched");
        ArrayList<SyncMovie> movieToRemove = new ArrayList<SyncMovie>();
        for (BaseMovie traktMovie : traktCollection) {
            movieToRemove.add(this.toSyncMovie(traktMovie));
        }
        if (!movieToRemove.isEmpty()) {
            try {
                items = new SyncItems().movies(movieToRemove);
                response = TRAKT.sync().deleteItemsFromCollection(items).execute();
                if (!response.isSuccessful()) {
                    LOGGER.error("failed syncing trakt: " + response.message());
                    return;
                }
                LOGGER.info("removed " + movieToRemove.size() + " movies from your trakt.tv collection");
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: " + e.getMessage());
                return;
            }
        }
        movieToRemove.clear();
        for (BaseMovie traktMovie : traktWatched) {
            movieToRemove.add(this.toSyncMovie(traktMovie));
        }
        if (!movieToRemove.isEmpty()) {
            try {
                items = new SyncItems().movies(movieToRemove);
                response = TRAKT.sync().deleteItemsFromWatchedHistory(items).execute();
                if (!response.isSuccessful()) {
                    LOGGER.error("failed syncing trakt: " + response.message());
                    return;
                }
                LOGGER.info("removed " + movieToRemove.size() + " movies from your trakt.tv watched");
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: " + e.getMessage());
                return;
            }
        }
    }

    public void syncTraktMovieWatched(List<Movie> moviesInTmm) {
        List traktMovies;
        if (!this.isEnabled()) {
            return;
        }
        ArrayList<Movie> tmmMovies = new ArrayList<Movie>(moviesInTmm);
        try {
            Response traktWatchedResponse = TRAKT.sync().watchedMovies(Extended.DEFAULT_MIN).execute();
            if (!traktWatchedResponse.isSuccessful() && traktWatchedResponse.code() == 401) {
                TraktTv.refreshAccessToken();
                traktWatchedResponse = TRAKT.sync().watchedMovies(Extended.DEFAULT_MIN).execute();
            }
            if (!traktWatchedResponse.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + traktWatchedResponse.message());
                return;
            }
            traktMovies = (List)traktWatchedResponse.body();
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
            return;
        }
        LOGGER.info("You have " + traktMovies.size() + " movies marked as 'watched' in your Trakt.tv collection");
        for (BaseMovie traktWatched : traktMovies) {
            for (Movie tmmMovie : tmmMovies) {
                if (!this.matches(tmmMovie, traktWatched.movie.ids)) continue;
                boolean dirty = this.updateIDs(tmmMovie, traktWatched.movie.ids);
                if (!tmmMovie.isWatched()) {
                    LOGGER.info("Marking movie '" + tmmMovie.getTitle() + "' as watched");
                    tmmMovie.setWatched(true);
                    dirty = true;
                }
                if (traktWatched.last_watched_at != null && !traktWatched.last_watched_at.toDate().equals(tmmMovie.getLastWatched())) {
                    LOGGER.trace("Marking movie '" + tmmMovie.getTitle() + "' as watched on " + traktWatched.last_watched_at.toDate() + " (was " + tmmMovie.getLastWatched() + ")");
                    tmmMovie.setLastWatched(traktWatched.last_watched_at.toDate());
                    dirty = true;
                }
                if (!dirty) continue;
                tmmMovie.writeNFO();
                tmmMovie.saveToDb();
            }
        }
        ArrayList<Movie> tmmWatchedMovies = new ArrayList<Movie>();
        for (Movie movie : tmmMovies) {
            if (!movie.isWatched()) continue;
            tmmWatchedMovies.add(movie);
        }
        LOGGER.info("You have now " + tmmWatchedMovies.size() + " movies marked as 'watched' in your TMM database");
        block7: for (int i = tmmWatchedMovies.size() - 1; i >= 0; --i) {
            for (BaseMovie traktWatched : traktMovies) {
                Movie tmmMovie = (Movie)tmmWatchedMovies.get(i);
                if (!this.matches(tmmMovie, traktWatched.movie.ids)) continue;
                tmmWatchedMovies.remove(i);
                continue block7;
            }
        }
        if (tmmWatchedMovies.size() == 0) {
            LOGGER.info("no new watched movies for Trakt sync found.");
            return;
        }
        LOGGER.debug("prepare " + tmmWatchedMovies.size() + " movies for Trakt.tv sync");
        ArrayList<SyncMovie> movies = new ArrayList<SyncMovie>();
        int nosync = 0;
        for (Movie tmmMovie : tmmWatchedMovies) {
            if (tmmMovie.getIdAsInt(providerInfo.getId()) != 0 || !tmmMovie.getIdAsString("imdb").isEmpty() || tmmMovie.getIdAsInt("tmdb") != 0) {
                movies.add(this.toSyncMovie(tmmMovie, true));
                continue;
            }
            ++nosync;
        }
        if (nosync > 0) {
            LOGGER.debug("skipping " + nosync + " movies, because they have not been scraped yet!");
        }
        if (movies.size() == 0) {
            LOGGER.info("no new watched movies for Trakt sync found.");
            return;
        }
        try {
            LOGGER.info("Marking " + movies.size() + " movies as 'watched' to Trakt.tv collection");
            SyncItems items = new SyncItems().movies(movies);
            Response response = TRAKT.sync().addItemsToWatchedHistory(items).execute();
            if (!response.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + response.message());
                return;
            }
            LOGGER.info("Trakt mark-as-watched status:");
            this.printStatus((SyncResponse)response.body());
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
            return;
        }
    }

    public void syncTraktMovieWatched() {
        if (!this.isEnabled()) {
            return;
        }
        this.syncTraktMovieWatched(MovieList.getInstance().getMovies());
    }

    public void syncTraktTvShowCollection(List<TvShow> tvShowsInTmm) {
        List traktShows;
        if (!this.isEnabled()) {
            return;
        }
        ArrayList<TvShow> tvShows = new ArrayList<TvShow>(tvShowsInTmm);
        try {
            Response response = TRAKT.sync().collectionShows(Extended.DEFAULT_MIN).execute();
            if (!response.isSuccessful() && response.code() == 401) {
                TraktTv.refreshAccessToken();
                response = TRAKT.sync().collectionShows(Extended.DEFAULT_MIN).execute();
            }
            if (!response.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + response.message());
                return;
            }
            traktShows = (List)response.body();
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
            return;
        }
        LOGGER.info("You have " + traktShows.size() + " TvShows in your Trakt.tv collection");
        HashSet<TvShowEpisode> episodesInTrakt = new HashSet<TvShowEpisode>();
        for (BaseShow traktShow : traktShows) {
            for (TvShow tmmShow : tvShows) {
                if (!this.matches(tmmShow, traktShow.show.ids)) continue;
                boolean dirty = this.updateIDs(tmmShow, traktShow.show.ids);
                if (traktShow.last_collected_at != null && !traktShow.last_collected_at.toDate().equals(tmmShow.getDateAdded())) {
                    LOGGER.trace("Marking TvShow '" + tmmShow.getTitle() + "' as collected on " + traktShow.last_collected_at.toDate() + " (was " + tmmShow.getDateAddedAsString() + ")");
                    tmmShow.setDateAdded(traktShow.last_collected_at.toDate());
                    dirty = true;
                }
                for (BaseSeason bs : traktShow.seasons) {
                    for (BaseEpisode be : bs.episodes) {
                        TvShowEpisode tmmEP = tmmShow.getEpisode(bs.number, be.number);
                        if (tmmEP == null) continue;
                        episodesInTrakt.add(tmmEP);
                        if (be.collected_at == null || be.collected_at.toDate().equals(tmmEP.getDateAdded())) continue;
                        tmmEP.setDateAdded(be.collected_at.toDate());
                        tmmEP.writeNFO();
                        tmmEP.saveToDb();
                    }
                }
                if (!dirty) continue;
                tmmShow.writeNFO();
                tmmShow.saveToDb();
            }
        }
        LOGGER.info("Adding " + tvShows.size() + " TvShows to Trakt.tv collection");
        for (TvShow tvShow : tvShows) {
            SyncShow show = this.toSyncShow(tvShow, false, episodesInTrakt);
            if (show == null) continue;
            try {
                SyncItems items = new SyncItems().shows(show);
                Response response = TRAKT.sync().addItemsToCollection(items).execute();
                if (!response.isSuccessful()) {
                    LOGGER.error("failed syncing trakt: " + response.message());
                    return;
                }
                LOGGER.debug("Trakt add-to-library status: " + tvShow.getTitle());
                this.printStatus((SyncResponse)response.body());
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: " + e.getMessage());
                return;
            }
        }
    }

    public void syncTraktTvShowCollection() {
        if (!this.isEnabled()) {
            return;
        }
        this.syncTraktTvShowCollection(new ArrayList<TvShow>(TvShowList.getInstance().getTvShows()));
    }

    public void syncTraktTvShowWatched(List<TvShow> tvShowsInTmm) {
        List traktShows;
        if (!this.isEnabled()) {
            return;
        }
        ArrayList<TvShow> tvShows = new ArrayList<TvShow>(tvShowsInTmm);
        try {
            Response response = TRAKT.sync().watchedShows(Extended.DEFAULT_MIN).execute();
            if (!response.isSuccessful() && response.code() == 401) {
                TraktTv.refreshAccessToken();
                response = TRAKT.sync().watchedShows(Extended.DEFAULT_MIN).execute();
            }
            if (!response.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + response.message());
                return;
            }
            traktShows = (List)response.body();
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
            return;
        }
        LOGGER.info("You have " + traktShows.size() + " TvShows marked as watched on Trakt.tv");
        for (BaseShow traktShow : traktShows) {
            for (TvShow tmmShow : tvShows) {
                if (!this.matches(tmmShow, traktShow.show.ids)) continue;
                boolean dirty = this.updateIDs(tmmShow, traktShow.show.ids);
                if (traktShow.last_watched_at != null && !traktShow.last_watched_at.toDate().equals(tmmShow.getLastWatched())) {
                    LOGGER.trace("Marking TvShow '" + tmmShow.getTitle() + "' as watched on " + traktShow.last_watched_at.toDate() + " (was " + tmmShow.getLastWatched() + ")");
                    tmmShow.setLastWatched(traktShow.last_watched_at.toDate());
                    dirty = true;
                }
                for (BaseSeason bs : traktShow.seasons) {
                    for (BaseEpisode be : bs.episodes) {
                        TvShowEpisode tmmEP = tmmShow.getEpisode(bs.number, be.number);
                        if (tmmEP == null || be.last_watched_at == null || be.last_watched_at.toDate().equals(tmmEP.getLastWatched())) continue;
                        tmmEP.setLastWatched(be.last_watched_at.toDate());
                        tmmEP.setWatched(true);
                        tmmEP.writeNFO();
                        tmmEP.saveToDb();
                    }
                }
                if (!dirty) continue;
                tmmShow.writeNFO();
                tmmShow.saveToDb();
            }
        }
        LOGGER.info("Adding up to " + tvShows.size() + " TvShows as watched on Trakt.tv");
        for (TvShow show : tvShows) {
            SyncShow sync = this.toSyncShow(show, true, new HashSet<TvShowEpisode>());
            if (sync == null) continue;
            try {
                SyncItems items = new SyncItems().shows(sync);
                Response response = TRAKT.sync().addItemsToWatchedHistory(items).execute();
                if (!response.isSuccessful()) {
                    LOGGER.error("failed syncing trakt: " + response.message());
                    return;
                }
                LOGGER.debug("Trakt add-to-library status: " + show.getTitle());
                this.printStatus((SyncResponse)response.body());
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: " + e.getMessage());
                return;
            }
        }
    }

    public void syncTraktTvShowWatched() {
        if (!this.isEnabled()) {
            return;
        }
        this.syncTraktTvShowWatched(new ArrayList<TvShow>(TvShowList.getInstance().getTvShows()));
    }

    public void clearTraktTvShows() {
        Response response;
        SyncItems items;
        List traktWatched;
        List traktCollection;
        try {
            Response traktCollectionResponse = TRAKT.sync().collectionShows(Extended.DEFAULT_MIN).execute();
            if (!traktCollectionResponse.isSuccessful() && traktCollectionResponse.code() == 401) {
                TraktTv.refreshAccessToken();
                traktCollectionResponse = TRAKT.sync().collectionShows(Extended.DEFAULT_MIN).execute();
            }
            if (!traktCollectionResponse.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + traktCollectionResponse.message());
                return;
            }
            traktCollection = (List)traktCollectionResponse.body();
            Response traktWatchedResponse = TRAKT.sync().watchedShows(Extended.DEFAULT_MIN).execute();
            if (!traktWatchedResponse.isSuccessful() && traktWatchedResponse.code() == 401) {
                TraktTv.refreshAccessToken();
                traktWatchedResponse = TRAKT.sync().watchedShows(Extended.DEFAULT_MIN).execute();
            }
            if (!traktWatchedResponse.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + traktWatchedResponse.message());
                return;
            }
            traktWatched = (List)traktWatchedResponse.body();
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
            return;
        }
        LOGGER.info("You have " + traktCollection.size() + " shows in your Trakt.tv collection");
        LOGGER.info("You have " + traktWatched.size() + " shows watched");
        ArrayList<SyncShow> showToRemove = new ArrayList<SyncShow>();
        for (BaseShow traktShow : traktCollection) {
            showToRemove.add(this.toSyncShow(traktShow));
        }
        if (!showToRemove.isEmpty()) {
            try {
                items = new SyncItems().shows(showToRemove);
                response = TRAKT.sync().deleteItemsFromCollection(items).execute();
                if (!response.isSuccessful()) {
                    LOGGER.error("failed syncing trakt: " + response.message());
                    return;
                }
                LOGGER.debug("removed " + showToRemove.size() + " shows from your trakt.tv collection");
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: " + e.getMessage());
                return;
            }
        }
        showToRemove.clear();
        for (BaseShow traktShow : traktWatched) {
            showToRemove.add(this.toSyncShow(traktShow));
        }
        if (!showToRemove.isEmpty()) {
            try {
                items = new SyncItems().shows(showToRemove);
                response = TRAKT.sync().deleteItemsFromWatchedHistory(items).execute();
                if (!response.isSuccessful()) {
                    LOGGER.error("failed syncing trakt: " + response.message());
                    return;
                }
                LOGGER.debug("removed " + showToRemove.size() + " shows from your trakt.tv watched");
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: " + e.getMessage());
                return;
            }
        }
    }

    private boolean updateIDs(TvShow tmmShow, ShowIds ids) {
        boolean dirty = false;
        if (tmmShow.getIdAsString("imdb").isEmpty() && !StringUtils.isEmpty((CharSequence)ids.imdb)) {
            tmmShow.setId("imdb", ids.imdb);
            dirty = true;
        }
        if (tmmShow.getIdAsInt("tmdb") == 0 && ids.tmdb != null && ids.tmdb != 0) {
            tmmShow.setId("tmdb", ids.tmdb);
            dirty = true;
        }
        if (tmmShow.getIdAsInt(providerInfo.getId()) == 0 && ids.trakt != null && ids.trakt != 0) {
            tmmShow.setId(providerInfo.getId(), ids.trakt);
            dirty = true;
        }
        if (tmmShow.getIdAsInt("tvdb") == 0 && ids.tvdb != null && ids.tvdb != 0) {
            tmmShow.setId("tvdb", ids.tvdb);
            dirty = true;
        }
        return dirty;
    }

    private boolean updateIDs(Movie tmmMovie, MovieIds ids) {
        boolean dirty = false;
        if (tmmMovie.getIdAsString("imdb").isEmpty() && !StringUtils.isEmpty((CharSequence)ids.imdb)) {
            tmmMovie.setId("imdb", ids.imdb);
            dirty = true;
        }
        if (tmmMovie.getIdAsInt("tmdb") == 0 && ids.tmdb != null && ids.tmdb != 0) {
            tmmMovie.setId("tmdb", ids.tmdb);
            dirty = true;
        }
        if (tmmMovie.getIdAsInt(providerInfo.getId()) == 0 && ids.trakt != null && ids.trakt != 0) {
            tmmMovie.setId(providerInfo.getId(), ids.trakt);
            dirty = true;
        }
        return dirty;
    }

    private boolean matches(TvShow tmmShow, ShowIds ids) {
        if (ids.trakt != null && ids.trakt != 0 && ids.trakt.intValue() == tmmShow.getIdAsInt(providerInfo.getId())) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)ids.imdb) && ids.imdb.equals(tmmShow.getIdAsString("imdb"))) {
            return true;
        }
        if (ids.tmdb != null && ids.tmdb != 0 && ids.tmdb.intValue() == tmmShow.getIdAsInt("tmdb")) {
            return true;
        }
        return ids.tvdb != null && ids.tvdb != 0 && ids.tvdb.intValue() == tmmShow.getIdAsInt("tvdb");
    }

    private boolean matches(Movie tmmMovie, MovieIds ids) {
        if (ids.trakt != null && ids.trakt != 0 && ids.trakt.intValue() == tmmMovie.getIdAsInt(providerInfo.getId())) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)ids.imdb) && ids.imdb.equals(tmmMovie.getIdAsString("imdb"))) {
            return true;
        }
        return ids.tmdb != null && ids.tmdb != 0 && ids.tmdb.intValue() == tmmMovie.getIdAsInt("tmdb");
    }

    private SyncMovie toSyncMovie(Movie tmmMovie, boolean watched) {
        boolean hasId = false;
        SyncMovie movie = null;
        MovieIds ids = new MovieIds();
        if (!tmmMovie.getIdAsString("imdb").isEmpty()) {
            ids.imdb = tmmMovie.getIdAsString("imdb");
            hasId = true;
        }
        if (tmmMovie.getIdAsInt("tmdb") != 0) {
            ids.tmdb = tmmMovie.getIdAsInt("tmdb");
            hasId = true;
        }
        if (tmmMovie.getIdAsInt(providerInfo.getId()) != 0) {
            ids.trakt = tmmMovie.getIdAsInt(providerInfo.getId());
            hasId = true;
        }
        if (!hasId) {
            return movie;
        }
        if (watched) {
            if (tmmMovie.isWatched() && tmmMovie.getLastWatched() == null) {
                movie = new SyncMovie().id(ids).watchedAt(new DateTime((Object)tmmMovie.getLastWatched()));
            }
        } else {
            movie = new SyncMovie().id(ids).collectedAt(new DateTime((Object)tmmMovie.getDateAdded()));
        }
        return movie;
    }

    private SyncMovie toSyncMovie(BaseMovie baseMovie) {
        SyncMovie movie = new SyncMovie().id(baseMovie.movie.ids).collectedAt(baseMovie.collected_at).watchedAt(baseMovie.last_watched_at);
        return movie;
    }

    private SyncShow toSyncShow(TvShow tmmShow, boolean watched, Set<TvShowEpisode> episodesInTrakt) {
        boolean hasId = false;
        SyncShow show = null;
        ShowIds ids = new ShowIds();
        if (!tmmShow.getIdAsString("imdb").isEmpty()) {
            ids.imdb = tmmShow.getIdAsString("imdb");
            hasId = true;
        }
        if (tmmShow.getIdAsInt("tmdb") != 0) {
            ids.tmdb = tmmShow.getIdAsInt("tmdb");
            hasId = true;
        }
        if (tmmShow.getIdAsInt("tvdb") != 0) {
            ids.tvdb = tmmShow.getIdAsInt("tvdb");
            hasId = true;
        }
        if (tmmShow.getIdAsInt(providerInfo.getId()) != 0) {
            ids.trakt = tmmShow.getIdAsInt(providerInfo.getId());
            hasId = true;
        }
        if (!hasId) {
            return show;
        }
        ArrayList<SyncSeason> ss = new ArrayList<SyncSeason>();
        boolean foundS = false;
        for (TvShowSeason tmmSeason : tmmShow.getSeasons()) {
            boolean foundEP = false;
            ArrayList<SyncEpisode> se = new ArrayList<SyncEpisode>();
            for (TvShowEpisode tmmEp : tmmSeason.getEpisodes()) {
                if (watched) {
                    if (!tmmEp.isWatched() || tmmEp.getLastWatched() != null) continue;
                    se.add(new SyncEpisode().number(tmmEp.getEpisode()).watchedAt(new DateTime((Object)tmmEp.getLastWatched())));
                    foundEP = true;
                    continue;
                }
                if (episodesInTrakt.contains(tmmEp)) continue;
                se.add(new SyncEpisode().number(tmmEp.getEpisode()).collectedAt(new DateTime((Object)tmmEp.getDateAdded())));
                foundEP = true;
            }
            if (!foundEP) continue;
            foundS = true;
            ss.add(new SyncSeason().number(tmmSeason.getSeason()).episodes(se));
        }
        if (foundS) {
            show = new SyncShow().id(ids).collectedAt(new DateTime((Object)tmmShow.getDateAdded())).seasons(ss);
        }
        return show;
    }

    private SyncShow toSyncShow(BaseShow baseShow) {
        ArrayList<SyncSeason> ss = new ArrayList<SyncSeason>();
        for (BaseSeason baseSeason : baseShow.seasons) {
            ArrayList<SyncEpisode> se = new ArrayList<SyncEpisode>();
            for (BaseEpisode baseEp : baseSeason.episodes) {
                se.add(new SyncEpisode().number(baseEp.number.intValue()).collectedAt(new DateTime((Object)baseEp.collected_at)).watchedAt(new DateTime((Object)baseEp.collected_at)));
            }
            ss.add(new SyncSeason().number(baseSeason.number.intValue()).episodes(se));
        }
        SyncShow show = new SyncShow().id(baseShow.show.ids).collectedAt(new DateTime((Object)baseShow.last_collected_at)).watchedAt(new DateTime((Object)baseShow.last_watched_at)).seasons(ss);
        return show;
    }

    private void printStatus(SyncResponse resp) {
        if (resp != null) {
            String info = this.getStatusString(resp.added);
            if (!info.isEmpty()) {
                LOGGER.debug("Added       : " + info);
            }
            if (!(info = this.getStatusString(resp.existing)).isEmpty()) {
                LOGGER.debug("Existing    : " + info);
            }
            if (!(info = this.getStatusString(resp.deleted)).isEmpty()) {
                LOGGER.debug("Deleted     : " + info);
            }
            if (!(info = this.getStatusString(resp.not_found)).isEmpty()) {
                LOGGER.debug("Errors      : " + info);
            }
        }
    }

    private String getStatusString(SyncStats ss) {
        if (ss == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(50);
        if (ss.movies != null && ss.movies > 0) {
            sb.append(ss.movies + " Movies ");
        }
        if (ss.shows != null && ss.shows > 0) {
            sb.append(ss.shows + " Shows ");
        }
        if (ss.seasons != null && ss.seasons > 0) {
            sb.append(ss.seasons + " Seasons ");
        }
        if (ss.episodes != null && ss.episodes > 0) {
            sb.append(ss.episodes + " Episodes");
        }
        return sb.toString();
    }

    private String getStatusString(SyncErrors ss) {
        if (ss == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(50);
        if (ss.movies != null && ss.movies.size() > 0) {
            sb.append(ss.movies.size() + " Movies ");
        }
        if (ss.shows != null && ss.shows.size() > 0) {
            sb.append(ss.shows.size() + " Shows ");
        }
        if (ss.seasons != null && ss.seasons.size() > 0) {
            sb.append(ss.seasons.size() + " Seasons ");
        }
        if (ss.episodes != null && ss.episodes.size() > 0) {
            sb.append(ss.episodes.size() + " Episodes");
        }
        return sb.toString();
    }

    static {
        providerInfo = new MediaProviderInfo("trakt", "Trakt.tv", "Scraper for Trakt.tv; yes, we can scrape here too :)");
    }
}

