/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakttv;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.scraper.trakttv.TraktTv;
import org.tinymediamanager.ui.UTF8Control;

public class SyncTraktTvTask
extends TmmTask {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private boolean syncMovies = false;
    private boolean syncMoviesWatched = false;
    private boolean syncTvShows = false;
    private boolean syncTvShowsWatched = false;
    private List<Movie> movies = new ArrayList<Movie>();
    private List<TvShow> tvShows = new ArrayList<TvShow>();

    public SyncTraktTvTask(boolean syncMovies, boolean syncMoviesWatched, boolean syncTvShow, boolean syncTvShowWatched) {
        super(BUNDLE.getString("trakt.sync"), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.syncMovies = syncMovies;
        this.syncMoviesWatched = syncMoviesWatched;
        this.syncTvShows = syncTvShow;
        this.syncTvShowsWatched = syncTvShowWatched;
    }

    public SyncTraktTvTask(List<Movie> movies, List<TvShow> tvShows) {
        super(BUNDLE.getString("trakt.sync"), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        if (movies != null && !movies.isEmpty()) {
            this.syncMovies = true;
            this.syncMoviesWatched = true;
            this.movies.addAll(movies);
        }
        if (tvShows != null && !tvShows.isEmpty()) {
            this.syncTvShows = true;
            this.syncTvShowsWatched = true;
            this.tvShows.addAll(tvShows);
        }
    }

    @Override
    protected void doInBackground() {
        TraktTv traktTV = TraktTv.getInstance();
        if (this.syncMovies) {
            this.publishState(BUNDLE.getString("trakt.sync.movie"), 0);
            if (this.movies.isEmpty()) {
                traktTV.syncTraktMovieCollection();
            } else {
                traktTV.syncTraktMovieCollection(this.movies);
            }
        }
        if (this.syncMoviesWatched) {
            this.publishState(BUNDLE.getString("trakt.sync.moviewatched"), 0);
            if (this.movies.isEmpty()) {
                traktTV.syncTraktMovieWatched();
            } else {
                traktTV.syncTraktMovieWatched(this.movies);
            }
        }
        if (this.syncTvShows) {
            this.publishState(BUNDLE.getString("trakt.sync.tvshow"), 0);
            if (this.tvShows.isEmpty()) {
                traktTV.syncTraktTvShowCollection();
            } else {
                traktTV.syncTraktTvShowCollection(this.tvShows);
            }
        }
        if (this.syncTvShowsWatched) {
            this.publishState(BUNDLE.getString("trakt.sync.tvshowwatched"), 0);
            if (this.tvShows.isEmpty()) {
                traktTV.syncTraktTvShowWatched();
            } else {
                traktTV.syncTraktTvShowWatched(this.tvShows);
            }
        }
    }
}

