/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.entities;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class TvShowSeason
extends AbstractModelObject
implements Comparable<TvShowSeason> {
    private int season = -1;
    private TvShow tvShow;
    private List<TvShowEpisode> episodes = new CopyOnWriteArrayList<TvShowEpisode>();
    private Date lastWatched = null;
    private PropertyChangeListener listener;

    public TvShowSeason(int season, TvShow tvShow) {
        this.season = season;
        this.tvShow = tvShow;
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() instanceof TvShowEpisode && "mediaFiles".equals(evt.getPropertyName())) {
                    TvShowSeason.this.firePropertyChange("mediaFiles", null, evt.getNewValue());
                }
            }
        };
    }

    public int getSeason() {
        return this.season;
    }

    public TvShow getTvShow() {
        return this.tvShow;
    }

    public void addEpisode(TvShowEpisode episode) {
        this.episodes.add(episode);
        Utils.sortList(this.episodes);
        episode.addPropertyChangeListener(this.listener);
        this.firePropertyChange("addedEpisode", null, this.episodes);
    }

    public void removeEpisode(TvShowEpisode episode) {
        this.episodes.remove(episode);
        episode.removePropertyChangeListener(this.listener);
        this.firePropertyChange("removedEpisode", null, this.episodes);
    }

    public List<TvShowEpisode> getEpisodes() {
        return this.episodes;
    }

    public void setPoster(File newValue) {
        String oldValue = this.tvShow.getSeasonPoster(this.season);
        this.tvShow.setSeasonPoster(this.season, newValue);
        this.firePropertyChange("poster", oldValue, newValue);
        for (TvShowEpisode episode : this.episodes) {
            episode.setPosterChanged();
        }
    }

    public void clearPoster() {
        this.tvShow.clearSeasonPoster(this.season);
        this.firePropertyChange("poster", null, "");
    }

    public String getPoster() {
        return this.tvShow.getSeasonPoster(this.season);
    }

    public Dimension getPosterSize() {
        return this.tvShow.getSeasonPosterSize(this.season);
    }

    public void setPosterUrl(String newValue) {
        String oldValue = this.tvShow.getSeasonPosterUrl(this.season);
        this.tvShow.setSeasonPosterUrl(this.season, newValue);
        this.firePropertyChange("posterUrl", oldValue, newValue);
    }

    public String getPosterUrl() {
        return this.tvShow.getSeasonPosterUrl(this.season);
    }

    public List<MediaFile> getMediaFiles() {
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        LinkedHashSet<MediaFile> unique = new LinkedHashSet<MediaFile>(mfs);
        for (int i = 0; i < this.episodes.size(); ++i) {
            unique.addAll(new ArrayList<MediaFile>(this.episodes.get(i).getMediaFiles()));
        }
        mfs.addAll(unique);
        return mfs;
    }

    public List<MediaFile> getMediaFiles(MediaFileType type) {
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        LinkedHashSet<MediaFile> unique = new LinkedHashSet<MediaFile>(mfs);
        for (int i = 0; i < this.episodes.size(); ++i) {
            unique.addAll(this.episodes.get(i).getMediaFiles(type));
        }
        mfs.addAll(unique);
        return mfs;
    }

    public boolean isNewlyAdded() {
        for (TvShowEpisode episode : this.episodes) {
            if (!episode.isNewlyAdded()) continue;
            return true;
        }
        return false;
    }

    public Date getLastWatched() {
        return this.lastWatched;
    }

    public void setLastWatched(Date lastWatched) {
        this.lastWatched = lastWatched;
    }

    @Override
    public int compareTo(TvShowSeason o) {
        if (this.getTvShow() != o.getTvShow()) {
            return this.getTvShow().getTitle().compareTo(o.getTvShow().getTitle());
        }
        return this.getSeason() > o.getSeason() ? 1 : (this.getSeason() < o.getSeason() ? -1 : 0);
    }
}

