/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieActor;
import org.tinymediamanager.scraper.util.UrlUtil;

public class MovieActorImageFetcher
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieActorImageFetcher.class);
    private Movie movie;

    public MovieActorImageFetcher(Movie movie) {
        this.movie = movie;
    }

    @Override
    public void run() {
        try {
            Path actorsDir = this.movie.getPathNIO().resolve(".actors");
            if (!Files.isDirectory(actorsDir, new LinkOption[0])) {
                Files.createDirectory(actorsDir, new FileAttribute[0]);
            }
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(actorsDir);){
                for (Path path : directoryStream) {
                    if (!Utils.isRegularFile(path) || !path.getFileName().toString().matches("(?i).*\\.(tbn|png|jpg)") || path.getFileName().toString().startsWith(".")) continue;
                    boolean found = false;
                    String actorImage = FilenameUtils.getBaseName((String)path.getFileName().toString()).replace("_", " ");
                    for (MovieActor actor : this.movie.getActors()) {
                        if (!actor.getName().equals(actorImage)) continue;
                        found = true;
                        if (FilenameUtils.getExtension((String)path.getFileName().toString()).equalsIgnoreCase(UrlUtil.getExtension((String)actor.getThumbUrl()))) break;
                        found = false;
                        break;
                    }
                    if (found) continue;
                    Utils.deleteFileWithBackup(path, this.movie.getDataSource());
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            for (MovieActor actor : this.movie.getActors()) {
                Path actorImage = actor.getStoragePath();
                if (actorImage != null && StringUtils.isNotEmpty((CharSequence)actor.getThumbUrl()) && !Files.exists(actorImage, new LinkOption[0])) {
                    Path cache = ImageCache.getCachedFile(actor.getThumbUrl());
                    if (cache == null) continue;
                    Utils.copyFileSafe(cache, actorImage);
                    continue;
                }
                LOGGER.warn("Cannot download actor image " + actor);
            }
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed: ", (Throwable)e);
        }
    }
}

