/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.http.Url;

public class MovieSetArtworkHelper {
    private static final List<MediaFileType> SUPPORTED_ARTWORK_TYPES = Arrays.asList(MediaFileType.POSTER, MediaFileType.FANART, MediaFileType.BANNER, MediaFileType.LOGO, MediaFileType.CLEARLOGO, MediaFileType.CLEARART);
    private static final String[] SUPPORTED_ARTWORK_FILETYPES = new String[]{"jpg", "png", "tbn"};
    private static Pattern artworkPattern = Pattern.compile("(?i)movieset-(poster|fanart|banner|disc|discart|logo|clearlogo|clearart|thumb)\\..{2,4}");
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetArtworkHelper.class);

    public static void updateArtwork(MovieSet movieSet) {
        MovieSetArtworkHelper.findArtworkInArtworkFolder(movieSet);
        for (Movie movie : new ArrayList<Movie>(movieSet.getMovies())) {
            MovieSetArtworkHelper.findArtworkInMovieFolder(movieSet, movie);
        }
    }

    private static void findArtworkInArtworkFolder(MovieSet movieSet) {
        String artworkFolder = MovieModuleManager.MOVIE_SETTINGS.getMovieSetArtworkFolder();
        if (!MovieModuleManager.MOVIE_SETTINGS.isEnableMovieSetArtworkFolder() || StringUtils.isBlank((CharSequence)artworkFolder)) {
            return;
        }
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            for (String fileType : SUPPORTED_ARTWORK_FILETYPES) {
                String artworkFileName = MovieRenamer.replaceInvalidCharacters(movieSet.getTitle()) + "-" + type.name().toLowerCase(Locale.ROOT) + "." + fileType;
                Path artworkFile = Paths.get(artworkFolder, artworkFileName);
                if (!Files.exists(artworkFile, new LinkOption[0])) continue;
                MediaFile mediaFile = new MediaFile(artworkFile, type);
                mediaFile.gatherMediaInformation();
                movieSet.addToMediaFiles(mediaFile);
            }
        }
    }

    private static void findArtworkInMovieFolder(MovieSet movieSet, Movie movie) {
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            if (!movieSet.getMediaFiles(type).isEmpty()) continue;
            for (String fileType : SUPPORTED_ARTWORK_FILETYPES) {
                String artworkFileName = "movieset-" + type.name().toLowerCase(Locale.ROOT) + "." + fileType;
                Path artworkFile = movie.getPathNIO().resolve(artworkFileName);
                if (!Files.exists(artworkFile, new LinkOption[0])) continue;
                MediaFile mediaFile = new MediaFile(artworkFile, type);
                mediaFile.gatherMediaInformation();
                movieSet.addToMediaFiles(mediaFile);
            }
        }
    }

    public static void setArtwork(MovieSet movieSet, List<MediaArtwork> artwork) {
        Collections.sort(artwork, new MediaArtwork.MediaArtworkComparator(MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().getLanguage()));
        MovieSetArtworkHelper.setBestPoster(movieSet, artwork);
        MovieSetArtworkHelper.setBestFanart(movieSet, artwork);
        MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.LOGO);
        MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO);
        MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARART);
        MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.BANNER);
        MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.THUMB);
        MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.DISC);
        movieSet.saveToDb();
    }

    private static void setBestPoster(MovieSet movieSet, List<MediaArtwork> artwork) {
        int preferredSizeOrder = MovieModuleManager.MOVIE_SETTINGS.getImagePosterSize().getOrder();
        String preferredLanguage = MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().getLanguage();
        MediaArtwork foundPoster = null;
        if (MovieModuleManager.MOVIE_SETTINGS.isImageLanguagePriority()) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.POSTER || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != preferredSizeOrder) continue;
                foundPoster = art;
                break;
            }
            if (foundPoster == null) {
                int minOrder = preferredSizeOrder - 1;
                int maxOrder = preferredSizeOrder + 1;
                for (MediaArtwork art : artwork) {
                    if (art.getType() != MediaArtwork.MediaArtworkType.POSTER || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != minOrder && art.getSizeOrder() != maxOrder) continue;
                    foundPoster = art;
                    break;
                }
            }
        } else {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.POSTER || art.getSizeOrder() != preferredSizeOrder) continue;
                foundPoster = art;
                break;
            }
        }
        if (foundPoster == null) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.POSTER) continue;
                foundPoster = art;
                break;
            }
        }
        if (foundPoster != null) {
            movieSet.setArtworkUrl(foundPoster.getDefaultUrl(), MediaFileType.POSTER);
        }
    }

    private static void setBestFanart(MovieSet movieSet, List<MediaArtwork> artwork) {
        int preferredSizeOrder = MovieModuleManager.MOVIE_SETTINGS.getImageFanartSize().getOrder();
        String preferredLanguage = MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().getLanguage();
        MediaArtwork foundfanart = null;
        if (MovieModuleManager.MOVIE_SETTINGS.isImageLanguagePriority()) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != preferredSizeOrder) continue;
                foundfanart = art;
                break;
            }
            if (foundfanart == null) {
                int minOrder = preferredSizeOrder - 1;
                int maxOrder = preferredSizeOrder + 1;
                for (MediaArtwork art : artwork) {
                    if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != minOrder && art.getSizeOrder() != maxOrder) continue;
                    foundfanart = art;
                    break;
                }
            }
        } else {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || art.getSizeOrder() != preferredSizeOrder) continue;
                foundfanart = art;
                break;
            }
        }
        if (foundfanart == null) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND) continue;
                foundfanart = art;
                break;
            }
        }
        if (foundfanart != null) {
            movieSet.setArtworkUrl(foundfanart.getDefaultUrl(), MediaFileType.FANART);
        }
    }

    private static void setBestArtwork(MovieSet movieSet, List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type) {
        for (MediaArtwork art : artwork) {
            if (art.getType() != type) continue;
            movieSet.setArtworkUrl(art.getDefaultUrl(), MediaFileType.getMediaFileType(type));
            break;
        }
    }

    public static void downloadArtwork(MovieSet movieSet, MediaFileType type) {
        String url = movieSet.getArtworkUrl(type);
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        MovieSetImageFetcherTask task = new MovieSetImageFetcherTask(movieSet, url, type);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public static void writeImagesToMovieFolder(MovieSet movieSet, List<Movie> movies) {
        if (!MovieModuleManager.MOVIE_SETTINGS.isEnableMovieSetArtworkMovieFolder()) {
            return;
        }
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            String url = movieSet.getArtworkUrl(type);
            if (StringUtils.isBlank((CharSequence)url)) continue;
            MovieSetImageFetcherTask task = new MovieSetImageFetcherTask(movieSet, url, type, movies);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
    }

    public static void cleanMovieSetArtworkInMovieFolder(Movie movie) {
        try {
            DirectoryStream<Path> stream = Files.newDirectoryStream(movie.getPathNIO());
            for (Path entry : stream) {
                Matcher matcher = artworkPattern.matcher(entry.getFileName().toString());
                if (!matcher.find()) continue;
                Utils.deleteFileSafely(entry);
            }
        }
        catch (Exception e) {
            LOGGER.error("remove movie set artwork: " + e.getMessage());
        }
    }

    private static class MovieSetImageFetcherTask
    implements Runnable {
        private MovieSet movieSet;
        private String urlToArtwork;
        private MediaFileType type;
        private boolean writeToArtworkFolder;
        private String artworkFolder;
        private boolean writeToMovieFolder;
        private List<MediaFile> writtenArtworkFiles;
        private List<Movie> movies;

        private MovieSetImageFetcherTask(MovieSet movieSet, String url, MediaFileType type) {
            this.movieSet = movieSet;
            this.urlToArtwork = url;
            this.type = type;
            this.writtenArtworkFiles = new ArrayList<MediaFile>();
            this.movies = new ArrayList<Movie>(movieSet.getMovies());
            this.writeToMovieFolder = MovieModuleManager.MOVIE_SETTINGS.isEnableMovieSetArtworkMovieFolder();
            this.artworkFolder = MovieModuleManager.MOVIE_SETTINGS.getMovieSetArtworkFolder();
            this.writeToArtworkFolder = MovieModuleManager.MOVIE_SETTINGS.isEnableMovieSetArtworkFolder() && StringUtils.isNotBlank((CharSequence)this.artworkFolder);
        }

        private MovieSetImageFetcherTask(MovieSet movieSet, String url, MediaFileType type, List<Movie> movies) {
            this.movieSet = movieSet;
            this.urlToArtwork = url;
            this.type = type;
            this.writtenArtworkFiles = new ArrayList<MediaFile>();
            this.movies = new ArrayList<Movie>(movies);
            this.writeToMovieFolder = MovieModuleManager.MOVIE_SETTINGS.isEnableMovieSetArtworkMovieFolder();
            this.artworkFolder = "";
            this.writeToArtworkFolder = false;
        }

        @Override
        public void run() {
            try {
                Url url = new Url(this.urlToArtwork);
                InputStream is = url.getInputStream();
                if (url.isFault()) {
                    return;
                }
                byte[] bytes = IOUtils.toByteArray((InputStream)is);
                is.close();
                String extension = FilenameUtils.getExtension((String)this.urlToArtwork);
                this.movieSet.removeAllMediaFiles(this.type);
                if (this.writeToArtworkFolder) {
                    this.writeImageToArtworkFolder(bytes, extension);
                }
                if (this.writeToMovieFolder) {
                    this.writeImageToMovieFolders(bytes, extension);
                }
                if (!this.writeToArtworkFolder && !this.writeToMovieFolder) {
                    this.writeImageToCacheFolder(bytes);
                }
                this.movieSet.addToMediaFiles(this.writtenArtworkFiles);
                this.movieSet.saveToDb();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    LOGGER.warn("interrupted image download");
                }
                LOGGER.error("fetch image", (Throwable)e);
            }
        }

        private void writeImageToArtworkFolder(byte[] bytes, String extension) {
            Path artworkFolder = Paths.get(this.artworkFolder, new String[0]);
            if (!Files.exists(artworkFolder, new LinkOption[0])) {
                try {
                    Files.createDirectories(artworkFolder, new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOGGER.warn("could not create directory: " + artworkFolder, (Throwable)e);
                }
            }
            try {
                String filename = MovieRenamer.replaceInvalidCharacters(this.movieSet.getTitle()) + "-";
                filename = this.type == MediaFileType.DISCART ? filename + "disc" + extension : filename + this.type.name().toLowerCase(Locale.ROOT) + "." + extension;
                this.writeImage(bytes, artworkFolder.resolve(filename));
            }
            catch (Exception e) {
                LOGGER.warn("could not write file", (Throwable)e);
            }
        }

        private void writeImageToMovieFolders(byte[] bytes, String extension) {
            if (this.movies.isEmpty()) {
                return;
            }
            String filename = "movieset-";
            filename = this.type == MediaFileType.DISCART ? filename + "disc." + extension : filename + this.type.name().toLowerCase(Locale.ROOT) + "." + extension;
            for (Movie movie : this.movies) {
                try {
                    if (movie.isMultiMovieDir()) continue;
                    this.writeImage(bytes, movie.getPathNIO().resolve(filename));
                }
                catch (Exception e) {
                    LOGGER.warn("could not write files", (Throwable)e);
                }
            }
        }

        private void writeImageToCacheFolder(byte[] bytes) {
            String filename = ImageCache.getMD5(this.urlToArtwork);
            try {
                this.writeImage(bytes, ImageCache.getCacheDir().resolve(filename + ".jpg"));
            }
            catch (Exception e) {
                LOGGER.warn("error in image fetcher", (Throwable)e);
            }
        }

        private void writeImage(byte[] bytes, Path pathAndFilename) throws IOException, InterruptedException {
            FileOutputStream outputStream = new FileOutputStream(pathAndFilename.toFile());
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            IOUtils.copy((InputStream)is, (OutputStream)outputStream);
            outputStream.flush();
            try {
                outputStream.getFD().sync();
            }
            catch (Exception e) {
                // empty catch block
            }
            outputStream.close();
            ((InputStream)is).close();
            ImageCache.invalidateCachedImage(pathAndFilename);
            MediaFile artwork = new MediaFile(pathAndFilename, this.type);
            artwork.gatherMediaInformation();
            this.writtenArtworkFiles.add(artwork);
        }
    }
}

