/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.kodi.Expression;
import org.tinymediamanager.scraper.kodi.KodiScraper;
import org.tinymediamanager.scraper.kodi.KodiUrl;
import org.tinymediamanager.scraper.kodi.KodiUtil;
import org.tinymediamanager.scraper.kodi.RegExp;
import org.tinymediamanager.scraper.kodi.ScraperFunction;

class KodiScraperProcessor {
    public static final String FUNCTION_SETTINGS = "GetSettings";
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiScraperProcessor.class);
    private boolean truncateLogging = true;
    private KodiScraper scraper = null;
    private String[] buffers = new String[21];
    private static final int PATTERN_OPTIONS = 42;

    public KodiScraperProcessor(KodiScraper scraper) {
        if (scraper == null) {
            throw new RuntimeException("Scraper cannot be null!");
        }
        this.scraper = scraper;
        LOGGER.debug("KodiScraperProcessor created using Scraper: " + scraper + "; Complete Logging: " + !this.truncateLogging);
        this.clearBuffers();
    }

    private KodiScraperProcessor(KodiScraper scraper, String[] buffers) {
        this.scraper = scraper;
        if (buffers != null) {
            for (int i = 0; i < buffers.length; ++i) {
                this.buffers[i] = buffers[i];
            }
        } else {
            this.clearBuffers();
        }
    }

    public String executeFunction(String function, String[] input) {
        ScraperFunction func = this.scraper.getFunction(function);
        if (func != null) {
            RegExp[] res;
            func = this.scraper.getFunction(function).clone();
            LOGGER.debug("** BEGIN Function: " + func.getName() + "; Dest: " + func.getDest() + "; ClearBuffers: " + func.isClearBuffers());
            for (RegExp r : res = func.getRegExps()) {
                for (String key : this.scraper.getProviderInfo().getConfig().getConfigKeyValuePairs().keySet()) {
                    String rep = "$INFO[" + key + "]";
                    if (!r.getInput().contains(rep) && !r.getOutput().contains(rep)) continue;
                    String opt = this.scraper.getProviderInfo().getConfig().getValue(key);
                    LOGGER.debug("Replacing Option " + rep + " with " + opt);
                    r.setInput(r.getInput().replace(rep, opt));
                    r.setOutput(r.getOutput().replace(rep, opt));
                }
            }
            if (func.isClearBuffers()) {
                this.clearBuffers();
            }
            this.setBuffers(input);
            this.executeRegexps(func.getRegExps());
            LOGGER.debug("** END Function: " + func.getName() + "; Dest: " + func.getDest() + "; ClearBuffers: " + func.isClearBuffers());
            return this.getBuffer(func.getDest());
        }
        LOGGER.debug("** Could not locate Function: " + function + " in the scraper " + this.scraper.getProviderInfo().getId());
        return "";
    }

    private void executeRegexps(RegExp[] regExps) {
        int i = 0;
        for (RegExp r : regExps) {
            LOGGER.debug("Executing " + ++i + "/" + regExps.length + " - " + r.getExpression().getExpression());
            this.executeRegexp(r);
        }
    }

    private void executeRegexp(RegExp regex) {
        String cond = regex.getConditional();
        if (cond != null && !cond.isEmpty()) {
            boolean b2;
            boolean not = cond.startsWith("!");
            if (not) {
                cond = cond.substring(1);
            }
            Boolean b = this.scraper.getProviderInfo().getConfig().getValueAsBool(cond);
            LOGGER.debug("Processing Conditional: " + regex.getConditional() + " > " + (not ? !b.booleanValue() : b));
            boolean bl = b2 = b == null || b == true;
            if (!(b2 || not && !b2)) {
                LOGGER.debug("Condition Not Met: " + regex.getConditional() + " > " + b2);
                return;
            }
        }
        if (regex.hasRegExps()) {
            this.executeRegexps(regex.getRegExps());
        }
        this.executeExpression(regex);
    }

    private void executeExpression(RegExp r) {
        String expr;
        LOGGER.debug(String.format("Processing Expression: %s; Dest: %s; Input: %s; Output: %s", r.getExpression().getExpression(), r.getDest(), r.getInput(), r.getOutput()));
        Expression exp = r.getExpression();
        String in = this.getBuffer(r.getInput());
        if (in == null) {
            in = "";
        }
        if ((expr = exp.getExpression()) == null || expr.trim().length() == 0) {
            LOGGER.debug("Expression was empty.  Returning processed output buffer using input as replacement array.");
            this.setBuffer(r.getDest(), this.processOutputBuffers(r.getOutput(), new String[]{"", in}), r.isAppendBuffer());
            return;
        }
        LOGGER.debug("Expression: " + expr);
        expr = this.processOutputBuffersForInputBufferReferences(expr);
        LOGGER.debug("Expression: " + expr);
        LOGGER.debug("     Input: " + this.logBuffer(in));
        Pattern p = Pattern.compile(expr, 42);
        Matcher m = p.matcher(in);
        if (m.find()) {
            LOGGER.debug("Matched: Group Count: " + m.groupCount());
            this.setBuffer(r.getDest(), this.processOutputBuffers(r.getOutput(), this.toGroupArray(exp.getNoCleanArray(), m)), r.isAppendBuffer());
            if (exp.isRepeat()) {
                while (m.find()) {
                    LOGGER.debug("Repeat Matched.  Group Count: " + m.groupCount());
                    this.setBuffer(r.getDest(), this.processOutputBuffers(r.getOutput(), this.toGroupArray(exp.getNoCleanArray(), m)), r.isAppendBuffer());
                }
            }
        } else {
            LOGGER.debug(String.format("No Match! Expression: %s; Text: %s;", expr, this.logBuffer(in)));
            if (exp.isClear()) {
                LOGGER.debug("Clearing Destination Buffer: " + r.getDest());
                this.setBuffer(r.getDest(), "", false);
            }
        }
    }

    private String logBuffer(String in) {
        if (!LOGGER.isDebugEnabled()) {
            return in;
        }
        if (this.isTruncateLogging() && in != null && in.length() > 200) {
            in = "TRUNCATED(200): " + in.substring(0, 200) + "...";
        }
        return in;
    }

    private String[] toGroupArray(String[] noCleanArray, Matcher groups) {
        int c = groups.groupCount();
        String[] g = new String[c + 1];
        for (int i = 0; i <= c; ++i) {
            g[i] = noCleanArray != null && noCleanArray[i] != null ? groups.group(i) : this.cleanHtml(groups.group(i));
        }
        return g;
    }

    private String cleanHtml(String group) {
        if (group == null) {
            return "";
        }
        LOGGER.debug("Before Clean Html: " + group);
        String s = group.replaceAll("<[^>]+>", "");
        LOGGER.debug("After Clean Html: " + s);
        return s;
    }

    private String processOutputBuffers(String output, String[] groups) {
        LOGGER.debug("Processing output buffer replacement.");
        Pattern p = Pattern.compile("\\\\([0-9])");
        Matcher m = p.matcher(output);
        StringBuffer sb = new StringBuffer();
        int lastStart = 0;
        while (m.find()) {
            sb.append(output.substring(lastStart, m.start()));
            lastStart = m.end();
            int g = Integer.parseInt(m.group(1));
            if (g > groups.length) {
                LOGGER.debug("No Group Replacement for: " + g);
                continue;
            }
            int index = Integer.parseInt(m.group(1));
            String val = "";
            if (index < groups.length) {
                val = groups[index];
            }
            if (val == null) {
                val = "";
            }
            sb.append(val);
        }
        sb.append(output.substring(lastStart));
        return this.processOutputBuffersForPropertyReferences(this.processOutputBuffersForInputBufferReferences(sb.toString()));
    }

    private String processOutputBuffersForInputBufferReferences(String output) {
        LOGGER.debug("Processing output buffers for input buffer references.");
        Pattern p = Pattern.compile("\\$\\$([0-9]+)");
        Matcher m = p.matcher(output);
        StringBuffer sb = new StringBuffer();
        int lastStart = 0;
        while (m.find()) {
            sb.append(output.substring(lastStart, m.start()));
            lastStart = m.end();
            sb.append(this.getBuffer(Integer.parseInt(m.group(1))));
        }
        sb.append(output.substring(lastStart));
        return sb.toString();
    }

    private String processOutputBuffersForPropertyReferences(String output) {
        LOGGER.debug("Processing output buffers for property references.");
        Pattern p = Pattern.compile("\\$INFO\\[([^\\]]+)\\]");
        Matcher m = p.matcher(output);
        StringBuffer sb = new StringBuffer();
        int lastStart = 0;
        while (m.find()) {
            sb.append(output.substring(lastStart, m.start()));
            lastStart = m.end();
            sb.append(this.scraper.getProviderInfo().getConfig().getValue(m.group(1)));
        }
        sb.append(output.substring(lastStart));
        return sb.toString();
    }

    private String getBuffer(int buffer) {
        String text = this.buffers[buffer];
        if (text == null) {
            text = "";
        }
        text = KodiUtil.fixXmlHeader(text);
        LOGGER.debug("Get Int Buffer: " + buffer + "; Text: " + this.logBuffer(text));
        return text;
    }

    private String getBuffer(String buffer) {
        if (buffer == null) {
            buffer = "";
        }
        buffer = KodiUtil.fixXmlHeader(buffer);
        LOGGER.debug(String.format("Get String Buffer: %s", buffer));
        Pattern bufferPattern = Pattern.compile("\\$\\$([0-9]+)");
        Matcher m = bufferPattern.matcher(buffer);
        if (m.find()) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getBuffer(Integer.parseInt(m.group(1))));
            while (m.find()) {
                sb.append(this.getBuffer(Integer.parseInt(m.group(1))));
            }
            return sb.toString();
        }
        LOGGER.debug("getBuffer(): Using raw input: " + this.logBuffer(buffer));
        return buffer;
    }

    private void setBuffer(int buffer, String text, boolean append) {
        String s;
        if (text == null) {
            text = "";
        }
        LOGGER.debug(String.format("Set Buffer: %s; Append: %s; Text: %s", buffer, append, this.logBuffer(text)));
        Pattern p = Pattern.compile("<url\\s+.*function=");
        Matcher m = p.matcher(text);
        if (m.find()) {
            LOGGER.debug("Processing Sub Function: " + text);
            try {
                KodiUrl url = new KodiUrl(text);
                ScraperFunction func = this.scraper.getFunction(url.getFunctionName());
                if (func == null) {
                    throw new Exception("Invalid Function Name: " + url.getFunctionName());
                }
                KodiScraperProcessor proc = this.newSubProcessor(func.isClearBuffers());
                text = proc.executeFunction(url.getFunctionName(), new String[]{"", url.getTextContent()});
            }
            catch (Exception e) {
                LOGGER.error("Failed to process function: " + text, (Throwable)e);
                text = "\n<error>" + text + "\n<msg>" + e.getMessage() + "</msg></error>\n";
            }
        }
        if ((m = (p = Pattern.compile("<chain function=\"(.*)\">(.*)</chain>")).matcher(text)).find()) {
            LOGGER.debug("Processing Sub Function: " + text);
            try {
                ScraperFunction func = this.scraper.getFunction(m.group(1));
                if (func == null) {
                    throw new Exception("Invalid Function Name: " + m.group(1));
                }
                KodiScraperProcessor proc = this.newSubProcessor(func.isClearBuffers());
                text = "<" + m.group(1) + ">" + proc.executeFunction(m.group(1), new String[]{"", m.group(2)}) + "</" + m.group(1) + ">";
            }
            catch (Exception e) {
                LOGGER.error("Failed to process function: " + text, (Throwable)e);
                text = "\n<error>" + text + "\n<msg>" + e.getMessage() + "</msg></error>\n";
            }
        }
        if (append && (s = this.buffers[buffer]) != null) {
            LOGGER.debug("Appending to buffer: " + buffer);
            text = s + text;
        }
        this.buffers[buffer] = text;
    }

    public void clearBuffers() {
        for (int i = 0; i < this.buffers.length; ++i) {
            this.setBuffer(i, "", false);
        }
    }

    private void setBuffers(String[] input) {
        if (input == null) {
            return;
        }
        LOGGER.debug("Set Buffers: # of input Buffers: " + input.length);
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == null) continue;
            this.setBuffer(i, input[i], false);
        }
    }

    public boolean containsFunction(String functionName) {
        return this.scraper.containsFunction(functionName);
    }

    public KodiScraper getScraper() {
        return this.scraper;
    }

    public boolean isTruncateLogging() {
        return this.truncateLogging;
    }

    public void setTruncateLogging(boolean truncateLogging) {
        this.truncateLogging = truncateLogging;
    }

    public KodiScraperProcessor newSubProcessor(boolean clearBuffers) {
        return new KodiScraperProcessor(this.scraper, clearBuffers ? null : this.buffers);
    }
}

