/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.a.a.a;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.tools.JarDiff;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Differ {
    public void createDiff(File file, File object, boolean bl) throws IOException {
        ArrayList<Resource> arrayList = file.getName();
        String string = ((File)object).getName();
        try {
            if (Long.parseLong((String)((Object)arrayList)) <= Long.parseLong(string)) {
                object = "New version (" + (String)((Object)arrayList) + ") must be greater than old version (" + string + ").";
                throw new IOException((String)object);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Non-numeric versions? [nvers=" + (String)((Object)arrayList) + ", overs=" + string + "].");
        }
        object = new Application((File)object, null);
        ((Application)object).init(false);
        arrayList = new ArrayList<Resource>();
        arrayList.addAll(((Application)object).getCodeResources());
        arrayList.addAll(((Application)object).getResources());
        Application application = new Application(file, null);
        application.init(false);
        Object object2 = new ArrayList<Resource>();
        ((ArrayList)object2).addAll(application.getCodeResources());
        ((ArrayList)object2).addAll(application.getResources());
        File object32 = new File(file, "patch" + string + ".dat");
        this.createPatch(object32, arrayList, (ArrayList<Resource>)object2, bl);
        for (Application.AuxGroup auxGroup : application.getAuxGroups()) {
            arrayList = new ArrayList<Resource>();
            object2 = ((Application)object).getAuxGroup(auxGroup.name);
            if (object2 != null) {
                arrayList.addAll(((Application.AuxGroup)object2).codes);
                arrayList.addAll(((Application.AuxGroup)object2).rsrcs);
            }
            object2 = new ArrayList<Resource>();
            ((ArrayList)object2).addAll(auxGroup.codes);
            ((ArrayList)object2).addAll(auxGroup.rsrcs);
            File file2 = new File(file, "patch-" + auxGroup.name + string + ".dat");
            this.createPatch(file2, arrayList, (ArrayList<Resource>)object2, bl);
        }
    }

    protected void createPatch(File file, ArrayList<Resource> arrayList, ArrayList<Resource> iterator, boolean bl) throws IOException {
        MessageDigest messageDigest = Digest.getMessageDigest();
        JarOutputStream jarOutputStream = null;
        try {
            jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            iterator = ((ArrayList)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                int n2 = arrayList.indexOf(resource);
                Object object = n2 == -1 ? null : arrayList.remove(n2);
                if (object != null) {
                    String string;
                    Object object2 = ((Resource)object).computeDigest(messageDigest, null);
                    if (((String)object2).equals(string = resource.computeDigest(messageDigest, null))) {
                        if (!bl) continue;
                        System.out.println("Unchanged: " + resource.getPath());
                        continue;
                    }
                    if (resource.getPath().endsWith(".jar")) {
                        if (bl) {
                            System.out.println("JarDiff: " + resource.getPath());
                        }
                        object = this.rebuildJar(((Resource)object).getLocal());
                        object2 = this.rebuildJar(resource.getLocal());
                        jarOutputStream.putNextEntry(new ZipEntry(resource.getPath() + ".patch"));
                        this.jarDiff((File)object, (File)object2, jarOutputStream);
                        ((File)object).delete();
                        ((File)object2).delete();
                        continue;
                    }
                }
                if (bl) {
                    System.out.println("Addition: " + resource.getPath());
                }
                jarOutputStream.putNextEntry(new ZipEntry(resource.getPath() + ".create"));
                Differ.pipe(resource.getLocal(), jarOutputStream);
            }
            for (Resource resource : arrayList) {
                if (bl) {
                    System.out.println("Removal: " + resource.getPath());
                }
                jarOutputStream.putNextEntry(new ZipEntry(resource.getPath() + ".delete"));
            }
            a.a(jarOutputStream);
            System.out.println("Created patch file: " + file);
            return;
        }
        catch (IOException iOException) {
            a.a(jarOutputStream);
            file.delete();
            throw iOException;
        }
    }

    protected File rebuildJar(File object) throws IOException {
        object = new JarFile((File)object);
        File file = File.createTempFile("differ", "jar");
        JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        byte[] byArray = new byte[4096];
        Enumeration<JarEntry> enumeration = ((JarFile)object).entries();
        while (enumeration.hasMoreElements()) {
            Object object2 = enumeration.nextElement();
            ((ZipEntry)object2).setCompressedSize(-1L);
            jarOutputStream.putNextEntry((ZipEntry)object2);
            object2 = ((JarFile)object).getInputStream((ZipEntry)object2);
            int n2 = ((InputStream)object2).read(byArray);
            while (n2 != -1) {
                jarOutputStream.write(byArray, 0, n2);
                n2 = ((InputStream)object2).read(byArray);
            }
            ((InputStream)object2).close();
        }
        jarOutputStream.close();
        ((ZipFile)object).close();
        return file;
    }

    protected void jarDiff(File file, File file2, JarOutputStream jarOutputStream) throws IOException {
        JarDiff.createPatch(file.getPath(), file2.getPath(), jarOutputStream, false);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Usage: Differ [-verbose] new_vers_dir old_vers_dir");
            System.exit(255);
        }
        Differ differ = new Differ();
        boolean bl = false;
        int n2 = 0;
        if (stringArray[0].equals("-verbose")) {
            bl = true;
            ++n2;
        }
        try {
            differ.createDiff(new File(stringArray[n2++]), new File(stringArray[n2]), bl);
            return;
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException.getMessage());
            System.exit(255);
            return;
        }
    }

    protected static void pipe(File file, JarOutputStream jarOutputStream) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            a.a(fileInputStream, jarOutputStream);
        }
        catch (Throwable throwable) {
            a.a(fileInputStream);
            throw throwable;
        }
        a.a(fileInputStream);
    }
}

