/*
 * Decompiled with CFR 0.152.
 */
package ca.beq.util.win32.registry;

import ca.beq.util.win32.registry.RegistryException;
import ca.beq.util.win32.registry.RegistryKey;
import ca.beq.util.win32.registry.ValueType;

public class RegistryValue {
    String m_name;
    ValueType m_type;
    Object m_data;

    public RegistryValue() {
        RegistryKey.checkInitialized();
        this.m_name = "";
        this.m_type = ValueType.REG_SZ;
        this.m_data = null;
    }

    public RegistryValue(Object object) {
        this();
        this.m_data = object;
    }

    public RegistryValue(String string, Object object) {
        this();
        this.m_name = string;
        this.m_data = object;
    }

    public RegistryValue(String string, ValueType valueType, Object object) {
        this();
        this.m_name = string;
        this.m_type = valueType;
        this.m_data = object;
    }

    public RegistryValue(String string, boolean bl) {
        this(string, ValueType.REG_DWORD, new Boolean(bl));
    }

    public RegistryValue(String string, byte by) {
        this(string, ValueType.REG_BINARY, new Byte(by));
    }

    public RegistryValue(String string, int n2) {
        this(string, ValueType.REG_DWORD, new Integer(n2));
    }

    public RegistryValue(String string, long l2) {
        this(string, ValueType.REG_DWORD, new Long(l2));
    }

    public RegistryValue(String string, float f2) {
        this(string, ValueType.REG_BINARY, new Float(f2));
    }

    public RegistryValue(String string, double d2) {
        this(string, ValueType.REG_BINARY, new Double(d2));
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public ValueType getType() {
        return this.m_type;
    }

    public void setType(ValueType valueType) {
        this.m_type = valueType;
    }

    public Object getData() {
        return this.m_data;
    }

    public void setData(Object object) {
        this.m_data = object;
    }

    public void setData(byte by) {
        this.setData(new Byte(by));
    }

    public void setData(boolean bl) {
        this.setData(new Boolean(bl));
    }

    public void setData(int n2) {
        this.setData(new Integer(n2));
    }

    public void setData(long l2) {
        this.setData(new Long(l2));
    }

    public void setData(float f2) {
        this.setData(new Float(f2));
    }

    public void setData(double d2) {
        this.setData(new Double(d2));
    }

    public String getStringValue() {
        CharSequence charSequence;
        if (this.m_name == null || this.m_data == null) {
            throw new NullPointerException("Neither name not data may be null");
        }
        if (this.m_type == ValueType.REG_SZ || this.m_type == ValueType.REG_EXPAND_SZ) {
            charSequence = this.m_data.toString();
        } else if (this.m_type == ValueType.REG_DWORD || this.m_type == ValueType.REG_DWORD_BIG_ENDIAN) {
            charSequence = ((Integer)this.m_data).toString();
        } else if (this.m_type == ValueType.REG_NONE || this.m_type == ValueType.REG_BINARY || this.m_type == ValueType.REG_LINK || this.m_type == ValueType.REG_MULTI_SZ || this.m_type == ValueType.REG_RESOURCE_LIST || this.m_type == ValueType.REG_RESOURCE_REQUIREMENTS_LIST || this.m_type == ValueType.REG_FULL_RESOURCE_DESCRIPTOR) {
            charSequence = new StringBuffer();
            byte[] byArray = (byte[])this.m_data;
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                ((StringBuffer)charSequence).append(' ').append(Byte.toString(byArray[i2]));
            }
            charSequence = ((StringBuffer)charSequence).toString();
        } else {
            throw new RegistryException("Unrecognized data type: " + this.m_type);
        }
        return charSequence;
    }

    public String toString() {
        return this.m_name + ':' + this.m_type.toString() + ':' + this.getStringValue();
    }
}

