/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.fanarttv;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.bind.DateTypeAdapter;
import com.jakewharton.retrofit.Ok3Client;
import java.lang.reflect.Type;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.scraper.fanarttv.services.MovieService;
import org.tinymediamanager.scraper.fanarttv.services.TvShowService;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public class FanartTv {
    public static final String API_URL = "http://webservice.fanart.tv/v3/";
    public static final String PARAM_API_KEY = "api-key";
    public static final String PARAM_CLIENT_KEY = "client-key";
    private RestAdapter restAdapter;
    private boolean isDebug;
    private String apiKey;
    private String clientKey;

    public FanartTv(String apiKey) {
        this.apiKey = apiKey;
        this.clientKey = "";
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public FanartTv setIsDebug(boolean isDebug) {
        this.isDebug = isDebug;
        if (this.restAdapter != null) {
            this.restAdapter.setLogLevel(isDebug ? RestAdapter.LogLevel.FULL : RestAdapter.LogLevel.NONE);
        }
        return this;
    }

    protected RestAdapter.Builder newRestAdapterBuilder() {
        return new RestAdapter.Builder();
    }

    protected RestAdapter getRestAdapter() {
        if (this.restAdapter == null) {
            RestAdapter.Builder builder = this.newRestAdapterBuilder();
            builder.setEndpoint(API_URL);
            builder.setConverter((Converter)new GsonConverter(this.getGsonBuilder().create()));
            builder.setClient((Client)new Ok3Client(TmmHttpClient.getHttpClient()));
            builder.setRequestInterceptor(new RequestInterceptor(){

                public void intercept(RequestInterceptor.RequestFacade requestFacade) {
                    requestFacade.addHeader(FanartTv.PARAM_API_KEY, FanartTv.this.apiKey);
                    if (StringUtils.isNotBlank((CharSequence)FanartTv.this.clientKey)) {
                        requestFacade.addHeader(FanartTv.PARAM_CLIENT_KEY, FanartTv.this.clientKey);
                    }
                }
            });
            if (this.isDebug) {
                builder.setLogLevel(RestAdapter.LogLevel.FULL);
            }
            this.restAdapter = builder.build();
        }
        return this.restAdapter;
    }

    protected GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (Object)new JsonDeserializer<Integer>(){

            public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return json.getAsInt();
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        return builder;
    }

    public MovieService getMovieService() {
        return (MovieService)this.getRestAdapter().create(MovieService.class);
    }

    public TvShowService getTvShowService() {
        return (TvShowService)this.getRestAdapter().create(TvShowService.class);
    }
}

