/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.tmdb2;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.uwetrottmann.tmdb2.enumerations.Status;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TmdbHelper {
    public static final String TMDB_DATE_PATTERN = "yyyy-MM-dd";
    private static final SimpleDateFormat TMDB_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public static GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (Object)new JsonDeserializer<Integer>(){

            public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return json.getAsInt();
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return TMDB_DATE_FORMAT.parse(json.getAsString());
                }
                catch (ParseException e) {
                    return null;
                }
            }
        });
        builder.registerTypeAdapter(Status.class, (Object)new JsonDeserializer<Status>(){

            public Status deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                String value = jsonElement.getAsString();
                if (value != null) {
                    return Status.fromValue(value);
                }
                return null;
            }
        });
        return builder;
    }
}

