/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.util.ArrayList;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Similarity {
    private static final Logger LOGGER = LoggerFactory.getLogger(Similarity.class);

    private static String[] letterPairs(String str) {
        int numPairs;
        if (str.length() == 1) {
            str = str + " ";
        }
        if ((numPairs = str.length() - 1) < 0) {
            numPairs = 0;
        }
        String[] pairs = new String[numPairs];
        for (int i = 0; i < numPairs; ++i) {
            pairs[i] = str.substring(i, i + 2);
        }
        return pairs;
    }

    private static ArrayList<String> wordLetterPairs(String str) {
        ArrayList<String> allPairs = new ArrayList<String>();
        String[] words = str.split("\\s");
        for (int w = 0; w < words.length; ++w) {
            String[] pairsInWord = Similarity.letterPairs(words[w]);
            for (int p = 0; p < pairsInWord.length; ++p) {
                allPairs.add(pairsInWord[p]);
            }
        }
        return allPairs;
    }

    public static float compareStrings(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return 0.0f;
        }
        if (str1.equalsIgnoreCase(str2)) {
            return 1.0f;
        }
        try {
            ArrayList<String> pairs1 = Similarity.wordLetterPairs(str1.toUpperCase(Locale.ROOT));
            ArrayList<String> pairs2 = Similarity.wordLetterPairs(str2.toUpperCase(Locale.ROOT));
            int intersection = 0;
            int union = pairs1.size() + pairs2.size();
            block2: for (int i = 0; i < pairs1.size(); ++i) {
                String pair1 = pairs1.get(i);
                for (int j = 0; j < pairs2.size(); ++j) {
                    String pair2 = pairs2.get(j);
                    if (!pair1.equals(pair2)) continue;
                    ++intersection;
                    pairs2.remove(j);
                    continue block2;
                }
            }
            float score = (float)(2.0 * (double)intersection) / (float)union;
            if (Float.isNaN(score)) {
                score = 0.0f;
            }
            return score;
        }
        catch (Exception e) {
            LOGGER.warn("Exception in compareStrings str1 = " + str1 + " str12 = " + str2);
            return 0.0f;
        }
    }
}

