/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.io.File;
import java.io.FileInputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class JarUtils {
    public static Manifest getManifest(Class c) {
        Manifest mf = null;
        try {
            String basepath;
            FileInputStream is;
            String classname = "/" + c.getName().replaceAll("\\.", "/") + ".class";
            URL jarURL = c.getResource(classname);
            if (jarURL.getProtocol().equals("jar")) {
                JarURLConnection jurlConn = (JarURLConnection)jarURL.openConnection();
                mf = jurlConn.getManifest();
            } else if (jarURL.getProtocol().equals("file") && (is = new FileInputStream((basepath = jarURL.getPath().substring(0, jarURL.getPath().indexOf(classname))) + "/META-INF/MANIFEST.MF")) != null) {
                mf = new Manifest(is);
            }
        }
        catch (Exception e) {
            mf = null;
        }
        return mf;
    }

    public static String getManifestEntry(Class c, String entry) {
        String s = "";
        try {
            Manifest mf = JarUtils.getManifest(c);
            if (mf != null) {
                Attributes attr = mf.getMainAttributes();
                s = attr.getValue(entry);
            } else if (Attributes.Name.IMPLEMENTATION_VERSION.toString().equals(entry)) {
                s = JarUtils.getVersionFromProject(c);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public static String getVersionFromProject(Class c) {
        String v = "";
        try {
            String classname = "/" + c.getName().replaceAll("\\.", "/") + ".class";
            URL jarURL = c.getResource(classname);
            if (jarURL.getProtocol().equals("file")) {
                String basepath = jarURL.getPath().substring(0, jarURL.getPath().indexOf(classname));
                File projectRoot = new File(basepath).getParentFile();
                FileInputStream is = new FileInputStream(projectRoot + "/maven-archiver/pom.properties");
                Properties p = new Properties();
                p.load(is);
                v = p.getProperty("version");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }
}

