/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.utils.internal;

import java.util.concurrent.ConcurrentLinkedQueue;
import net.jcores.jre.CommonCore;
import net.jcores.jre.CoreKeeper;
import net.jcores.jre.cores.CoreNumber;
import net.jcores.jre.extensions.GlobalExtension;
import net.jcores.jre.interfaces.functions.F1;
import net.jcores.jre.interfaces.functions.F1V;
import net.jcores.jre.options.Option;
import net.xeoh.nexus.Service;

public class Reporter {
    ConcurrentLinkedQueue<String> allRecords = new ConcurrentLinkedQueue();
    CommonCore commonCore;

    public Reporter(CommonCore commonCore) {
        this.commonCore = commonCore;
    }

    public void record(String string) {
        this.allRecords.add(string);
    }

    public void printRecords() {
        System.out.println(">>> jCores trouble log (" + this.commonCore.version() + ")");
        for (String object : this.allRecords) {
            System.out.println(">>> " + object);
        }
        this.commonCore.net.get("http://api.jcores.net/versioncheck/", null, new Option[0]).onNext((F1<String, Void>)new F1V<String>(){

            @Override
            public void fV(String string) {
                String string2 = CoreKeeper.$(string).split("-").trim().get(-1, "UNDEFINED");
                String string3 = CoreKeeper.$(CoreKeeper.$.version()).split("-").get(-1, "UNDEFINED");
                if (string3.contains("@")) {
                    System.out.println(">>> You are probably running from source. Cannot determine your exact version.");
                    return;
                }
                if (string2.contains("UNDEFINED")) {
                    System.out.println(">>> Latest online version unknown. Probably you are not on the internet.");
                    return;
                }
                CoreNumber coreNumber = CoreKeeper.$(string3, string2).number(Long.class).as(CoreNumber.class);
                long l = ((Number)coreNumber.get(false)).longValue() - ((Number)coreNumber.get(true)).longValue();
                if (l == 0L) {
                    System.out.println(">>> Your version is up to date.");
                }
                if (l > 0L) {
                    System.out.println(">>> Your version is newer than the online version. Early bird ;-)");
                }
                if (l < 0L) {
                    System.out.println(">>> Your version is outdated. Get the latest version at http://jcores.net");
                }
            }
        }, new Option[0]);
        for (Service service : this.commonCore.nexus().list()) {
            Object object = service.getService();
            if (!(object instanceof GlobalExtension)) continue;
            System.out.println(">>> Loaded global extension '" + object.getClass().getCanonicalName() + "'");
        }
        try {
            String string = this.commonCore.coreID();
            String string2 = System.getProperty("jcores.net.knownIDs");
            if (string2 == null || string2.equals(string)) {
                if (string2 == null) {
                    System.setProperty("jcores.net.knownIDs", string);
                }
            } else {
                System.out.println(">>> Multiple jCores instances detected. Be careful with methods that have a @AttentionWithClassloaders annotation!");
                if (!string2.contains(string)) {
                    System.setProperty("jcores.net.knownIDs", string2 + ";" + (String)string);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(">>> Unable to check if we are in a multiple-classloader scenario. Probably you should be a bit careful.");
        }
    }
}

