/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.cores;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import net.jcores.jre.CommonCore;
import net.jcores.jre.CoreKeeper;
import net.jcores.jre.cores.CoreAudioInputStream;
import net.jcores.jre.cores.CoreBufferedImage;
import net.jcores.jre.cores.CoreByteBuffer;
import net.jcores.jre.cores.CoreObject;
import net.jcores.jre.cores.CoreString;
import net.jcores.jre.cores.CoreZipInputStream;
import net.jcores.jre.cores.adapter.EmptyAdapter;
import net.jcores.jre.interfaces.functions.F1;
import net.jcores.jre.options.Hash;
import net.jcores.jre.options.MessageType;
import net.jcores.jre.options.Option;
import net.jcores.jre.utils.internal.Sound;
import net.jcores.jre.utils.internal.Streams;

public class CoreInputStream
extends CoreObject<InputStream> {
    private static final long serialVersionUID = 1520313333781137198L;

    public CoreInputStream(CommonCore commonCore, InputStream ... inputStreamArray) {
        super(commonCore, inputStreamArray);
    }

    public CoreAudioInputStream audio() {
        return new CoreAudioInputStream(this.commonCore, this.map(new F1<InputStream, AudioInputStream>(){

            @Override
            public AudioInputStream f(InputStream inputStream) {
                return Sound.getStream(inputStream);
            }
        }, new Option[0]).array(AudioInputStream.class));
    }

    public void close() {
        for (int i = 0; i < this.size(); ++i) {
            InputStream inputStream = (InputStream)this.get(i);
            try {
                inputStream.close();
                continue;
            }
            catch (IOException iOException) {
                this.commonCore.report(MessageType.EXCEPTION, "Error closing stream " + inputStream + ".");
            }
        }
    }

    public <T> CoreObject<T> deserialize(Class<T> clazz, Option ... optionArray) {
        CoreObject<T> coreObject;
        if (this.size() > 1) {
            this.commonCore.report(MessageType.MISUSE, "deserialize() should not be used on cores with more than one class!");
        }
        if ((coreObject = Streams.deserializeCore(clazz, (InputStream)this.get(false), this.commonCore)) != null) {
            return coreObject;
        }
        return new CoreObject(this.commonCore, new EmptyAdapter());
    }

    public void unzip(final String string) {
        this.map(new F1<InputStream, Void>(){

            @Override
            public Void f(InputStream inputStream) {
                try {
                    Streams.doUnzip(inputStream, string);
                    inputStream.close();
                }
                catch (IOException iOException) {
                    CoreInputStream.this.commonCore.report(MessageType.EXCEPTION, "IO error processing " + inputStream + ".");
                }
                return null;
            }
        }, new Option[0]);
    }

    public CoreZipInputStream zipstream() {
        return this.map(new F1<InputStream, ZipInputStream>(){

            @Override
            public ZipInputStream f(InputStream inputStream) {
                return new ZipInputStream(inputStream);
            }
        }, new Option[0]).as(CoreZipInputStream.class);
    }

    public CoreBufferedImage image() {
        return new CoreBufferedImage(this.commonCore, this.map(new F1<InputStream, BufferedImage>(){

            @Override
            public BufferedImage f(InputStream inputStream) {
                try {
                    return ImageIO.read(inputStream);
                }
                catch (IOException iOException) {
                    CoreInputStream.this.commonCore.report(MessageType.EXCEPTION, "Error loading image from stream " + inputStream);
                    return null;
                }
            }
        }, new Option[0]).array(BufferedImage.class));
    }

    public CoreString text() {
        return new CoreString(this.commonCore, this.map(new F1<InputStream, String>(){

            @Override
            public String f(InputStream inputStream) {
                String string = Streams.readText(CoreInputStream.this.commonCore, inputStream);
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    CoreInputStream.this.commonCore.report(MessageType.EXCEPTION, "Error closing stream " + inputStream + ".");
                }
                return string;
            }
        }, new Option[0]).array(String.class));
    }

    public CoreString hash(Option ... optionArray) {
        final String string = CoreKeeper.$(optionArray).get(Hash.class, Hash.MD5).getMethod();
        return new CoreString(this.commonCore, this.map(new F1<InputStream, String>(){

            @Override
            public String f(InputStream inputStream) {
                String string2 = Streams.generateHash(inputStream, string);
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    CoreInputStream.this.commonCore.report(MessageType.EXCEPTION, "Error closing stream " + inputStream + ".");
                }
                return string2;
            }
        }, new Option[0]).array(String.class));
    }

    public CoreByteBuffer data() {
        return new CoreByteBuffer(this.commonCore, this.map(new F1<InputStream, ByteBuffer>(){

            @Override
            public ByteBuffer f(InputStream inputStream) {
                ByteBuffer byteBuffer = Streams.getByteData(inputStream);
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    CoreInputStream.this.commonCore.report(MessageType.EXCEPTION, "Error closing stream " + inputStream + ".");
                }
                return byteBuffer;
            }
        }, new Option[0]).array(ByteBuffer.class));
    }
}

