/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.lang3.StringUtils;
import org.imgscalr.Scalr;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.tvshow.TvShowEpisodeThumbNaming;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.mediaprovider.IMediaProvider;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;
import org.tinymediamanager.ui.tvshows.TvShowScraperMetadataPanel;

public class TvShowScraperSettingsPanel
extends ScrollablePanel {
    private static final long serialVersionUID = 4999827736720726395L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShowSettings settings = TvShowModuleManager.SETTINGS;
    private List<TvShowScraper> scrapers = ObservableCollections.observableList(new ArrayList());
    private List<ArtworkScraper> artworkScrapers = ObservableCollections.observableList(new ArrayList());
    private JComboBox cbScraperTmdbLanguage;
    private JComboBox cbCountry;
    private JCheckBox chckbxAutomaticallyScrapeImages;
    private JPanel panelScraperMetadata;
    private JPanel panelScraperMetadataContainer;
    private JPanel panelArtworkScrapers;
    private JRadioButton rdbtnThumbWithPostfix;
    private JRadioButton rdbtnThumbWoPostfix;
    private JLabel lblNewLabel;
    private ButtonGroup btnGroupThumbFilenaming;
    private JScrollPane scrollPaneScraper;
    private JTable tableScraper;
    private JPanel panelScraperDetails;
    private JTextPane tpScraperDescription;
    private JScrollPane scrollPaneArtworkScraper;
    private JTable tableArtworkScraper;
    private JPanel panelArtworkScraperDetails;
    private JTextPane tpArtworkScraperDescription;
    private JPanel panelScraperOptions;
    private JPanel panelArtworkScraperOptions;
    private JScrollPane scrollPaneScraperDetails;
    private JScrollPane scrollPaneArtworkScraperDetails;
    private JPanel panelImages;
    private JRadioButton rdbtnThumbTbn;

    public TvShowScraperSettingsPanel() {
        MediaScraper defaultMediaScraper = TvShowList.getInstance().getDefaultMediaScraper();
        int selectedIndex = 0;
        int counter = 0;
        for (MediaScraper scraper : TvShowList.getInstance().getAvailableMediaScrapers()) {
            TvShowScraper tvShowScraper = new TvShowScraper(scraper);
            if (scraper.equals(defaultMediaScraper)) {
                tvShowScraper.defaultScraper = true;
                selectedIndex = counter;
            }
            this.scrapers.add(tvShowScraper);
            ++counter;
        }
        List<String> enabledArtworkProviders = this.settings.getTvShowArtworkScrapers();
        int artworkSelectedIndex = -1;
        int counterAW = 0;
        for (MediaScraper scraper : TvShowList.getInstance().getAvailableArtworkScrapers()) {
            ArtworkScraper artworkScraper = new ArtworkScraper(scraper);
            if (enabledArtworkProviders.contains(artworkScraper.getScraperId())) {
                artworkScraper.active = true;
                if (artworkSelectedIndex < 0) {
                    artworkSelectedIndex = counterAW;
                }
            }
            this.artworkScrapers.add(artworkScraper);
            ++counterAW;
        }
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JPanel panelTvShowScrapers = new JPanel();
        panelTvShowScrapers.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), BUNDLE.getString("scraper.metadata.defaults"), 4, 2, null, null));
        this.add((Component)panelTvShowScrapers, "2, 2, fill, top");
        panelTvShowScrapers.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode((String)"100dlu:grow"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC}));
        this.scrollPaneScraper = new JScrollPane();
        panelTvShowScrapers.add((Component)this.scrollPaneScraper, "1, 2, 3, 1, fill, fill");
        this.tableScraper = new JTable();
        this.tableScraper.setRowHeight(29);
        this.scrollPaneScraper.setViewportView(this.tableScraper);
        this.scrollPaneScraperDetails = new JScrollPane();
        this.scrollPaneScraperDetails.setHorizontalScrollBarPolicy(31);
        this.scrollPaneScraperDetails.setBorder(null);
        panelTvShowScrapers.add((Component)this.scrollPaneScraperDetails, "5, 2, fill, fill");
        this.panelScraperDetails = new ScrollablePanel();
        this.scrollPaneScraperDetails.setViewportView(this.panelScraperDetails);
        this.panelScraperDetails.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"200dlu:grow")}, new RowSpec[]{RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        this.tpScraperDescription = new JTextPane();
        this.tpScraperDescription.setOpaque(false);
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        ((HTMLDocument)this.tpScraperDescription.getDocument()).getStyleSheet().addRule(bodyRule);
        this.panelScraperDetails.add((Component)this.tpScraperDescription, "1, 1, fill, top");
        this.panelScraperOptions = new JPanel();
        this.panelScraperOptions.setLayout(new FlowLayout(0));
        this.panelScraperDetails.add((Component)this.panelScraperOptions, "1, 3, fill, top");
        JSeparator separator = new JSeparator();
        panelTvShowScrapers.add((Component)separator, "1, 4, 5, 1");
        JLabel lblScraperLanguage = new JLabel(BUNDLE.getString("Settings.preferredLanguage"));
        panelTvShowScrapers.add((Component)lblScraperLanguage, "1, 6, right, default");
        this.cbScraperTmdbLanguage = new JComboBox<MediaLanguages>(MediaLanguages.values());
        panelTvShowScrapers.add((Component)this.cbScraperTmdbLanguage, "3, 6");
        JLabel lblCountry = new JLabel(BUNDLE.getString("Settings.certificationCountry"));
        panelTvShowScrapers.add((Component)lblCountry, "1, 8, right, default");
        this.cbCountry = new JComboBox<CountryCode>(CountryCode.values());
        panelTvShowScrapers.add((Component)this.cbCountry, "3, 8, fill, default");
        this.btnGroupThumbFilenaming = new ButtonGroup();
        this.panelArtworkScrapers = new JPanel();
        this.panelArtworkScrapers.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.images"), 4, 2, null, null));
        this.add((Component)this.panelArtworkScrapers, "2, 4, fill, fill");
        this.panelArtworkScrapers.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode((String)"80dlu:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC}));
        this.scrollPaneArtworkScraper = new JScrollPane();
        this.panelArtworkScrapers.add((Component)this.scrollPaneArtworkScraper, "2, 2, fill, fill");
        this.tableArtworkScraper = new JTable();
        this.tableArtworkScraper.setRowHeight(29);
        this.scrollPaneArtworkScraper.setViewportView(this.tableArtworkScraper);
        this.scrollPaneArtworkScraperDetails = new JScrollPane();
        this.scrollPaneArtworkScraperDetails.setBorder(null);
        this.panelArtworkScrapers.add((Component)this.scrollPaneArtworkScraperDetails, "4, 2, fill, fill");
        this.panelArtworkScraperDetails = new JPanel();
        this.scrollPaneArtworkScraperDetails.setViewportView(this.panelArtworkScraperDetails);
        this.panelArtworkScraperDetails.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200dlu:grow")}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        this.tpArtworkScraperDescription = new JTextPane();
        this.tpArtworkScraperDescription.setEditorKit(new HTMLEditorKit());
        ((HTMLDocument)this.tpArtworkScraperDescription.getDocument()).getStyleSheet().addRule(bodyRule);
        this.tpArtworkScraperDescription.setOpaque(false);
        this.panelArtworkScraperDetails.add((Component)this.tpArtworkScraperDescription, "2, 2, fill, fill");
        this.panelArtworkScraperOptions = new JPanel();
        this.panelArtworkScraperOptions.setLayout(new FlowLayout(0));
        this.panelArtworkScraperDetails.add((Component)this.panelArtworkScraperOptions, "2, 4, fill, fill");
        separator = new JSeparator();
        this.panelArtworkScrapers.add((Component)separator, "2, 4, 3, 1");
        this.panelImages = new JPanel();
        this.panelArtworkScrapers.add((Component)this.panelImages, "2, 6, 3, 1, fill, fill");
        this.panelImages.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{RowSpec.decode((String)"23px")}));
        this.lblNewLabel = new JLabel(BUNDLE.getString("image.thumb.naming"));
        this.panelImages.add((Component)this.lblNewLabel, "1, 1, left, center");
        this.rdbtnThumbWithPostfix = new JRadioButton("<dynamic>-thumb.ext");
        this.panelImages.add((Component)this.rdbtnThumbWithPostfix, "3, 1, fill, top");
        this.btnGroupThumbFilenaming.add(this.rdbtnThumbWithPostfix);
        this.rdbtnThumbTbn = new JRadioButton("<dynamic>.tbn");
        this.btnGroupThumbFilenaming.add(this.rdbtnThumbTbn);
        this.rdbtnThumbWoPostfix = new JRadioButton("<dynamic>.ext");
        this.panelImages.add((Component)this.rdbtnThumbWoPostfix, "5, 1, fill, top");
        this.btnGroupThumbFilenaming.add(this.rdbtnThumbWoPostfix);
        this.panelImages.add((Component)this.rdbtnThumbTbn, "7, 1");
        this.panelScraperMetadataContainer = new JPanel();
        this.panelScraperMetadataContainer.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), BUNDLE.getString("scraper.metadata.defaults"), 4, 2, null, new Color(51, 51, 51)));
        this.add((Component)this.panelScraperMetadataContainer, "2, 6, fill, top");
        this.panelScraperMetadataContainer.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.panelScraperMetadata = new TvShowScraperMetadataPanel(Settings.getInstance().getTvShowScraperMetadataConfig());
        this.panelScraperMetadataContainer.add((Component)this.panelScraperMetadata, "1, 1, 2, 1, fill, default");
        this.chckbxAutomaticallyScrapeImages = new JCheckBox(BUNDLE.getString("Settings.default.autoscrape"));
        this.panelScraperMetadataContainer.add((Component)this.chckbxAutomaticallyScrapeImages, "2, 3");
        this.initDataBindings();
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 1, 2);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableScraper, 5);
        TableColumnResizer.setMaxWidthForColumn(this.tableArtworkScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableArtworkScraper, 1, 2);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableArtworkScraper, 5);
        this.tableScraper.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                if (arg0.getColumn() == 0) {
                    int row = arg0.getFirstRow();
                    TvShowScraper changedScraper = (TvShowScraper)TvShowScraperSettingsPanel.this.scrapers.get(row);
                    if (changedScraper.getDefaultScraper().booleanValue()) {
                        TvShowScraperSettingsPanel.this.settings.setTvShowScraper(changedScraper.getScraperId());
                        for (TvShowScraper scraper : TvShowScraperSettingsPanel.this.scrapers) {
                            if (scraper == changedScraper) continue;
                            scraper.setDefaultScraper(Boolean.FALSE);
                        }
                    }
                }
            }
        });
        this.tableScraper.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = TvShowScraperSettingsPanel.this.tableScraper.convertRowIndexToModel(TvShowScraperSettingsPanel.this.tableScraper.getSelectedRow());
                if (index > -1) {
                    TvShowScraperSettingsPanel.this.panelScraperOptions.removeAll();
                    if (((TvShowScraper)TvShowScraperSettingsPanel.this.scrapers.get(index)).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                        TvShowScraperSettingsPanel.this.panelScraperOptions.add(new MediaScraperConfigurationPanel(((TvShowScraper)TvShowScraperSettingsPanel.this.scrapers.get(index)).getMediaProvider()));
                    }
                    TvShowScraperSettingsPanel.this.panelScraperOptions.revalidate();
                }
            }
        });
        this.tableArtworkScraper.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                if (arg0.getColumn() == 0) {
                    int row = arg0.getFirstRow();
                    ArtworkScraper changedScraper = (ArtworkScraper)TvShowScraperSettingsPanel.this.artworkScrapers.get(row);
                    if (changedScraper.active) {
                        TvShowScraperSettingsPanel.this.settings.addTvShowArtworkScraper(changedScraper.getScraperId());
                    } else {
                        TvShowScraperSettingsPanel.this.settings.removeTvShowArtworkScraper(changedScraper.getScraperId());
                    }
                }
            }
        });
        this.tableArtworkScraper.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = TvShowScraperSettingsPanel.this.tableArtworkScraper.convertRowIndexToModel(TvShowScraperSettingsPanel.this.tableArtworkScraper.getSelectedRow());
                if (index > -1) {
                    TvShowScraperSettingsPanel.this.panelArtworkScraperOptions.removeAll();
                    if (((ArtworkScraper)TvShowScraperSettingsPanel.this.artworkScrapers.get(index)).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                        TvShowScraperSettingsPanel.this.panelArtworkScraperOptions.add(new MediaScraperConfigurationPanel(((ArtworkScraper)TvShowScraperSettingsPanel.this.artworkScrapers.get(index)).getMediaProvider()));
                    }
                    TvShowScraperSettingsPanel.this.panelArtworkScraperOptions.revalidate();
                }
            }
        });
        if (counter > 0) {
            this.tableScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
        if (counterAW > 0) {
            this.tableArtworkScraper.getSelectionModel().setSelectionInterval(artworkSelectedIndex, artworkSelectedIndex);
        }
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TvShowScraperSettingsPanel.this.checkChanges();
            }
        };
        this.rdbtnThumbWoPostfix.addItemListener(itemListener);
        this.rdbtnThumbWithPostfix.addItemListener(itemListener);
        this.rdbtnThumbTbn.addItemListener(itemListener);
        switch (this.settings.getTvShowEpisodeThumbFilename()) {
            case FILENAME_THUMB_POSTFIX: {
                this.rdbtnThumbWithPostfix.setSelected(true);
                break;
            }
            case FILENAME_THUMB: {
                this.rdbtnThumbWoPostfix.setSelected(true);
                break;
            }
            case FILENAME_THUMB_TBN: {
                this.rdbtnThumbTbn.setSelected(true);
                break;
            }
        }
    }

    public void checkChanges() {
        if (this.rdbtnThumbWithPostfix.isSelected()) {
            this.settings.setTvShowEpisodeThumbFilename(TvShowEpisodeThumbNaming.FILENAME_THUMB_POSTFIX);
        }
        if (this.rdbtnThumbWoPostfix.isSelected()) {
            this.settings.setTvShowEpisodeThumbFilename(TvShowEpisodeThumbNaming.FILENAME_THUMB);
        }
        if (this.rdbtnThumbTbn.isSelected()) {
            this.settings.setTvShowEpisodeThumbFilename(TvShowEpisodeThumbNaming.FILENAME_THUMB_TBN);
        }
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"scraperLanguage");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, (Object)this.cbScraperTmdbLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"certificationCountry");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, (Object)this.cbCountry, (Property)jComboBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"scrapeBestImage");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxAutomaticallyScrapeImages, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableScraper);
        BeanProperty tvShowScraperBeanProperty = BeanProperty.create((String)"defaultScraper");
        jTableBinding.addColumnBinding((Property)tvShowScraperBeanProperty).setColumnName("Default").setColumnClass(Boolean.class);
        BeanProperty tvShowScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)tvShowScraperBeanProperty_1).setColumnName("Logo").setColumnClass(Icon.class);
        BeanProperty tvShowScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)tvShowScraperBeanProperty_2).setColumnName("Name").setEditable(false);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding_3.bind();
        JTableBinding jTableBinding_1 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.artworkScrapers, (JTable)this.tableArtworkScraper);
        BeanProperty artworkScraperBeanProperty = BeanProperty.create((String)"active");
        jTableBinding_1.addColumnBinding((Property)artworkScraperBeanProperty).setColumnName("Active").setColumnClass(Boolean.class);
        BeanProperty artworkScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding_1.addColumnBinding((Property)artworkScraperBeanProperty_1).setColumnName("Logo").setEditable(false).setColumnClass(ImageIcon.class);
        BeanProperty artworkScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding_1.addColumnBinding((Property)artworkScraperBeanProperty_2).setColumnName("Name").setEditable(false).setColumnClass(String.class);
        jTableBinding_1.bind();
        BeanProperty jTextPaneBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableArtworkScraper, (Property)jTableBeanProperty, (Object)this.tpArtworkScraperDescription, (Property)jTextPaneBeanProperty_1);
        autoBinding_1.bind();
    }

    public class ArtworkScraper
    extends AbstractModelObject {
        private MediaScraper scraper;
        private Icon scraperLogo;
        private boolean active;

        public ArtworkScraper(MediaScraper scraper) {
            this.scraper = scraper;
            this.scraperLogo = scraper.getMediaProvider().getProviderInfo().getProviderLogo() == null ? new ImageIcon() : this.getScaledIcon(new ImageIcon(scraper.getMediaProvider().getProviderInfo().getProviderLogo()));
        }

        private ImageIcon getScaledIcon(ImageIcon original) {
            Canvas c = new Canvas();
            FontMetrics fm = c.getFontMetrics(TvShowScraperSettingsPanel.this.getFont());
            int height = (int)((float)fm.getHeight() * 2.0f);
            int width = original.getIconWidth() / original.getIconHeight() * height;
            BufferedImage scaledImage = Scalr.resize((BufferedImage)ImageCache.createImage(original.getImage()), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            return new ImageIcon(scaledImage);
        }

        public String getScraperId() {
            return this.scraper.getId();
        }

        public String getScraperName() {
            return this.scraper.getName() + " - " + this.scraper.getVersion();
        }

        public String getScraperDescription() {
            String description = null;
            try {
                description = BUNDLE.getString("scraper." + this.scraper.getId() + ".hint");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isBlank(description)) {
                description = this.scraper.getDescription();
            }
            return description;
        }

        public Icon getScraperLogo() {
            return this.scraperLogo;
        }

        public Boolean getActive() {
            return this.active;
        }

        public void setActive(Boolean newValue) {
            Boolean oldValue = this.active;
            this.active = newValue;
            this.firePropertyChange("active", oldValue, newValue);
        }

        public IMediaProvider getMediaProvider() {
            return this.scraper.getMediaProvider();
        }
    }

    public static class TvShowScraper
    extends AbstractModelObject {
        private MediaScraper scraper;
        private Icon scraperLogo;
        private boolean defaultScraper;

        public TvShowScraper(MediaScraper scraper) {
            this.scraper = scraper;
            this.scraperLogo = scraper.getMediaProvider() == null || scraper.getMediaProvider().getProviderInfo() == null || scraper.getMediaProvider().getProviderInfo().getProviderLogo() == null ? new ImageIcon() : this.getScaledIcon(new ImageIcon(scraper.getMediaProvider().getProviderInfo().getProviderLogo()));
        }

        private ImageIcon getScaledIcon(ImageIcon original) {
            Canvas c = new Canvas();
            FontMetrics fm = c.getFontMetrics(new JPanel().getFont());
            int height = (int)((float)fm.getHeight() * 2.0f);
            int width = original.getIconWidth() / original.getIconHeight() * height;
            BufferedImage scaledImage = Scalr.resize((BufferedImage)ImageCache.createImage(original.getImage()), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            return new ImageIcon(scaledImage);
        }

        public String getScraperId() {
            return this.scraper.getId();
        }

        public String getScraperName() {
            return this.scraper.getName() + " - " + this.scraper.getVersion();
        }

        public String getScraperDescription() {
            String description = null;
            try {
                description = BUNDLE.getString("scraper." + this.scraper.getId() + ".hint");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isBlank(description)) {
                description = this.scraper.getDescription();
            }
            return description;
        }

        public Icon getScraperLogo() {
            return this.scraperLogo;
        }

        public Boolean getDefaultScraper() {
            return this.defaultScraper;
        }

        public void setDefaultScraper(Boolean newValue) {
            Boolean oldValue = this.defaultScraper;
            this.defaultScraper = newValue;
            this.firePropertyChange("defaultScraper", oldValue, newValue);
        }

        public IMediaProvider getMediaProvider() {
            return this.scraper.getMediaProvider();
        }
    }
}

