/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.JHintCheckBox;
import org.tinymediamanager.ui.components.ZebraJTable;

public class TvShowRenamerSettingsPanel
extends JPanel
implements HierarchyListener {
    private static final long serialVersionUID = 5189531235704401313L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShowSettings settings = TvShowModuleManager.SETTINGS;
    private List<String> spaceReplacement = new ArrayList<String>(Arrays.asList("_", ".", "-"));
    private EventList<TvShowRenamerExample> exampleEventList = null;
    private JTextPane txtpntAsciiHint;
    private JLabel lblSeasonFolderName;
    private JLabel lblExample;
    private JComboBox cbTvShowForPreview;
    private JTextField tfSeasonFoldername;
    private JCheckBox chckbxAsciiReplacement;
    private JComboBox cbSpaceReplacement;
    private JHintCheckBox chckbxSpaceReplacement;
    private JPanel panelExample;
    private JComboBox cbEpisodeForPreview;
    private JScrollPane scrollPane;
    private JTable tableExamples;
    private JLabel lblTvShowFolder;
    private JTextField tfTvShowFolder;
    private JTextField tfEpisodeFilename;
    private JLabel lblEpisodeFileName;
    private JComboBox<LanguageStyle> cbLanguageStyle;

    public TvShowRenamerSettingsPanel() {
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        this.exampleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(TvShowRenamerExample.class)));
        DefaultEventTableModel exampleTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.exampleEventList), (TableFormat)new TvShowRenamerExampleTableFormat());
        ActionListener renamerActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TvShowRenamerSettingsPanel.this.checkChanges();
                TvShowRenamerSettingsPanel.this.createRenamerExample();
            }
        };
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                TvShowRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                TvShowRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                TvShowRenamerSettingsPanel.this.createRenamerExample();
            }
        };
        JPanel panelRenamer = new JPanel();
        panelRenamer.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.tvshow.renamer.title"), 4, 2, null, null));
        this.add((Component)panelRenamer, "2, 2, fill, fill");
        panelRenamer.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JLabel lblDefault = new JLabel(BUNDLE.getString("Settings.default"));
        TmmFontHelper.changeFont((JComponent)lblDefault, 0.833);
        panelRenamer.add((Component)lblDefault, "6, 2");
        this.lblTvShowFolder = new JLabel(BUNDLE.getString("Settings.tvshowfoldername"));
        panelRenamer.add((Component)this.lblTvShowFolder, "2, 3, right, default");
        this.tfTvShowFolder = new JTextField();
        panelRenamer.add((Component)this.tfTvShowFolder, "4, 3, fill, default");
        this.tfTvShowFolder.getDocument().addDocumentListener(documentListener);
        JLabel lblDefaultFolderName = new JLabel("$N ($Y)");
        TmmFontHelper.changeFont((JComponent)lblDefaultFolderName, 0.833);
        panelRenamer.add((Component)lblDefaultFolderName, "6, 3");
        this.lblSeasonFolderName = new JLabel(BUNDLE.getString("Settings.tvshowseasonfoldername"));
        panelRenamer.add((Component)this.lblSeasonFolderName, "2, 5, right, default");
        this.tfSeasonFoldername = new JTextField();
        panelRenamer.add((Component)this.tfSeasonFoldername, "4, 5, fill, default");
        this.tfSeasonFoldername.getDocument().addDocumentListener(documentListener);
        JLabel lblDefaultSeasonFoldername = new JLabel("Season $1");
        TmmFontHelper.changeFont((JComponent)lblDefaultSeasonFoldername, 0.833);
        panelRenamer.add((Component)lblDefaultSeasonFoldername, "6, 5");
        this.lblEpisodeFileName = new JLabel(BUNDLE.getString("Settings.tvshowfilename"));
        panelRenamer.add((Component)this.lblEpisodeFileName, "2, 7, right, default");
        this.tfEpisodeFilename = new JTextField();
        panelRenamer.add((Component)this.tfEpisodeFilename, "4, 7, fill, default");
        this.tfEpisodeFilename.getDocument().addDocumentListener(documentListener);
        this.chckbxAsciiReplacement = new JCheckBox(BUNDLE.getString("Settings.renamer.asciireplacement"));
        this.chckbxAsciiReplacement.addActionListener(renamerActionListener);
        this.chckbxSpaceReplacement = new JHintCheckBox(BUNDLE.getString("Settings.movie.renamer.spacesubstitution"));
        this.chckbxSpaceReplacement.setHintIcon(IconManager.HINT);
        this.chckbxSpaceReplacement.setToolTipText(BUNDLE.getString("Settings.tvshowspacereplacement.hint"));
        this.chckbxSpaceReplacement.addActionListener(renamerActionListener);
        JLabel lblDefaultEpisodeFilename = new JLabel("$N - S$2E$E - $T");
        TmmFontHelper.changeFont((JComponent)lblDefaultEpisodeFilename, 0.833);
        panelRenamer.add((Component)lblDefaultEpisodeFilename, "6, 7");
        panelRenamer.add((Component)this.chckbxSpaceReplacement, "2, 11, right, default");
        this.cbSpaceReplacement = new JComboBox<Object>(this.spaceReplacement.toArray());
        panelRenamer.add((Component)this.cbSpaceReplacement, "4, 11, fill, default");
        this.cbSpaceReplacement.addActionListener(renamerActionListener);
        panelRenamer.add((Component)this.chckbxAsciiReplacement, "2, 13, 9, 1");
        this.txtpntAsciiHint = new JTextPane();
        this.txtpntAsciiHint.setText(BUNDLE.getString("Settings.renamer.asciireplacement.hint"));
        TmmFontHelper.changeFont((JComponent)this.txtpntAsciiHint, 0.833);
        this.txtpntAsciiHint.setBackground(UIManager.getColor("Panel.background"));
        panelRenamer.add((Component)this.txtpntAsciiHint, "2, 15, 7, 1, fill, fill");
        JLabel lblLanguageStyle = new JLabel(BUNDLE.getString("Settings.renamer.language"));
        panelRenamer.add((Component)lblLanguageStyle, "2, 17, right, default");
        this.cbLanguageStyle = new JComboBox<LanguageStyle>(LanguageStyle.values());
        panelRenamer.add(this.cbLanguageStyle, "4, 17, 3, 1, fill, default");
        this.panelExample = new JPanel();
        this.panelExample.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.example"), 4, 2, null, null));
        this.add((Component)this.panelExample, "2, 4, fill, fill");
        this.panelExample.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"50dlu:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblExampleTvShowT = new JLabel(BUNDLE.getString("metatag.tvshow"));
        this.panelExample.add((Component)lblExampleTvShowT, "2, 2, right, default");
        this.cbTvShowForPreview = new JComboBox();
        this.cbTvShowForPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TvShowRenamerSettingsPanel.this.buildAndInstallEpisodeArray();
                TvShowRenamerSettingsPanel.this.createRenamerExample();
            }
        });
        this.panelExample.add((Component)this.cbTvShowForPreview, "4, 2");
        JLabel lblExampleEpisodeT = new JLabel(BUNDLE.getString("metatag.episode"));
        this.panelExample.add((Component)lblExampleEpisodeT, "2, 4, right, default");
        this.cbEpisodeForPreview = new JComboBox();
        this.cbEpisodeForPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TvShowRenamerSettingsPanel.this.createRenamerExample();
            }
        });
        this.panelExample.add((Component)this.cbEpisodeForPreview, "4, 4, fill, default");
        this.lblExample = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblExample, 1);
        this.panelExample.add((Component)this.lblExample, "2, 6, 3, 1");
        this.tableExamples = new ZebraJTable((TableModel)exampleTableModel);
        this.scrollPane = ZebraJTable.createStripedJScrollPane(this.tableExamples);
        this.scrollPane.setViewportView(this.tableExamples);
        this.panelExample.add((Component)this.scrollPane, "2, 8, 3, 1, fill, fill");
        this.initDataBindings();
        String spaceReplacement = this.settings.getRenamerSpaceReplacement();
        int index = this.spaceReplacement.indexOf(spaceReplacement);
        if (index >= 0) {
            this.cbSpaceReplacement.setSelectedIndex(index);
        }
        this.exampleEventList.add((Object)new TvShowRenamerExample("$T"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("$1"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("$2"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("$3"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("$4"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("$E"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("$D"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("$Y"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("$N"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("$M"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("$R"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("$A"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("$V"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("$F"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("$S"));
    }

    @Override
    public void hierarchyChanged(HierarchyEvent arg0) {
        if (this.isShowing()) {
            this.buildAndInstallTvShowArray();
            this.buildAndInstallEpisodeArray();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this);
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this);
        super.removeNotify();
    }

    private void buildAndInstallTvShowArray() {
        this.cbTvShowForPreview.removeAllItems();
        ArrayList<TvShow> allTvShows = new ArrayList<TvShow>(TvShowList.getInstance().getTvShows());
        Collections.sort(allTvShows, new TvShowComparator());
        for (TvShow tvShow : allTvShows) {
            TvShowPreviewContainer container = new TvShowPreviewContainer();
            container.tvShow = tvShow;
            this.cbTvShowForPreview.addItem(container);
        }
    }

    private void buildAndInstallEpisodeArray() {
        this.cbEpisodeForPreview.removeAllItems();
        Object obj = this.cbTvShowForPreview.getSelectedItem();
        if (obj != null && obj instanceof TvShowPreviewContainer) {
            TvShowPreviewContainer c = (TvShowPreviewContainer)this.cbTvShowForPreview.getSelectedItem();
            for (TvShowEpisode episode : c.tvShow.getEpisodes()) {
                TvShowEpisodePreviewContainer container = new TvShowEpisodePreviewContainer();
                container.episode = episode;
                this.cbEpisodeForPreview.addItem(container);
            }
        }
    }

    private void createRenamerExample() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object container;
                TvShow tvShow = null;
                TvShowEpisode episode = null;
                if (TvShowRenamerSettingsPanel.this.cbTvShowForPreview.getSelectedItem() instanceof TvShowPreviewContainer) {
                    container = (TvShowPreviewContainer)TvShowRenamerSettingsPanel.this.cbTvShowForPreview.getSelectedItem();
                    tvShow = ((TvShowPreviewContainer)container).tvShow;
                }
                if (TvShowRenamerSettingsPanel.this.cbEpisodeForPreview.getSelectedItem() instanceof TvShowEpisodePreviewContainer) {
                    container = (TvShowEpisodePreviewContainer)TvShowRenamerSettingsPanel.this.cbEpisodeForPreview.getSelectedItem();
                    episode = ((TvShowEpisodePreviewContainer)container).episode;
                }
                if (tvShow != null && episode != null) {
                    String tvShowDir = TvShowRenamer.generateTvShowDir(TvShowRenamerSettingsPanel.this.tfTvShowFolder.getText(), tvShow);
                    String filename = TvShowRenamer.generateFilename(TvShowRenamerSettingsPanel.this.tfEpisodeFilename.getText(), tvShow, episode.getMediaFiles(MediaFileType.VIDEO).get(0));
                    String seasonDir = TvShowRenamer.generateSeasonDir(TvShowRenamerSettingsPanel.this.tfSeasonFoldername.getText(), episode);
                    if (StringUtils.isBlank((CharSequence)seasonDir)) {
                        TvShowRenamerSettingsPanel.this.lblExample.setText(tvShowDir + File.separator + filename);
                    } else {
                        TvShowRenamerSettingsPanel.this.lblExample.setText(tvShowDir + File.separator + seasonDir + File.separator + filename);
                    }
                    for (TvShowRenamerExample example : TvShowRenamerSettingsPanel.this.exampleEventList) {
                        example.createExample(episode);
                    }
                    try {
                        TableColumnResizer.adjustColumnPreferredWidths(TvShowRenamerSettingsPanel.this.tableExamples, 7);
                    }
                    catch (Exception e) {}
                } else {
                    TvShowRenamerSettingsPanel.this.lblExample.setText("");
                }
            }
        });
    }

    private void checkChanges() {
        String spaceReplacement = (String)this.cbSpaceReplacement.getSelectedItem();
        this.settings.setRenamerSpaceReplacement(spaceReplacement);
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"asciiReplacement");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, (Object)this.chckbxAsciiReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"renamerSpaceSubstitution");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.chckbxSpaceReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"renamerTvShowFoldername");
        BeanProperty jTextFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, (Object)this.tfTvShowFolder, (Property)jTextFieldBeanProperty_1);
        autoBinding.bind();
        BeanProperty tvShowSettingsBeanProperty_2 = BeanProperty.create((String)"renamerFilename");
        BeanProperty jTextFieldBeanProperty_2 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_2, (Object)this.tfEpisodeFilename, (Property)jTextFieldBeanProperty_2);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty_3 = BeanProperty.create((String)"renamerSeasonFoldername");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_3, (Object)this.tfSeasonFoldername, (Property)jTextFieldBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSettingsBeanProperty_4 = BeanProperty.create((String)"tvShowRenamerLanguageStyle");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_4, this.cbLanguageStyle, (Property)jComboBoxBeanProperty);
        autoBinding_3.bind();
    }

    private class TvShowRenamerExampleTableFormat
    implements TableFormat<TvShowRenamerExample> {
        private TvShowRenamerExampleTableFormat() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return null;
                }
                case 1: {
                    return BUNDLE.getString("Settings.renamer.token");
                }
                case 2: {
                    return BUNDLE.getString("Settings.renamer.value");
                }
            }
            return null;
        }

        public Object getColumnValue(TvShowRenamerExample baseObject, int column) {
            switch (column) {
                case 0: {
                    return baseObject.token;
                }
                case 1: {
                    return baseObject.description;
                }
                case 2: {
                    return baseObject.example;
                }
            }
            return null;
        }
    }

    private class TvShowRenamerExample
    extends AbstractModelObject {
        private String token;
        private String description;
        private String example = "";

        public TvShowRenamerExample(String token) {
            this.token = token;
            try {
                this.description = BUNDLE.getString("Settings.tvshow.renamer." + token);
            }
            catch (Exception e) {
                this.description = "";
            }
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getExample() {
            return this.example;
        }

        public void setExample(String example) {
            this.example = example;
        }

        private void createExample(TvShowEpisode episode) {
            String oldValue = this.example;
            this.example = episode == null ? "" : TvShowRenamer.createDestination(this.token, episode.getTvShow(), Arrays.asList(episode));
            this.firePropertyChange("example", oldValue, this.example);
        }
    }

    private class TvShowComparator
    implements Comparator<TvShow> {
        private TvShowComparator() {
        }

        @Override
        public int compare(TvShow arg0, TvShow arg1) {
            return arg0.getTitle().compareTo(arg1.getTitle());
        }
    }

    private class TvShowEpisodePreviewContainer {
        TvShowEpisode episode;

        private TvShowEpisodePreviewContainer() {
        }

        public String toString() {
            return this.episode.getSeason() + "." + this.episode.getEpisode() + " " + this.episode.getTitle();
        }
    }

    private class TvShowPreviewContainer {
        TvShow tvShow;

        private TvShowPreviewContainer() {
        }

        public String toString() {
            return this.tvShow.getTitle();
        }
    }
}

