/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.util.Collections;
import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.tvshows.TvShowSeasonTreeNode;

public class TvShowTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -1316609340104597133L;
    private Comparator<TreeNode> nodeComparator = new Comparator<TreeNode>(){

        @Override
        public int compare(TreeNode o1, TreeNode o2) {
            if (o1 instanceof TvShowSeasonTreeNode && o2 instanceof TvShowSeasonTreeNode) {
                TvShowSeasonTreeNode node1 = (TvShowSeasonTreeNode)o1;
                TvShowSeason tvShowSeason1 = (TvShowSeason)node1.getUserObject();
                TvShowSeasonTreeNode node2 = (TvShowSeasonTreeNode)o2;
                TvShowSeason tvShowSeason2 = (TvShowSeason)node2.getUserObject();
                return tvShowSeason1.getSeason() - tvShowSeason2.getSeason();
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    };

    public TvShowTreeNode(Object userObject) {
        super(userObject);
    }

    @Override
    public String toString() {
        if (this.getUserObject() instanceof TvShow) {
            TvShow tvShow = (TvShow)this.getUserObject();
            return tvShow.getTitle();
        }
        return super.toString();
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        if (this.children != null) {
            int index = Collections.binarySearch(this.children, newChild, this.nodeComparator);
            if (index < 0) {
                super.insert(newChild, -index - 1);
            } else if (index >= 0) {
                super.insert(newChild, index);
            }
        } else {
            super.insert(newChild, childIndex);
        }
    }
}

