/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieSubtitleSearchAndDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieDownloadSubtitleDialog;

public class MovieSubtitleDownloadAction
extends AbstractAction {
    private static final long serialVersionUID = -6002932119900795735L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieSubtitleDownloadAction() {
        this.putValue("Name", BUNDLE.getString("movie.download.subtitle"));
        this.putValue("SmallIcon", IconManager.SUBTITLE);
        this.putValue("SwingLargeIconKey", IconManager.SUBTITLE);
        this.putValue("ShortDescription", BUNDLE.getString("movie.download.subtitle"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (!selectedMovies.isEmpty()) {
            MovieDownloadSubtitleDialog dialog = new MovieDownloadSubtitleDialog(BUNDLE.getString("movie.download.subtitle"));
            dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
            dialog.setVisible(true);
            if (dialog.shouldStartDownload()) {
                MovieSubtitleSearchAndDownloadTask task = new MovieSubtitleSearchAndDownloadTask(selectedMovies, dialog.getSubtitleScrapers(), dialog.getLanguage());
                TmmTaskManager.getInstance().addMainTask(task);
            }
        }
    }
}

