/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieChooserDialog;

public class MovieSingleScrapeAction
extends AbstractAction {
    private static final long serialVersionUID = 3066746719177708420L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieSingleScrapeAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("movie.scrape.selected"));
        }
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("ShortDescription", BUNDLE.getString("movie.scrape.selected"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Movie movie;
        MovieChooserDialog dialogMovieChooser;
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        Iterator i$ = selectedMovies.iterator();
        while (i$.hasNext() && (dialogMovieChooser = new MovieChooserDialog(movie = (Movie)i$.next(), selectedMovies.size() > 1)).showDialog()) {
        }
    }
}

