/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.converter;

import java.net.URL;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jdesktop.beansbinding.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.ui.movies.MovieGenresPanel;

public class CertificationImageConverter
extends Converter<Certification, Icon> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificationImageConverter.class);
    public static final ImageIcon emptyImage = new ImageIcon();

    public Icon convertForward(Certification cert) {
        try {
            StringBuilder sb = new StringBuilder("/images/certifications/");
            sb.append(cert.name().toLowerCase(Locale.ROOT));
            sb.append(".png");
            URL file = MovieGenresPanel.class.getResource(sb.toString());
            if (file == null) {
                sb = new StringBuilder("/images/certifications/");
                String certName = cert.name();
                sb.append(certName.replace(cert.getCountry().getAlpha2() + "_", "").toLowerCase(Locale.ROOT));
                sb.append(".png");
                file = MovieGenresPanel.class.getResource(sb.toString());
            }
            if (file != null) {
                return new ImageIcon(file);
            }
        }
        catch (Exception e) {
            LOGGER.warn("cannot convert certification", (Throwable)e);
        }
        return emptyImage;
    }

    public Certification convertReverse(Icon arg0) {
        return null;
    }
}

