/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class ZebraJTree
extends JTree {
    private static final long serialVersionUID = -8401898893090686850L;
    public Color[] rowColors = new Color[2];
    private boolean drawStripes = false;
    private DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();
    private RendererEditorWrapper wrapper = null;

    public ZebraJTree() {
    }

    public ZebraJTree(Hashtable<?, ?> value) {
        super(value);
    }

    public ZebraJTree(Object[] value) {
        super(value);
    }

    public ZebraJTree(TreeModel newModel) {
        super(newModel);
    }

    public ZebraJTree(TreeNode root) {
        super(root);
    }

    public ZebraJTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
    }

    public ZebraJTree(Vector<?> value) {
        super(value);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.drawStripes = this.isOpaque();
        if (!this.drawStripes) {
            super.paintComponent(g);
            return;
        }
        this.updateZebraColors();
        Insets insets = this.getInsets();
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getHeight() - insets.top - insets.bottom;
        int x = insets.left;
        int y = insets.top;
        int nRows = 0;
        int startRow = 0;
        int rowHeight = this.getRowHeight();
        if (rowHeight > 0) {
            nRows = h / rowHeight;
        } else {
            int nItems = this.getRowCount();
            rowHeight = 17;
            int i = 0;
            while (i < nItems) {
                Rectangle rect = this.getRowBounds(i);
                rowHeight = rect != null ? rect.height : rowHeight;
                g.setColor(this.getSelectionModel().isRowSelected(i) ? this.defaultRenderer.getBackgroundSelectionColor() : this.rowColors[i & 1]);
                g.fillRect(x, y, w, rowHeight);
                ++i;
                y += rowHeight;
            }
            nRows = nItems + (insets.top + h - y) / rowHeight;
            startRow = nItems;
        }
        int i = startRow;
        while (i < nRows) {
            g.setColor(this.getSelectionModel().isRowSelected(i) ? this.defaultRenderer.getBackgroundSelectionColor() : this.rowColors[i & 1]);
            g.fillRect(x, y, w, rowHeight);
            ++i;
            y += rowHeight;
        }
        int remainder = insets.top + h - y;
        if (remainder > 0) {
            g.setColor(this.rowColors[nRows & 1]);
            g.fillRect(x, y, w, remainder);
        }
        this.setOpaque(false);
        super.paintComponent(g);
        this.setOpaque(true);
    }

    @Override
    public TreeCellRenderer getCellRenderer() {
        TreeCellRenderer ren = super.getCellRenderer();
        if (ren == null) {
            return null;
        }
        if (this.wrapper == null) {
            this.wrapper = new RendererEditorWrapper();
        }
        this.wrapper.ren = ren;
        return this.wrapper;
    }

    @Override
    public TreeCellEditor getCellEditor() {
        TreeCellEditor ed = super.getCellEditor();
        if (ed == null) {
            return null;
        }
        if (this.wrapper == null) {
            this.wrapper = new RendererEditorWrapper();
        }
        this.wrapper.ed = ed;
        return this.wrapper;
    }

    private void updateZebraColors() {
        this.rowColors[0] = this.getBackground();
        if (this.rowColors[0] == null) {
            this.rowColors[0] = this.rowColors[1] = Color.white;
            return;
        }
        Color sel = UIManager.getColor("Tree.selectionBackground");
        if (sel == null) {
            sel = SystemColor.textHighlight;
        }
        if (sel == null) {
            this.rowColors[1] = this.rowColors[0];
            return;
        }
        this.rowColors[1] = new Color(241, 245, 250);
    }

    private class RendererEditorWrapper
    implements TreeCellRenderer,
    TreeCellEditor {
        public TreeCellRenderer ren = null;
        public TreeCellEditor ed = null;

        private RendererEditorWrapper() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = this.ren.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (selected || !ZebraJTree.this.drawStripes) {
                return c;
            }
            if (!(c instanceof DefaultTreeCellRenderer)) {
                c.setBackground(ZebraJTree.this.rowColors[row & 1]);
            } else {
                ((DefaultTreeCellRenderer)c).setBackgroundNonSelectionColor(ZebraJTree.this.rowColors[row & 1]);
            }
            return c;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            Component c = this.ed.getTreeCellEditorComponent(tree, value, selected, expanded, leaf, row);
            if (!selected && ZebraJTree.this.drawStripes) {
                c.setBackground(ZebraJTree.this.rowColors[row & 1]);
            }
            return c;
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.ed.addCellEditorListener(l);
        }

        @Override
        public void cancelCellEditing() {
            this.ed.cancelCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this.ed.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.ed.isCellEditable(anEvent);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.ed.removeCellEditorListener(l);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.ed.shouldSelectCell(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            return this.ed.stopCellEditing();
        }
    }
}

