/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;

public class TaskListComponent
extends JPanel {
    private static final long serialVersionUID = -6088880093610800005L;
    private static final int UPPERMARGIN = 3;
    private static final int LEFTMARGIN = 2;
    private static final int BOTTOMMARGIN = 2;
    private static final int BETWEENTEXTMARGIN = 3;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    static final int ITEM_WIDTH = 400;
    private TmmTaskHandle taskHandle;
    private JLabel mainLabel;
    private JLabel dynaLabel;
    private JProgressBar bar;
    private JButton closeButton;
    private int mainHeight;
    private int dynaHeight;
    private int buttonWidth;

    public TaskListComponent(TmmTaskHandle handle) {
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setLayout(new CustomLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.taskHandle = handle;
        this.mainLabel = new JLabel();
        this.dynaLabel = new JLabel();
        this.bar = new JProgressBar();
        this.closeButton = new JButton(new CancelAction());
        this.closeButton.setBorderPainted(false);
        this.closeButton.setBorder(BorderFactory.createEmptyBorder());
        this.closeButton.setOpaque(false);
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.setFocusable(false);
        this.mainLabel.setText("XYZ");
        this.dynaLabel.setText("XYZ");
        this.mainHeight = Math.max(this.mainLabel.getPreferredSize().height, this.closeButton.getPreferredSize().height);
        this.dynaHeight = this.dynaLabel.getPreferredSize().height;
        this.buttonWidth = this.closeButton.getPreferredSize().width;
        this.mainLabel.setText(null);
        this.dynaLabel.setText(null);
        this.add(this.mainLabel);
        this.add(this.bar);
        this.add(this.closeButton);
        this.add(this.dynaLabel);
        this.updateTaskInformation();
    }

    public void updateTaskInformation() {
        this.mainLabel.setText(this.taskHandle.getTaskName());
        switch (this.taskHandle.getState()) {
            case CREATED: 
            case STARTED: {
                if (StringUtils.isNotBlank((CharSequence)this.taskHandle.getTaskDescription())) {
                    this.dynaLabel.setText(this.taskHandle.getTaskDescription());
                    break;
                }
                this.dynaLabel.setText(BUNDLE.getString("task.running"));
                break;
            }
            case QUEUED: {
                this.dynaLabel.setText(BUNDLE.getString("task.queued"));
                break;
            }
            case CANCELLED: {
                this.dynaLabel.setText(BUNDLE.getString("task.cancelled"));
                break;
            }
            case FINISHED: {
                this.dynaLabel.setText(BUNDLE.getString("task.finished"));
            }
        }
        if (this.taskHandle.getWorkUnits() > 0) {
            this.bar.setValue(this.taskHandle.getProgressDone());
            this.bar.setMaximum(this.taskHandle.getWorkUnits());
            this.bar.setIndeterminate(false);
        } else if (this.taskHandle.getState() == TmmTaskHandle.TaskState.QUEUED) {
            this.bar.setIndeterminate(false);
            this.bar.setValue(0);
            this.bar.setMaximum(1);
        } else {
            this.bar.setIndeterminate(true);
        }
    }

    TmmTaskHandle getHandle() {
        return this.taskHandle;
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -2634569716059018131L;

        public CancelAction() {
            this.putValue("SmallIcon", IconManager.PROCESS_STOP);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TaskListComponent.this.taskHandle.cancel();
        }
    }

    private class CustomLayout
    implements LayoutManager {
        private CustomLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int height = 3 + TaskListComponent.this.mainHeight + 3 + TaskListComponent.this.dynaHeight + 2;
            return new Dimension(400, height);
        }

        @Override
        public void layoutContainer(Container parent) {
            int parentWidth = parent.getWidth();
            int offset = parentWidth - TaskListComponent.this.buttonWidth - 2;
            if (TaskListComponent.this.closeButton != null) {
                TaskListComponent.this.closeButton.setBounds(offset, 3, TaskListComponent.this.buttonWidth, TaskListComponent.this.mainHeight);
            }
            int barOffset = offset - 133;
            TaskListComponent.this.bar.setBounds(barOffset, 3, offset - barOffset - 2, TaskListComponent.this.mainHeight);
            TaskListComponent.this.mainLabel.setBounds(2, 3, barOffset - 2, TaskListComponent.this.mainHeight);
            TaskListComponent.this.dynaLabel.setBounds(2, TaskListComponent.this.mainHeight + 3 + 3, parentWidth - 2, TaskListComponent.this.dynaHeight);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

