/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import com.jtattoo.plaf.luna.LunaComboBoxUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.tinymediamanager.ui.TmmFontHelper;

public class SmallComboBox
extends JComboBox {
    private static final long serialVersionUID = 256568641808640L;

    public SmallComboBox() {
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SmallComboBox(Object[] items) {
        super(items);
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init() throws Exception {
        this.setRenderer(new SmallComboBoxRenderer());
        this.setEditor(new SmallComboBoxEditor());
        this.setUI((ComboBoxUI)((Object)new SmallComboBoxUI()));
    }

    static class SmallComboBoxUI
    extends LunaComboBoxUI {
        SmallComboBoxUI() {
        }

        public static ComponentUI createUI(JComponent c) {
            return new SmallComboBoxUI();
        }

        public void installUI(JComponent c) {
            super.installUI(c);
            this.comboBox.setRequestFocusEnabled(true);
            if (this.comboBox.getEditor() != null && this.comboBox.getEditor().getEditorComponent() instanceof JTextField) {
                ((JTextField)this.comboBox.getEditor().getEditorComponent()).setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
            }
        }

        public Dimension getPreferredSize(JComponent c) {
            Dimension size = super.getPreferredSize(c);
            return new Dimension(size.width + 2, size.height - 2);
        }
    }

    class SmallComboBoxEditor
    extends BasicComboBoxEditor {
        private JPanel panel = new JPanel();
        private JLabel labelItem = new JLabel();

        public SmallComboBoxEditor() {
            this.panel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.insets = new Insets(0, 2, 0, 2);
            this.labelItem.setOpaque(false);
            this.labelItem.setHorizontalAlignment(2);
            this.labelItem.setForeground(Color.WHITE);
            this.panel.add((Component)this.labelItem, constraints);
            this.panel.setBackground(Color.BLUE);
        }

        @Override
        public Component getEditorComponent() {
            return this.panel;
        }

        @Override
        public Object getItem() {
            return null;
        }
    }

    class SmallComboBoxRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 7291014994809111069L;
        private JLabel labelItem = new JLabel();

        public SmallComboBoxRenderer() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.insets = new Insets(0, 2, 0, 2);
            this.labelItem.setOpaque(false);
            this.labelItem.setHorizontalAlignment(2);
            TmmFontHelper.changeFont((JComponent)this.labelItem, 0.916);
            this.add((Component)this.labelItem, constraints);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                this.labelItem.setText(value.toString());
            }
            Color bg = null;
            Color fg = null;
            bg = UIManager.getColor("List.dropCellBackground");
            fg = UIManager.getColor("List.dropCellForeground");
            if (isSelected) {
                this.setBackground(bg == null ? list.getSelectionBackground() : bg);
                this.setForeground(fg == null ? list.getSelectionForeground() : fg);
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

