/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFXFileChooser {
    private static final Logger LOGGER = LoggerFactory.getLogger(JFXFileChooser.class);
    private Class<?> clazz = Class.forName("javafx.stage.FileChooser");
    private Object fileChooser = this.clazz.newInstance();

    public File showOpenDialog() {
        try {
            Method method = this.clazz.getMethod("showOpenDialog", Class.forName("javafx.stage.Window"));
            Object obj = method.invoke(this.fileChooser, new Object[]{null});
            if (obj instanceof File) {
                return (File)obj;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
            return null;
        }
    }

    public List<File> showOpenMultipleDialog() {
        try {
            ArrayList<File> files = new ArrayList<File>();
            Method method = this.clazz.getMethod("showOpenMultipleDialog", Class.forName("javafx.stage.Window"));
            Object objs = method.invoke(this.fileChooser, new Object[]{null});
            if (objs instanceof List) {
                files.addAll((Collection)objs);
                return files;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
            return null;
        }
    }

    public File showSaveDialog() {
        try {
            Method method = this.clazz.getMethod("showSaveDialog", Class.forName("javafx.stage.Window"));
            Object obj = method.invoke(this.fileChooser, new Object[]{null});
            if (obj instanceof File) {
                return (File)obj;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
            return null;
        }
    }

    public void setInitialDirectory(File dir) {
        try {
            Method method = this.clazz.getMethod("setInitialDirectory", File.class);
            method.invoke(this.fileChooser, dir);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
    }

    public void setInitialFileName(String name) {
        try {
            Method method = this.clazz.getMethod("setInitialFileName", String.class);
            method.invoke(this.fileChooser, name);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
    }

    public void setTitle(String name) {
        try {
            Method method = this.clazz.getMethod("setTitle", String.class);
            method.invoke(this.fileChooser, name);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
    }

    public String getTitle() {
        try {
            Method method = this.clazz.getMethod("getTitle", new Class[0]);
            return (String)method.invoke(this.fileChooser, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
            return "";
        }
    }

    public File getInitialDirectory() {
        try {
            Method method = this.clazz.getMethod("getInitialDirectory", new Class[0]);
            return (File)method.invoke(this.fileChooser, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
            return null;
        }
    }

    public void addExtensionFilter(String description, List<String> ext) {
        try {
            Method method = this.clazz.getMethod("getExtensionFilters", new Class[0]);
            Object obj = Class.forName("javafx.collections.ObservableList").cast(method.invoke(this.fileChooser, new Object[0]));
            Object filter = Class.forName("javafx.stage.FileChooser$ExtensionFilter").getConstructor(String.class, List.class).newInstance(description, ext);
            ((List)obj).add(filter);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
    }
}

