/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;

public class ClearDatabaseAction
extends AbstractAction {
    private static final long serialVersionUID = 5840749350843921771L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(ClearDatabaseAction.class);

    public ClearDatabaseAction() {
        this.putValue("Name", BUNDLE.getString("tmm.cleardatabase"));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        int answer = JOptionPane.showConfirmDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.cleardatabase.hint"), BUNDLE.getString("tmm.cleardatabase"), 0);
        if (answer != 0) {
            return;
        }
        MainWindow.getActiveInstance().setCursor(Cursor.getPredefinedCursor(3));
        try {
            TmmModuleManager.getInstance().shutDown();
            TmmModuleManager.getInstance().initializeDatabase();
            MainWindow.getActiveInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(null, BUNDLE.getString("tmm.cleardatabase.info"));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, BUNDLE.getString("tmm.cleardatabase.error"));
            Path path = Paths.get("", new String[0]);
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    TmmUIHelper.openFile(path);
                }
            }
            catch (Exception ex) {
                LOGGER.warn(ex.getMessage());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
            }
        }
        MainWindow.getActiveInstance().closeTmmAndStart(Utils.getPBforTMMrestart());
    }
}

