/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.UTF8Control;

public class TvShowEpisodeScrapeTask
extends TmmTask {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeScrapeTask.class);
    private final List<TvShowEpisode> episodes;
    private final MediaScraper mediaScraper;
    private boolean scrapeThumb;
    private MediaLanguages language = TvShowModuleManager.SETTINGS.getScraperLanguage();

    public TvShowEpisodeScrapeTask(List<TvShowEpisode> episodes, MediaScraper mediaScraper) {
        super(BUNDLE.getString("tvshow.scraping"), episodes.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.episodes = episodes;
        this.mediaScraper = mediaScraper;
        this.scrapeThumb = true;
    }

    public TvShowEpisodeScrapeTask(List<TvShowEpisode> episodes, MediaScraper mediaScraper, boolean scrapeThumb) {
        super(BUNDLE.getString("tvshow.scraping"), episodes.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.episodes = episodes;
        this.mediaScraper = mediaScraper;
        this.scrapeThumb = scrapeThumb;
    }

    @Override
    public void doInBackground() {
        for (TvShowEpisode episode : this.episodes) {
            if (episode.getTvShow().getIds().size() == 0) {
                LOGGER.info("we cannot scrape (no ID): " + episode.getTvShow().getTitle() + " - " + episode.getTitle());
                continue;
            }
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.TV_EPISODE);
            options.setLanguage(LocaleUtils.toLocale((String)this.language.name()));
            options.setCountry(TvShowModuleManager.SETTINGS.getCertificationCountry());
            MediaMetadata md = new MediaMetadata(this.mediaScraper.getMediaProvider().getProviderInfo().getId());
            md.setReleaseDate(episode.getFirstAired());
            options.setMetadata(md);
            for (Map.Entry<String, Object> entry : episode.getTvShow().getIds().entrySet()) {
                options.setId(entry.getKey(), entry.getValue().toString());
            }
            if (episode.isDvdOrder()) {
                options.setId("dvdSeasonNr", String.valueOf(episode.getDvdSeason()));
                options.setId("dvdEpisodeNr", String.valueOf(episode.getDvdEpisode()));
            } else {
                options.setId("seasonNr", String.valueOf(episode.getAiredSeason()));
                options.setId("episodeNr", String.valueOf(episode.getAiredEpisode()));
            }
            if (this.scrapeThumb) {
                options.setArtworkType(MediaArtwork.MediaArtworkType.THUMB);
            } else {
                options.setArtworkType(null);
            }
            try {
                LOGGER.info("=====================================================");
                LOGGER.info("Scraper metadata with scraper: " + this.mediaScraper.getMediaProvider().getProviderInfo().getId() + ", " + this.mediaScraper.getMediaProvider().getProviderInfo().getVersion());
                LOGGER.info(options.toString());
                LOGGER.info("=====================================================");
                MediaMetadata metadata = ((ITvShowMetadataProvider)this.mediaScraper.getMediaProvider()).getMetadata(options);
                if (!StringUtils.isNotBlank((CharSequence)metadata.getTitle())) continue;
                episode.setMetadata(metadata);
            }
            catch (Exception e) {
                LOGGER.warn("Error getting metadata " + e.getMessage());
            }
        }
        if (TvShowModuleManager.SETTINGS.getSyncTrakt()) {
            HashSet<TvShow> tvShows = new HashSet<TvShow>();
            for (TvShowEpisode episode : this.episodes) {
                tvShows.add(episode.getTvShow());
            }
            SyncTraktTvTask task = new SyncTraktTvTask(null, new ArrayList<TvShow>(tvShows));
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
    }

    public MediaLanguages getLanguage() {
        return this.language;
    }

    public void setLanguage(MediaLanguages language) {
        this.language = language;
    }
}

