/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.util.ArrayList;
import java.util.List;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.scraper.MediaScraper;

public class TvShowSearchAndScrapeOptions {
    private TvShowScraperMetadataConfig scraperMetadataConfig;
    private MediaScraper metadataScraper;
    private List<MediaScraper> artworkScrapers = new ArrayList<MediaScraper>();

    public void loadDefaults() {
        this.scraperMetadataConfig = Globals.settings.getTvShowScraperMetadataConfig();
        this.metadataScraper = TvShowList.getInstance().getDefaultMediaScraper();
        this.artworkScrapers.addAll(TvShowList.getInstance().getDefaultArtworkScrapers());
    }

    public TvShowScraperMetadataConfig getScraperMetadataConfig() {
        return this.scraperMetadataConfig;
    }

    public MediaScraper getMetadataScraper() {
        return this.metadataScraper;
    }

    public List<MediaScraper> getArtworkScrapers() {
        return this.artworkScrapers;
    }

    public void setScraperMetadataConfig(TvShowScraperMetadataConfig scraperMetadataConfig) {
        this.scraperMetadataConfig = scraperMetadataConfig;
    }

    public void setMetadataScraper(MediaScraper metadataScraper) {
        this.metadataScraper = metadataScraper;
    }

    public void addArtworkScraper(MediaScraper artworkScraper) {
        this.artworkScrapers.add(artworkScraper);
    }
}

