/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.threading;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Locale;
import java.util.ResourceBundle;
import okhttp3.Headers;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.scraper.http.StreamingUrl;
import org.tinymediamanager.scraper.util.UrlUtil;
import org.tinymediamanager.ui.UTF8Control;

public class DownloadTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    protected String url;
    protected Path file;
    protected MediaEntity media;
    protected MediaFileType fileType;
    protected String userAgent = "";

    public DownloadTask(String url, Path toFile) {
        this(url, toFile, null, null);
    }

    public DownloadTask(String url, Path toFile, MediaEntity addToMe, MediaFileType expectedFiletype) {
        super(BUNDLE.getString("task.download") + " " + toFile, 100, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.url = url;
        this.file = toFile;
        this.media = addToMe;
        this.fileType = expectedFiletype;
        this.setTaskDescription(this.file.getFileName().toString());
    }

    public void setSpecialUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    protected void doInBackground() {
        try {
            if (StringUtils.isBlank((CharSequence)this.url) || !this.url.toLowerCase(Locale.ROOT).startsWith("http")) {
                return;
            }
            String ext = FilenameUtils.getExtension((String)this.file.getFileName().toString());
            if (ext != null && ext.length() > 4 || !Globals.settings.getAllSupportedFileTypes().contains("." + ext)) {
                ext = "";
            }
            if ((ext == null || ext.isEmpty()) && !(ext = UrlUtil.getExtension((String)this.url)).isEmpty()) {
                if (Globals.settings.getAllSupportedFileTypes().contains("." + ext)) {
                    this.file = this.file.getParent().resolve(this.file.getFileName() + "." + ext);
                } else {
                    ext = "";
                }
            }
            LOGGER.info("Downloading " + this.url);
            StreamingUrl u = new StreamingUrl(UrlUtil.getURIEncoded((String)this.url).toASCIIString());
            if (StringUtils.isNotBlank((CharSequence)this.userAgent)) {
                u.setUserAgent(this.userAgent);
            }
            InputStream is = u.getInputStream();
            LOGGER.trace("Server returned: " + u.getStatusLine());
            Headers headers = u.getHeadersResponse();
            for (String name : headers.names()) {
                LOGGER.trace(" < " + name + ": " + headers.get(name));
            }
            if (u.isFault()) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, u.getUrl(), u.getStatusLine()));
                is.close();
                return;
            }
            long length = u.getContentLength();
            String type = u.getContentEncoding();
            if (ext.isEmpty()) {
                if (type.startsWith("video/") || type.startsWith("audio/") || type.startsWith("image/")) {
                    ext = type.split("/")[1];
                    ext = ext.replaceAll("x-", "");
                    this.file = this.file.getParent().resolve(this.file.getFileName() + "." + ext);
                }
                if ("application/zip".equals(type)) {
                    ext = "zip";
                    this.file = this.file.getParent().resolve(this.file.getFileName() + "." + ext);
                }
            }
            if (ext.isEmpty()) {
                ext = "dat";
            }
            LOGGER.info("Downloading to " + this.file);
            Path tempFile = this.file.resolveSibling(this.file.getFileName() + ".part");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(is);
            FileOutputStream outputStream = new FileOutputStream(tempFile.toFile());
            int count = 0;
            byte[] buffer = new byte[2048];
            Long timestamp1 = System.nanoTime();
            long bytesDone = 0L;
            long bytesDonePrevious = 0L;
            double speed = 0.0;
            while ((count = bufferedInputStream.read(buffer, 0, buffer.length)) != -1 && !this.cancel) {
                outputStream.write(buffer, 0, count);
                bytesDone += (long)count;
                Long timestamp2 = System.nanoTime();
                if (timestamp2 - timestamp1 <= 250000000L) continue;
                speed = (speed + (double)(bytesDone - bytesDonePrevious) / ((double)(timestamp2 - timestamp1) / 1.0E9)) / 2.0;
                timestamp1 = timestamp2;
                bytesDonePrevious = bytesDone;
                if (length > 0L) {
                    this.publishState(this.formatBytesForOutput(bytesDone) + "/" + this.formatBytesForOutput(length) + " @" + this.formatSpeedForOutput(speed), (int)(bytesDone * 100L / length));
                    continue;
                }
                this.setWorkUnits(0);
                this.publishState(this.formatBytesForOutput(bytesDone) + " @" + this.formatSpeedForOutput(speed), 0);
            }
            outputStream.close();
            if (!this.cancel) {
                is.close();
            }
            if (this.cancel) {
                Utils.deleteFileSafely(tempFile);
            } else {
                if (ext.isEmpty()) {
                    MediaFile mf = new MediaFile(tempFile);
                    mf.setContainerFormatDirect();
                    ext = mf.getContainerFormat();
                    if (!ext.isEmpty()) {
                        this.file = this.file.getParent().resolve(this.file.getFileName() + "." + ext);
                    }
                }
                Utils.deleteFileSafely(this.file);
                boolean ok = Utils.moveFileSafe(tempFile, this.file);
                if (ok) {
                    Utils.deleteFileSafely(tempFile);
                    if (this.media != null) {
                        MediaFile mf = new MediaFile(this.file, this.fileType);
                        mf.gatherMediaInformation();
                        this.media.removeFromMediaFiles(mf);
                        this.media.addToMediaFiles(mf);
                        this.media.saveToDb();
                    }
                } else {
                    LOGGER.warn("Download to '" + tempFile + "' was ok, but couldn't move to '" + this.file + "'");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("problem downloading: ", (Throwable)e);
        }
    }

    private String formatBytesForOutput(long bytes) {
        return String.format("%.2fM", (double)bytes / 1048576.0);
    }

    private String formatSpeedForOutput(double speed) {
        return String.format("%.2fkB/s", speed / 1024.0);
    }
}

