/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.ImageCacheTask;
import org.tinymediamanager.core.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.connector.MovieToKodiNfoConnector;
import org.tinymediamanager.core.movie.connector.MovieToMpNfoConnector;
import org.tinymediamanager.core.movie.connector.MovieToXbmcNfoConnector;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.UTF8Control;

@Deprecated
public class MovieUpdateDatasourceTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieUpdateDatasourceTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final List<String> skipFolders = Arrays.asList(".", "..", "CERTIFICATE", "BACKUP", "PLAYLIST", "CLPINF", "SSIF", "AUXDATA", "AUDIO_TS", "$RECYCLE.BIN", "RECYCLER", "SYSTEM VOLUME INFORMATION", "@EADIR");
    private static final String skipFoldersRegex = "^[.][\\w@]+.*";
    private static Pattern video3DPattern = Pattern.compile("(?i)[ ._\\(\\[-]3D[ ._\\)\\]-]?");
    private List<String> dataSources;
    private MovieList movieList;
    private HashSet<File> filesFound = new HashSet();

    @Deprecated
    public MovieUpdateDatasourceTask() {
        super(BUNDLE.getString("update.datasource"));
        this.movieList = MovieList.getInstance();
        this.dataSources = new ArrayList<String>(MovieModuleManager.MOVIE_SETTINGS.getMovieDataSource());
    }

    @Deprecated
    public MovieUpdateDatasourceTask(String datasource) {
        super(BUNDLE.getString("update.datasource") + " (" + datasource + ")");
        this.movieList = MovieList.getInstance();
        this.dataSources = new ArrayList<String>(1);
        this.dataSources.add(datasource);
    }

    @Override
    public void doInBackground() {
        Utils.removeEmptyStringsFromList(this.dataSources);
        if (this.dataSources.isEmpty()) {
            LOGGER.info("no datasource to update");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "update.datasource.nonespecified"));
            return;
        }
        ArrayList<File> existing = new ArrayList<File>();
        for (Movie movie : this.movieList.getMovies()) {
            existing.add(new File(movie.getPath()));
        }
        try {
            TmmTask task;
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            ArrayList<Path> imageFiles = new ArrayList<Path>();
            for (String ds : this.dataSources) {
                this.setTaskName(BUNDLE.getString("update.datasource") + " '" + ds + "'");
                this.publishState();
                ArrayList<File> newMovieInDsRoot = new ArrayList<File>();
                ArrayList<File> existingMovieInDsRoot = new ArrayList<File>();
                if (MovieModuleManager.MOVIE_SETTINGS.isDetectMovieMultiDir()) {
                    this.initThreadPool(1, "update");
                } else {
                    this.initThreadPool(3, "update");
                }
                File[] dirs = new File(ds).listFiles();
                if (dirs == null || dirs.length == 0) {
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                    continue;
                }
                boolean parseDsRoot = false;
                for (File file : dirs) {
                    if (this.cancel) continue;
                    if (file.isDirectory()) {
                        String directoryName = file.getName();
                        if (skipFolders.contains(directoryName.toUpperCase(Locale.ROOT)) || directoryName.matches(skipFoldersRegex) || MovieModuleManager.MOVIE_SETTINGS.getMovieSkipFolders().contains(file.getAbsolutePath())) {
                            LOGGER.info("ignoring directory " + directoryName);
                            continue;
                        }
                        if (existing.contains(file)) {
                            existingMovieInDsRoot.add(file);
                            continue;
                        }
                        newMovieInDsRoot.add(file);
                        continue;
                    }
                    if (!Globals.settings.getVideoFileType().contains("." + FilenameUtils.getExtension((String)file.getName()))) continue;
                    if (MovieModuleManager.MOVIE_SETTINGS.isDetectMovieMultiDir()) {
                        parseDsRoot = true;
                        continue;
                    }
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.movieinroot", new String[]{file.getName()}));
                }
                for (File subdir : newMovieInDsRoot) {
                    this.submitTask(new FindMovieTask(subdir, ds));
                }
                for (File subdir : existingMovieInDsRoot) {
                    this.submitTask(new FindMovieTask(subdir, ds));
                }
                this.waitForCompletionOrCancel();
                if (parseDsRoot) {
                    LOGGER.debug("parsing datasource root for movies...");
                    this.initThreadPool(1, "update");
                    this.submitTask(new FindMovieTask(new File(ds), ds));
                    this.waitForCompletionOrCancel();
                }
                if (this.cancel) break;
                this.cleanup(ds);
                if (this.cancel) break;
                this.gatherMediainfo(ds);
                this.waitForCompletionOrCancel();
                if (this.cancel) break;
                if (!MovieModuleManager.MOVIE_SETTINGS.isBuildImageCacheOnImport()) continue;
                for (Movie movie : this.movieList.getMovies()) {
                    if (!new File(ds).equals(new File(movie.getDataSource()))) continue;
                    imageFiles.addAll(movie.getImagesToCache());
                }
            }
            if (imageFiles.size() > 0) {
                task = new ImageCacheTask(imageFiles);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            if (MovieModuleManager.MOVIE_SETTINGS.getSyncTrakt()) {
                task = new SyncTraktTvTask(true, true, false, false);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            stopWatch.stop();
            LOGGER.info("Done updating datasource :) - took " + stopWatch);
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "message.update.threadcrashed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMultiMovieDir(List<File> files, File parentDir, String datasource) {
        if (files == null || files.isEmpty()) {
            return;
        }
        File[] contents = parentDir.listFiles();
        if (contents == null) {
            return;
        }
        ArrayList<File> completeDirContents = new ArrayList<File>(Arrays.asList(contents));
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                return file2.getName().length() - file1.getName().length();
            }
        });
        for (File file : files) {
            Movie movie = null;
            MediaFile mf = new MediaFile(file);
            String basename = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mf.getFilename()));
            block9: for (Movie m : this.movieList.getMoviesByPath(mf.getFile().getParentFile())) {
                if (m.getMediaFiles(MediaFileType.VIDEO).contains(mf)) {
                    LOGGER.debug("found movie '" + m.getTitle() + "' from MediaFile " + file);
                    movie = m;
                    break;
                }
                for (MediaFile mfile : m.getMediaFiles(MediaFileType.VIDEO)) {
                    String[] mfTY;
                    String[] mfileTY = ParserUtils.detectCleanMovienameAndYear(FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mfile.getFilename())));
                    if (!mfileTY[0].equals((mfTY = ParserUtils.detectCleanMovienameAndYear(FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mf.getFilename()))))[0]) || !mfileTY[1].equals(mfTY[1])) continue;
                    LOGGER.debug("found possible movie '" + m.getTitle() + "' from filename " + file);
                    movie = m;
                    continue block9;
                }
            }
            if (movie == null) {
                File nfoFile = new File(parentDir, basename + ".nfo");
                if (completeDirContents.contains(nfoFile)) {
                    MediaFile nfo = new MediaFile(nfoFile, MediaFileType.NFO);
                    LOGGER.debug("found NFO '" + nfo.getFile() + "' - try to parse");
                    switch (MovieModuleManager.MOVIE_SETTINGS.getMovieConnector()) {
                        case XBMC: {
                            movie = MovieToXbmcNfoConnector.getData(nfo.getFileAsPath());
                            break;
                        }
                        case KODI: {
                            movie = MovieToKodiNfoConnector.getData(nfo.getFileAsPath());
                            break;
                        }
                        case MP: {
                            movie = MovieToMpNfoConnector.getData(nfo.getFileAsPath());
                        }
                    }
                    if (movie != null) {
                        LOGGER.debug("NFO valid - add it");
                        movie.addToMediaFiles(nfo);
                    }
                }
                if (movie == null) {
                    Matcher matcher;
                    LOGGER.debug("Create new movie from file: " + file);
                    movie = new Movie();
                    String[] ty = ParserUtils.detectCleanMovienameAndYear(basename);
                    movie.setTitle(ty[0]);
                    if (!ty[1].isEmpty()) {
                        movie.setYear(ty[1]);
                    }
                    if ((matcher = video3DPattern.matcher(basename)).find()) {
                        movie.setVideoIn3D(true);
                    }
                    movie.setDateAdded(new Date());
                }
                movie.setDataSource(datasource);
                movie.setNewlyAdded(true);
                movie.setPath(mf.getPath());
                this.movieList.addMovie(movie);
            }
            if (!Utils.isValidImdbId(movie.getImdbId())) {
                movie.setImdbId(ParserUtils.detectImdbId(mf.getFile().getAbsolutePath()));
            }
            if (movie.getMediaSource() == MediaSource.UNKNOWN) {
                movie.setMediaSource(MediaSource.parseMediaSource(mf.getFile().getAbsolutePath()));
            }
            LOGGER.debug("parsing video file " + mf.getFilename());
            movie.addToMediaFiles(mf);
            movie.setDateAddedFromMediaFile(mf);
            movie.setMultiMovieDir(true);
            ArrayList<MediaFile> existingMediaFiles = new ArrayList<MediaFile>(movie.getMediaFiles());
            ArrayList<MediaFile> foundMediaFiles = new ArrayList<MediaFile>();
            for (int i = completeDirContents.size() - 1; i >= 0; --i) {
                File fileInDir = (File)completeDirContents.get(i);
                if (!fileInDir.getName().startsWith(basename)) continue;
                MediaFile mediaFile = new MediaFile(fileInDir);
                if (!existingMediaFiles.contains(mediaFile)) {
                    HashSet<File> hashSet = this.filesFound;
                    synchronized (hashSet) {
                        this.filesFound.add(fileInDir);
                    }
                    foundMediaFiles.add(mediaFile);
                }
                completeDirContents.remove(i);
            }
            this.addMediafilesToMovie(movie, foundMediaFiles);
            if (movie.getMovieSet() != null) {
                LOGGER.debug("movie is part of a movieset");
                movie.getMovieSet().insertMovie(movie);
                this.movieList.sortMoviesInMovieSet(movie.getMovieSet());
                movie.getMovieSet().saveToDb();
            }
            movie.saveToDb();
        }
        for (Movie m : this.movieList.getMoviesByPath(parentDir)) {
            m.reEvaluateStacking();
            m.saveToDb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMovieDirectory(File movieDir, String dataSource) {
        try {
            File[] fileArray = movieDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.getName().equals(".tmmignore") || file.getName().equals("tmmignore")) {
                        return true;
                    }
                    if (file.isDirectory() || file.getName().startsWith("._")) {
                        return false;
                    }
                    return new MediaFile(file).getType().equals((Object)MediaFileType.VIDEO);
                }
            });
            if (fileArray == null) {
                LOGGER.error("Whops. Cannot access directory: " + movieDir.getName());
                return;
            }
            ArrayList<File> files = new ArrayList<File>(Arrays.asList(fileArray));
            if (files.contains(new File(movieDir, ".tmmignore")) || files.contains(new File(movieDir, "tmmignore"))) {
                return;
            }
            HashSet<File> hashSet = this.filesFound;
            synchronized (hashSet) {
                this.filesFound.add(movieDir);
            }
            HashSet<String> h = new HashSet<String>();
            LOGGER.debug("Checking for multi-movie dir; parsing all video files in " + movieDir);
            for (File file : files) {
                MediaFile mf = new MediaFile(file);
                if (mf.isDiscFile()) continue;
                String[] ty = ParserUtils.detectCleanMovienameAndYear(FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(file.getName())));
                h.add(ty[0] + ty[1]);
            }
            if (h.size() > 1 || movieDir.equals(new File(dataSource))) {
                LOGGER.debug("WOOT - we have a multi movie directory: " + movieDir);
                if (MovieModuleManager.MOVIE_SETTINGS.isDetectMovieMultiDir()) {
                    this.parseMultiMovieDir(files, movieDir, dataSource);
                } else {
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.movieinroot", new String[]{movieDir.getName()}));
                }
            } else {
                LOGGER.debug("PAH - normal movie directory: " + movieDir);
                Movie movie = this.movieList.getMovieByPath(movieDir);
                ArrayList<MediaFile> mfs = this.getAllMediaFilesRecursive(movieDir);
                if (movie == null) {
                    Matcher matcher;
                    LOGGER.info("Movie not found; parsing directory" + movieDir);
                    movie = new Movie();
                    String bdinfoTitle = "";
                    String videoName = "";
                    for (MediaFile mf : mfs) {
                        if (mf.getType().equals((Object)MediaFileType.NFO)) {
                            LOGGER.debug("parsing NFO " + mf.getFilename());
                            Movie nfo = null;
                            switch (MovieModuleManager.MOVIE_SETTINGS.getMovieConnector()) {
                                case XBMC: {
                                    nfo = MovieToXbmcNfoConnector.getData(mf.getFileAsPath());
                                    break;
                                }
                                case KODI: {
                                    nfo = MovieToKodiNfoConnector.getData(mf.getFileAsPath());
                                    break;
                                }
                                case MP: {
                                    nfo = MovieToMpNfoConnector.getData(mf.getFileAsPath());
                                }
                            }
                            if (nfo != null) {
                                movie = nfo;
                                continue;
                            }
                            try {
                                String imdb = FileUtils.readFileToString((File)mf.getFile());
                                if ((imdb = ParserUtils.detectImdbId(imdb)).isEmpty()) continue;
                                LOGGER.debug("Found IMDB id: " + imdb);
                                movie.setImdbId(imdb);
                            }
                            catch (IOException e) {
                                LOGGER.warn("couldn't read NFO " + mf.getFilename());
                            }
                            continue;
                        }
                        if (mf.getType().equals((Object)MediaFileType.TEXT)) {
                            try {
                                String imdb;
                                String txtFile = FileUtils.readFileToString((File)mf.getFile());
                                String bdinfo = StrgUtils.substr((String)txtFile, (String)".*Disc Title:\\s+(.*?)[\\n\\r]");
                                if (!bdinfo.isEmpty()) {
                                    LOGGER.debug("Found Disc Title in BDInfo.txt: " + bdinfo);
                                    bdinfoTitle = bdinfo;
                                }
                                if ((imdb = ParserUtils.detectImdbId(txtFile)).isEmpty()) continue;
                                LOGGER.debug("Found IMDB id: " + imdb);
                                movie.setImdbId(imdb);
                            }
                            catch (Exception e) {
                                LOGGER.warn("couldn't read TXT " + mf.getFilename());
                            }
                            continue;
                        }
                        if (!mf.getType().equals((Object)MediaFileType.VIDEO)) continue;
                        videoName = mf.getBasename();
                    }
                    if (movie.getTitle().isEmpty()) {
                        String[] video = ParserUtils.detectCleanMovienameAndYear(movieDir.getName());
                        movie.setTitle(video[0]);
                        if (!video[1].isEmpty()) {
                            movie.setYear(video[1]);
                        }
                    }
                    if ((matcher = video3DPattern.matcher(movieDir.getName())).find()) {
                        movie.setVideoIn3D(true);
                    }
                    movie.setPath(movieDir.getPath());
                    movie.setDataSource(dataSource);
                    movie.setDateAdded(new Date());
                    movie.setNewlyAdded(true);
                    movie.findActorImages();
                    LOGGER.debug("store movie into DB " + movie.getTitle());
                    this.movieList.addMovie(movie);
                    if (movie.getMovieSet() != null) {
                        LOGGER.debug("movie is part of a movieset");
                        movie.getMovieSet().insertMovie(movie);
                        this.movieList.sortMoviesInMovieSet(movie.getMovieSet());
                        movie.getMovieSet().saveToDb();
                    }
                }
                this.addMediafilesToMovie(movie, mfs);
                if (movie.getArtworkFilename(MediaFileType.POSTER).isEmpty()) {
                    for (MediaFile mf : mfs) {
                        String vfilename;
                        if (!mf.getType().equals((Object)MediaFileType.GRAPHIC)) continue;
                        LOGGER.debug("parsing unknown graphic " + mf.getFilename());
                        List<MediaFile> vid = movie.getMediaFiles(MediaFileType.VIDEO);
                        if (vid == null || vid.isEmpty() || !FilenameUtils.getBaseName((String)(vfilename = vid.get(0).getFilename())).equals(FilenameUtils.getBaseName((String)mf.getFilename())) && !FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(vfilename)).trim().equals(FilenameUtils.getBaseName((String)mf.getFilename())) && !movie.getTitle().equals(FilenameUtils.getBaseName((String)mf.getFilename()))) continue;
                        mf.setType(MediaFileType.POSTER);
                        movie.addToMediaFiles(mf);
                    }
                }
                movie.reEvaluateStacking();
                movie.saveToDb();
            }
        }
        catch (NullPointerException e) {
            LOGGER.error("NPE:", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, movieDir.getPath(), "message.update.errormoviedir"));
        }
        catch (Exception e) {
            LOGGER.error("error update Datasources", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movieDir.getPath(), "message.update.errormoviedir", new String[]{":", e.getLocalizedMessage()}));
        }
    }

    private ArrayList<File> getRootMovieDirs(File directory, int level) {
        ArrayList<File> ar = new ArrayList<File>();
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<File> dirs = new ArrayList<File>();
        File[] list = directory.listFiles();
        if (list == null) {
            LOGGER.error("Whops. Cannot access directory: " + directory);
            return ar;
        }
        for (File file : list) {
            if (file.isFile()) {
                files.add(file);
                continue;
            }
            if (skipFolders.contains(file.getName().toUpperCase(Locale.ROOT)) || file.getName().matches(skipFoldersRegex) || MovieModuleManager.MOVIE_SETTINGS.getMovieSkipFolders().contains(file.getAbsolutePath())) continue;
            dirs.add(file);
        }
        list = null;
        for (File f : files) {
            boolean disc = false;
            MediaFile mf = new MediaFile(f);
            if (!mf.getType().equals((Object)MediaFileType.VIDEO)) continue;
            File moviedir = f.getParentFile();
            while (moviedir.getPath().toUpperCase(Locale.ROOT).contains("BDMV") || moviedir.getPath().toUpperCase(Locale.ROOT).contains("VIDEO_TS")) {
                disc = true;
                moviedir = moviedir.getParentFile();
            }
            if (disc) {
                ar.add(moviedir);
                continue;
            }
            if (dirs.isEmpty() && level > 1 && Utils.cleanFolderStackingMarkers(moviedir.getName()).isEmpty()) {
                moviedir = moviedir.getParentFile();
                ar.add(moviedir);
                continue;
            }
            ar.add(moviedir);
        }
        for (File dir : dirs) {
            ar.addAll(this.getRootMovieDirs(dir, level + 1));
        }
        return ar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<MediaFile> getAllMediaFilesRecursive(File dir) {
        ArrayList<MediaFile> mv = new ArrayList<MediaFile>();
        File[] list = dir.listFiles();
        if (list == null) {
            LOGGER.error("Whops. Cannot access directory: " + dir.getName());
            return mv;
        }
        for (File file : list) {
            if (file.isFile()) {
                if (file.getName().startsWith("._")) continue;
                mv.add(new MediaFile(file));
                HashSet<File> hashSet = this.filesFound;
                synchronized (hashSet) {
                    this.filesFound.add(file);
                    continue;
                }
            }
            if (skipFolders.contains(file.getName().toUpperCase(Locale.ROOT)) || file.getName().matches(skipFoldersRegex) || MovieModuleManager.MOVIE_SETTINGS.getMovieSkipFolders().contains(file.getAbsolutePath())) continue;
            mv.addAll(this.getAllMediaFilesRecursive(file));
        }
        return mv;
    }

    private void addMediafilesToMovie(Movie movie, List<MediaFile> mediaFiles) {
        ArrayList<MediaFile> current = new ArrayList<MediaFile>(movie.getMediaFiles());
        block8: for (MediaFile mf : mediaFiles) {
            if (current.contains(mf)) continue;
            if (mf.getPath().toUpperCase(Locale.ROOT).contains("BDMV") || mf.getPath().toUpperCase(Locale.ROOT).contains("VIDEO_TS") || mf.isDiscFile()) {
                movie.setDisc(true);
                if (movie.getMediaSource() == MediaSource.UNKNOWN) {
                    movie.setMediaSource(MediaSource.parseMediaSource(mf.getPath()));
                }
            }
            if (!Utils.isValidImdbId(movie.getImdbId())) {
                movie.setImdbId(ParserUtils.detectImdbId(mf.getFile().getAbsolutePath()));
            }
            LOGGER.debug("parsing " + mf.getType().name() + " " + mf.getFilename());
            switch (mf.getType()) {
                case VIDEO: {
                    movie.addToMediaFiles(mf);
                    movie.setDateAddedFromMediaFile(mf);
                    if (movie.getMediaSource() != MediaSource.UNKNOWN) break;
                    movie.setMediaSource(MediaSource.parseMediaSource(mf.getFile().getAbsolutePath()));
                    break;
                }
                case TRAILER: {
                    mf.gatherMediaInformation();
                    MovieTrailer mt = new MovieTrailer();
                    mt.setName(mf.getFilename());
                    mt.setProvider("downloaded");
                    mt.setQuality(mf.getVideoFormat());
                    mt.setInNfo(false);
                    mt.setUrl(mf.getFile().toURI().toString());
                    movie.addTrailer(mt);
                    movie.addToMediaFiles(mf);
                    break;
                }
                case SUBTITLE: {
                    if (mf.isPacked()) break;
                    movie.setSubtitles(true);
                    movie.addToMediaFiles(mf);
                    break;
                }
                case FANART: {
                    if (mf.getPath().toLowerCase(Locale.ROOT).contains("extrafanart")) {
                        LOGGER.warn("problem: detected media file type FANART in extrafanart folder: " + mf.getPath());
                        continue block8;
                    }
                    movie.addToMediaFiles(mf);
                    break;
                }
                case THUMB: {
                    if (mf.getPath().toLowerCase(Locale.ROOT).contains("extrathumbs")) {
                        LOGGER.warn("problem: detected media file type THUMB in extrathumbs folder: " + mf.getPath());
                        continue block8;
                    }
                    movie.addToMediaFiles(mf);
                    break;
                }
                case VIDEO_EXTRA: 
                case SAMPLE: 
                case NFO: 
                case TEXT: 
                case POSTER: 
                case SEASON_POSTER: 
                case EXTRAFANART: 
                case EXTRATHUMB: 
                case AUDIO: 
                case DISCART: 
                case BANNER: 
                case CLEARART: 
                case LOGO: 
                case CLEARLOGO: {
                    movie.addToMediaFiles(mf);
                    break;
                }
                default: {
                    LOGGER.debug("NOT adding unknown media file type: " + mf.getFilename());
                }
            }
            if (mf.getType() == MediaFileType.GRAPHIC || mf.getType() == MediaFileType.UNKNOWN || mf.getType() == MediaFileType.NFO || movie.getMediaFiles().contains(mf)) continue;
            LOGGER.error("Movie not added mf: " + mf.getFile().getPath());
        }
    }

    private void cleanup(String datasource) {
        this.setTaskName(BUNDLE.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        this.setWorkUnits(0);
        this.publishState();
        LOGGER.info("removing orphaned movies/files...");
        ArrayList<Movie> moviesToRemove = new ArrayList<Movie>();
        for (int i = this.movieList.getMovies().size() - 1; i >= 0 && !this.cancel; --i) {
            Movie movie = this.movieList.getMovies().get(i);
            if (!new File(datasource).equals(new File(movie.getDataSource()))) continue;
            File movieDir = new File(movie.getPath());
            if (!this.filesFound.contains(movieDir)) {
                if (!movieDir.exists()) {
                    LOGGER.debug("movie directory '" + movieDir + "' not found, removing...");
                    moviesToRemove.add(movie);
                    continue;
                }
                LOGGER.warn("dir " + movie.getPath() + " not in hashset, but on hdd!");
                continue;
            }
            if (movie.isNewlyAdded()) continue;
            ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>(movie.getMediaFiles());
            for (MediaFile mf : mediaFiles) {
                if (this.filesFound.contains(mf.getFile())) continue;
                if (!mf.exists()) {
                    LOGGER.debug("removing orphaned file: " + mf.getPath() + File.separator + mf.getFilename());
                    movie.removeFromMediaFiles(mf);
                    continue;
                }
                LOGGER.warn("file " + mf.getFile().getAbsolutePath() + " not in hashset, but on hdd!");
            }
            movie.saveToDb();
        }
        this.movieList.removeMovies(moviesToRemove);
    }

    private void gatherMediainfo(String datasource) {
        this.setTaskName(BUNDLE.getString("update.mediainfo"));
        this.publishState();
        this.initThreadPool(1, "mediainfo");
        LOGGER.info("getting Mediainfo...");
        for (int i = this.movieList.getMovies().size() - 1; i >= 0 && !this.cancel; --i) {
            Movie movie = this.movieList.getMovies().get(i);
            if (!new File(datasource).equals(new File(movie.getDataSource()))) continue;
            ArrayList<MediaFile> ungatheredMediaFiles = new ArrayList<MediaFile>();
            for (MediaFile mf : new ArrayList<MediaFile>(movie.getMediaFiles())) {
                if (!StringUtils.isBlank((CharSequence)mf.getContainerFormat())) continue;
                ungatheredMediaFiles.add(mf);
            }
            if (ungatheredMediaFiles.size() <= 0) continue;
            this.submitTask(new MediaFileInformationFetcherTask(ungatheredMediaFiles, (MediaEntity)movie, false));
        }
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private class FindMovieTask
    implements Callable<Object> {
        private File subdir = null;
        private String datasource = "";

        public FindMovieTask(File subdir, String datasource) {
            this.subdir = subdir;
            this.datasource = datasource;
        }

        @Override
        public String call() throws Exception {
            if (this.subdir.equals(new File(this.datasource))) {
                LOGGER.debug("Parsing dataSource root folder: " + this.subdir);
                MovieUpdateDatasourceTask.this.parseMovieDirectory(this.subdir, this.datasource);
            } else {
                ArrayList mov = MovieUpdateDatasourceTask.this.getRootMovieDirs(this.subdir, 1);
                HashSet h = new HashSet(mov);
                mov.clear();
                mov.addAll(h);
                for (File movieDir : mov) {
                    MovieUpdateDatasourceTask.this.parseMovieDirectory(movieDir, this.datasource);
                }
            }
            return this.subdir.getName();
        }
    }
}

