/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieSubtitleDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.SubtitleSearchOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.mediaprovider.IMediaSubtitleProvider;
import org.tinymediamanager.ui.UTF8Control;

public class MovieSubtitleSearchAndDownloadTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSubtitleSearchAndDownloadTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final List<Movie> movies;
    private final List<MediaScraper> subtitleScrapers;
    private final MediaLanguages language;

    public MovieSubtitleSearchAndDownloadTask(List<Movie> movies, List<MediaScraper> subtitleScrapers, MediaLanguages language) {
        super(BUNDLE.getString("movie.download.subtitles"));
        this.movies = movies;
        this.subtitleScrapers = subtitleScrapers;
        this.language = language;
    }

    @Override
    protected void doInBackground() {
        this.initThreadPool(3, "searchAndDownloadSubtitles");
        this.start();
        for (int i = 0; i < this.movies.size(); ++i) {
            Movie movie = this.movies.get(i);
            this.submitTask(new Worker(movie));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done searching and downloading subtitles");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private class Worker
    implements Runnable {
        private Movie movie;

        public Worker(Movie movie) {
            this.movie = movie;
        }

        @Override
        public void run() {
            try {
                for (MediaScraper scraper : MovieSubtitleSearchAndDownloadTask.this.subtitleScrapers) {
                    try {
                        MediaFile mf = this.movie.getMediaFiles(MediaFileType.VIDEO).get(0);
                        IMediaSubtitleProvider subtitleProvider = (IMediaSubtitleProvider)scraper.getMediaProvider();
                        SubtitleSearchOptions options = new SubtitleSearchOptions(mf.getFileAsPath().toFile());
                        options.setLanguage(LocaleUtils.toLocale((String)MovieSubtitleSearchAndDownloadTask.this.language.name()));
                        List searchResults = subtitleProvider.search(options);
                        if (searchResults.isEmpty()) continue;
                        Collections.sort(searchResults);
                        Collections.reverse(searchResults);
                        SubtitleSearchResult firstResult = (SubtitleSearchResult)searchResults.get(0);
                        if (firstResult.getScore() < 1.0f || StringUtils.isBlank((CharSequence)firstResult.getUrl())) continue;
                        String lang = LanguageStyle.getLanguageCodeForStyle(MovieSubtitleSearchAndDownloadTask.this.language.name(), MovieModuleManager.MOVIE_SETTINGS.getMovieRenamerLanguageStyle());
                        if (StringUtils.isBlank((CharSequence)lang)) {
                            lang = MovieSubtitleSearchAndDownloadTask.this.language.name();
                        }
                        TmmTaskManager.getInstance().addDownloadTask(new MovieSubtitleDownloadTask(firstResult.getUrl(), mf.getFileAsPath(), lang, this.movie));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error at subtitle searching: " + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"SubtitleDownloader", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }
}

