/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.http.Url;

public class MovieExtraImageFetcher
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieExtraImageFetcher.class);
    private Movie movie;
    private MediaFileType type;

    public MovieExtraImageFetcher(Movie movie, MediaFileType type) {
        this.movie = movie;
        this.type = type;
    }

    @Override
    public void run() {
        try {
            String base = "";
            if (this.movie.isMultiMovieDir()) {
                base = this.movie.getVideoBasenameWithoutStacking();
            }
            switch (this.type) {
                case LOGO: 
                case CLEARLOGO: 
                case BANNER: 
                case CLEARART: 
                case THUMB: 
                case DISCART: {
                    this.downloadArtwork(this.type, base);
                    break;
                }
            }
            if (!this.movie.isMultiMovieDir()) {
                switch (this.type) {
                    case EXTRATHUMB: {
                        this.downloadExtraThumbs();
                        break;
                    }
                    case EXTRAFANART: {
                        this.downloadExtraFanart();
                        break;
                    }
                }
            } else {
                LOGGER.info("Movie '" + this.movie.getTitle() + "' is within a multi-movie-directory - skip downloading of " + this.type.name() + " images.");
            }
            if (Thread.interrupted()) {
                return;
            }
            this.movie.callbackForWrittenArtwork(MediaArtwork.MediaArtworkType.ALL);
            this.movie.saveToDb();
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed: ", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "message.extraimage.threadcrashed"));
        }
    }

    private void downloadArtwork(MediaFileType type, String basename) {
        block12: {
            String artworkUrl = this.movie.getArtworkUrl(type);
            if (StringUtils.isBlank((CharSequence)artworkUrl)) {
                return;
            }
            String filename = basename;
            if (!filename.isEmpty()) {
                filename = filename + "-";
            }
            try {
                String oldFilename = this.movie.getArtworkFilename(type);
                filename = type == MediaFileType.DISCART ? filename + "disc." + FilenameUtils.getExtension((String)artworkUrl) : filename + type.name().toLowerCase(Locale.ROOT) + "." + FilenameUtils.getExtension((String)artworkUrl);
                this.movie.removeAllMediaFiles(type);
                LOGGER.debug("writing " + (Object)((Object)type) + " " + filename);
                Url url1 = new Url(artworkUrl);
                Path tempFile = this.movie.getPathNIO().resolve(filename + ".part");
                FileOutputStream outputStream = new FileOutputStream(tempFile.toFile());
                InputStream is = url1.getInputStream();
                IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                outputStream.flush();
                try {
                    outputStream.getFD().sync();
                    Thread.sleep(150L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                outputStream.close();
                is.close();
                if (Thread.interrupted()) {
                    return;
                }
                if (!Files.exists(tempFile, new LinkOption[0]) || Files.size(tempFile) == 0L) {
                    throw new Exception("0byte file downloaded: " + filename);
                }
                if (StringUtils.isNotBlank((CharSequence)oldFilename)) {
                    Path oldFile = this.movie.getPathNIO().resolve(oldFilename);
                    Utils.deleteFileSafely(oldFile);
                }
                Path destinationFile = this.movie.getPathNIO().resolve(filename);
                Utils.deleteFileSafely(destinationFile);
                if (!Utils.moveFileSafe(tempFile, destinationFile)) {
                    throw new Exception("renaming temp file failed: " + filename);
                }
                this.movie.setArtwork(destinationFile, type);
                this.movie.callbackForWrittenArtwork(MediaFileType.getMediaArtworkType(type));
                this.movie.saveToDb();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    LOGGER.warn("interrupted image download");
                } else {
                    LOGGER.error("fetch image: " + e.getMessage());
                }
                Path tempFile = this.movie.getPathNIO().resolve(filename + ".part");
                if (!Files.exists(tempFile, new LinkOption[0])) break block12;
                Utils.deleteFileSafely(tempFile);
            }
        }
    }

    private void downloadExtraFanart() {
        List<String> fanarts = this.movie.getExtraFanarts();
        if (fanarts.size() == 0) {
            return;
        }
        try {
            Path folder = this.movie.getPathNIO().resolve("extrafanart");
            if (Files.isDirectory(folder, new LinkOption[0])) {
                Utils.deleteDirectoryRecursive(folder);
                this.movie.removeAllMediaFiles(MediaFileType.EXTRAFANART);
            }
            Files.createDirectory(folder, new FileAttribute[0]);
            for (int i = 0; i < fanarts.size(); ++i) {
                String urlAsString = fanarts.get(i);
                String providedFiletype = FilenameUtils.getExtension((String)urlAsString);
                Url url = new Url(urlAsString);
                Path file = folder.resolve("fanart" + (i + 1) + "." + providedFiletype);
                FileOutputStream outputStream = new FileOutputStream(file.toFile());
                InputStream is = url.getInputStream();
                IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                outputStream.flush();
                try {
                    outputStream.getFD().sync();
                    Thread.sleep(150L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                outputStream.close();
                is.close();
                MediaFile mf = new MediaFile(file, MediaFileType.EXTRAFANART);
                mf.gatherMediaInformation();
                this.movie.addToMediaFiles(mf);
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("interrupted download extrafanarts");
        }
        catch (IOException e) {
            LOGGER.warn("download extrafanarts", (Throwable)e);
        }
    }

    private void downloadExtraThumbs() {
        List<String> thumbs = this.movie.getExtraThumbs();
        if (thumbs.size() == 0) {
            return;
        }
        try {
            Path folder = this.movie.getPathNIO().resolve("extrathumbs");
            if (Files.isDirectory(folder, new LinkOption[0])) {
                Utils.deleteDirectoryRecursive(folder);
                this.movie.removeAllMediaFiles(MediaFileType.EXTRATHUMB);
            }
            Files.createDirectory(folder, new FileAttribute[0]);
            for (int i = 0; i < thumbs.size(); ++i) {
                Path file;
                InputStream is;
                FileOutputStream outputStream;
                block11: {
                    String url = thumbs.get(i);
                    String providedFiletype = FilenameUtils.getExtension((String)url);
                    outputStream = null;
                    is = null;
                    file = null;
                    if (MovieModuleManager.MOVIE_SETTINGS.isImageExtraThumbsResize() && MovieModuleManager.MOVIE_SETTINGS.getImageExtraThumbsSize() > 0) {
                        file = folder.resolve("thumb" + (i + 1) + ".jpg");
                        outputStream = new FileOutputStream(file.toFile());
                        try {
                            is = ImageCache.scaleImage(url, MovieModuleManager.MOVIE_SETTINGS.getImageExtraThumbsSize());
                            break block11;
                        }
                        catch (Exception e) {
                            LOGGER.warn("problem with rescaling: " + e.getMessage());
                            continue;
                        }
                    }
                    file = folder.resolve("thumb" + (i + 1) + "." + providedFiletype);
                    outputStream = new FileOutputStream(file.toFile());
                    Url url1 = new Url(url);
                    is = url1.getInputStream();
                }
                IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                outputStream.flush();
                try {
                    outputStream.getFD().sync();
                }
                catch (Exception e) {
                    // empty catch block
                }
                outputStream.close();
                is.close();
                MediaFile mf = new MediaFile(file, MediaFileType.EXTRATHUMB);
                mf.gatherMediaInformation();
                this.movie.addToMediaFiles(mf);
            }
        }
        catch (IOException e) {
            LOGGER.warn("download extrathumbs", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }
}

