/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.entities;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieMediaFileComparator;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieNfoNaming;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieTrailerQuality;
import org.tinymediamanager.core.movie.MovieTrailerSources;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.movie.connector.MovieToKodiNfoConnector;
import org.tinymediamanager.core.movie.connector.MovieToMpNfoConnector;
import org.tinymediamanager.core.movie.connector.MovieToXbmcNfoConnector;
import org.tinymediamanager.core.movie.entities.MovieActor;
import org.tinymediamanager.core.movie.entities.MovieProducer;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.core.movie.tasks.MovieActorImageFetcher;
import org.tinymediamanager.core.movie.tasks.MovieTrailerDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.IMovieSetMetadataProvider;
import org.tinymediamanager.scraper.util.StrgUtils;

public class Movie
extends MediaEntity {
    @XmlTransient
    private static final Logger LOGGER = LoggerFactory.getLogger(Movie.class);
    private static final Comparator<MediaFile> MEDIA_FILE_COMPARATOR = new MovieMediaFileComparator();
    private static final Comparator<MovieTrailer> TRAILER_QUALITY_COMPARATOR = new MovieTrailer.QualityComparator();
    @JsonProperty
    private String sortTitle = "";
    @JsonProperty
    private String tagline = "";
    @JsonProperty
    private int runtime = 0;
    @JsonProperty
    private String director = "";
    @JsonProperty
    private String writer = "";
    @JsonProperty
    private String dataSource = "";
    @JsonProperty
    private boolean watched = false;
    @JsonProperty
    private boolean isDisc = false;
    @JsonProperty
    private String spokenLanguages = "";
    @JsonProperty
    private boolean subtitles = false;
    @JsonProperty
    private String country = "";
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private Date releaseDate = null;
    @JsonProperty
    private boolean multiMovieDir = false;
    @JsonProperty
    private int top250 = 0;
    @JsonProperty
    private MediaSource mediaSource = MediaSource.UNKNOWN;
    @JsonProperty
    private boolean videoIn3D = false;
    @JsonProperty
    private Certification certification = Certification.NOT_RATED;
    @JsonProperty
    private UUID movieSetId;
    @JsonProperty
    private MovieEdition edition = MovieEdition.NONE;
    @JsonProperty
    private boolean stacked = false;
    @JsonProperty
    private boolean offline = false;
    @JsonProperty
    private List<String> genres = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private List<String> tags = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private List<String> extraThumbs = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private List<String> extraFanarts = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private List<MovieActor> actors = new CopyOnWriteArrayList<MovieActor>();
    @JsonProperty
    private List<MovieProducer> producers = new CopyOnWriteArrayList<MovieProducer>();
    @JsonProperty
    private List<MovieTrailer> trailer = new CopyOnWriteArrayList<MovieTrailer>();
    private MovieSet movieSet;
    private String titleSortable = "";
    private Date lastWatched = null;
    private List<MediaGenres> genresForAccess = new CopyOnWriteArrayList<MediaGenres>();

    public void merge(Movie other) {
        if (other == null) {
            return;
        }
        super.merge(other);
        this.sortTitle = StringUtils.isEmpty((CharSequence)this.sortTitle) ? other.getSortTitle() : this.sortTitle;
        this.tagline = StringUtils.isEmpty((CharSequence)this.tagline) ? other.getTagline() : this.tagline;
        this.director = StringUtils.isEmpty((CharSequence)this.director) ? other.getDirector() : this.director;
        this.writer = StringUtils.isEmpty((CharSequence)this.writer) ? other.getWriter() : this.writer;
        this.spokenLanguages = StringUtils.isEmpty((CharSequence)this.spokenLanguages) ? other.getSpokenLanguages() : this.spokenLanguages;
        this.country = StringUtils.isEmpty((CharSequence)this.country) ? other.getCountry() : this.country;
        this.titleSortable = StringUtils.isEmpty((CharSequence)this.titleSortable) ? other.getTitleSortable() : this.titleSortable;
        this.runtime = this.runtime == 0 ? other.getRuntime() : this.runtime;
        this.top250 = this.top250 == 0 ? other.getTop250() : this.top250;
        this.releaseDate = this.releaseDate == null ? other.getReleaseDate() : this.releaseDate;
        this.movieSet = this.movieSet == null ? other.getMovieSet() : this.movieSet;
        this.mediaSource = this.mediaSource == MediaSource.UNKNOWN ? other.getMediaSource() : this.mediaSource;
        this.certification = this.certification == Certification.NOT_RATED ? other.getCertification() : this.certification;
        this.edition = this.edition == MovieEdition.NONE ? other.getEdition() : this.edition;
        for (MediaGenres genre : other.getGenres()) {
            this.addGenre(genre);
        }
        for (MovieActor actor : other.getActors()) {
            if (this.actors.contains(actor)) continue;
            this.actors.add(actor);
        }
        for (MovieProducer prod : other.getProducers()) {
            if (this.producers.contains(prod)) continue;
            this.producers.add(prod);
        }
        for (MovieTrailer trail : other.getTrailer()) {
            if (this.trailer.contains(trail)) continue;
            this.trailer.add(trail);
        }
        for (String key : other.getTags()) {
            if (this.tags.contains(key)) continue;
            this.tags.add(key);
        }
        for (String key : other.getExtraThumbs()) {
            if (this.extraThumbs.contains(key)) continue;
            this.extraThumbs.add(key);
        }
        for (String key : other.getExtraFanarts()) {
            if (this.extraFanarts.contains(key)) continue;
            this.extraFanarts.add(key);
        }
    }

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return MEDIA_FILE_COMPARATOR;
    }

    @Override
    public boolean isScraped() {
        return this.scraped || this.getHasMetadata() != false;
    }

    public String getSortTitle() {
        return this.sortTitle;
    }

    public void setSortTitle(String newValue) {
        String oldValue = this.sortTitle;
        this.sortTitle = newValue;
        this.firePropertyChange("sortTitle", oldValue, newValue);
    }

    public String getTitleSortable() {
        if (StringUtils.isEmpty((CharSequence)this.titleSortable)) {
            this.titleSortable = Utils.getSortableName(this.getTitle());
        }
        return this.titleSortable;
    }

    public void clearTitleSortable() {
        this.titleSortable = "";
    }

    public Boolean getHasNfoFile() {
        List<MediaFile> mf = this.getMediaFiles(MediaFileType.NFO);
        if (mf != null && mf.size() > 0) {
            return true;
        }
        return false;
    }

    public Boolean getHasMetadata() {
        if (!(this.plot.isEmpty() || this.year.isEmpty() || this.year.equals("0"))) {
            return true;
        }
        return false;
    }

    public Boolean getHasImages() {
        if (!MovieModuleManager.MOVIE_SETTINGS.getMoviePosterFilenames().isEmpty() && StringUtils.isEmpty((CharSequence)this.getArtworkFilename(MediaFileType.POSTER))) {
            return false;
        }
        if (!MovieModuleManager.MOVIE_SETTINGS.getMovieFanartFilenames().isEmpty() && StringUtils.isEmpty((CharSequence)this.getArtworkFilename(MediaFileType.FANART))) {
            return false;
        }
        return true;
    }

    public Boolean getHasTrailer() {
        if (this.trailer != null && this.trailer.size() > 0) {
            return true;
        }
        if (!this.getMediaFiles(MediaFileType.TRAILER).isEmpty()) {
            return true;
        }
        return false;
    }

    public String getTitleForUi() {
        String titleForUi = this.title;
        if (StringUtils.isNotBlank((CharSequence)this.year)) {
            titleForUi = titleForUi + " (" + this.year + ")";
        }
        return titleForUi;
    }

    @Override
    public void initializeAfterLoading() {
        super.initializeAfterLoading();
        Utils.removeEmptyStringsFromList(this.tags);
        Utils.removeEmptyStringsFromList(this.genres);
        for (String genre : new ArrayList<String>(this.genres)) {
            this.addGenre(MediaGenres.getGenre((String)genre));
        }
        if (this.movieSetId != null) {
            this.movieSet = MovieList.getInstance().lookupMovieSet(this.movieSetId);
        }
    }

    public void addActor(MovieActor obj) {
        if (StringUtils.isBlank((CharSequence)obj.getEntityRoot())) {
            obj.setEntityRoot(this.getPathNIO());
        }
        this.actors.add(obj);
        this.firePropertyChange("actors", null, this.getActors());
    }

    public List<MovieTrailer> getTrailer() {
        return this.trailer;
    }

    public void addTrailer(MovieTrailer obj) {
        this.trailer.add(obj);
        this.firePropertyChange("trailer", null, this.trailer);
    }

    public void removeAllTrailers() {
        this.trailer.clear();
        this.firePropertyChange("trailer", null, this.trailer);
    }

    public void addToTags(String newTag) {
        if (StringUtils.isBlank((CharSequence)newTag)) {
            return;
        }
        for (String tag : this.tags) {
            if (!tag.equals(newTag)) continue;
            return;
        }
        this.tags.add(newTag);
        this.firePropertyChange("tag", null, newTag);
        this.firePropertyChange("tagsAsString", null, newTag);
    }

    public void removeFromTags(String removeTag) {
        this.tags.remove(removeTag);
        this.firePropertyChange("tag", null, removeTag);
        this.firePropertyChange("tagsAsString", null, removeTag);
    }

    @JsonSetter
    public void setTags(List<String> newTags) {
        String tag;
        int i;
        for (i = this.tags.size() - 1; i >= 0; --i) {
            tag = this.tags.get(i);
            if (newTags.contains(tag)) continue;
            this.tags.remove(tag);
        }
        for (i = 0; i < newTags.size(); ++i) {
            tag = newTags.get(i);
            if (!this.tags.contains(tag)) {
                try {
                    this.tags.add(i, tag);
                }
                catch (IndexOutOfBoundsException e) {
                    this.tags.add(tag);
                }
                continue;
            }
            int indexOldList = this.tags.indexOf(tag);
            if (i == indexOldList) continue;
            String oldTag = this.tags.remove(indexOldList);
            try {
                this.tags.add(i, oldTag);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                this.tags.add(oldTag);
            }
        }
        Utils.removeEmptyStringsFromList(this.tags);
        this.firePropertyChange("tag", null, newTags);
        this.firePropertyChange("tagsAsString", null, newTags);
    }

    public String getTagsAsString() {
        StringBuilder sb = new StringBuilder();
        for (String tag : this.tags) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(tag);
        }
        return sb.toString();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String newValue) {
        String oldValue = this.dataSource;
        this.dataSource = newValue;
        this.firePropertyChange("dataSource", oldValue, newValue);
    }

    public boolean hasSubtitles() {
        if (this.subtitles) {
            return true;
        }
        if (this.getMediaFiles(MediaFileType.SUBTITLE).size() > 0) {
            return true;
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            if (!mf.hasSubtitles()) continue;
            return true;
        }
        return false;
    }

    public void setSubtitles(boolean sub) {
        this.subtitles = sub;
    }

    @Deprecated
    public void findActorImages() {
        if (MovieModuleManager.MOVIE_SETTINGS.isWriteActorImages()) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.getPathNIO());){
                for (Path path : directoryStream) {
                    if (!Utils.isRegularFile(path)) continue;
                    for (MovieActor actor : this.getActors()) {
                        String name;
                        if (!StringUtils.isBlank((CharSequence)actor.getThumbPath()) || !(name = actor.getNameForStorage()).equals(path.getFileName().toString())) continue;
                        actor.setThumbPath(path.toAbsolutePath().toString());
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public List<MovieActor> getActors() {
        return this.actors;
    }

    public String getDirector() {
        return this.director;
    }

    public String getImdbId() {
        return this.getIdAsString("imdb");
    }

    public int getTmdbId() {
        return this.getIdAsInt("tmdb");
    }

    public void setTmdbId(int newValue) {
        this.setId("tmdb", newValue);
    }

    public int getTraktId() {
        return this.getIdAsInt("trakt");
    }

    public void setTraktId(int newValue) {
        this.setId("trakt", newValue);
    }

    public int getRuntime() {
        int runtimeFromMi = this.getRuntimeFromMediaFilesInMinutes();
        if (MovieModuleManager.MOVIE_SETTINGS.isRuntimeFromMediaInfo() && runtimeFromMi > 0) {
            return runtimeFromMi;
        }
        return this.runtime == 0 ? runtimeFromMi : this.runtime;
    }

    public String getTagline() {
        return this.tagline;
    }

    public String getWriter() {
        return this.writer;
    }

    public boolean hasFile(String filename) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            return false;
        }
        for (MediaFile file : new ArrayList<MediaFile>(this.getMediaFiles())) {
            if (filename.compareTo(file.getFilename()) != 0) continue;
            return true;
        }
        return false;
    }

    public void removeActor(MovieActor obj) {
        this.actors.remove(obj);
        this.firePropertyChange("actors", null, this.getActors());
    }

    public List<String> getExtraThumbs() {
        return this.extraThumbs;
    }

    @JsonSetter
    public void setExtraThumbs(List<String> extraThumbs) {
        this.extraThumbs.clear();
        this.extraThumbs.addAll(extraThumbs);
    }

    public List<String> getExtraFanarts() {
        return this.extraFanarts;
    }

    @JsonSetter
    public void setExtraFanarts(List<String> extraFanarts) {
        this.extraFanarts.clear();
        this.extraFanarts.addAll(extraFanarts);
    }

    public void setImdbId(String newValue) {
        this.setId("imdb", newValue);
    }

    public void setMetadata(MediaMetadata metadata, MovieScraperMetadataConfig config) {
        if (metadata == null) {
            LOGGER.error("metadata was null");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)metadata.getTitle())) {
            LOGGER.warn("wanted to save empty metadata for " + this.getTitle());
            return;
        }
        this.setIds(metadata.getIds());
        if (config.isTitle()) {
            this.setTitle(metadata.getTitle());
        }
        if (config.isOriginalTitle()) {
            this.setOriginalTitle(metadata.getOriginalTitle());
        }
        if (config.isTagline()) {
            this.setTagline(metadata.getTagline());
        }
        if (config.isPlot()) {
            this.setPlot(metadata.getPlot());
        }
        if (config.isYear()) {
            if (metadata.getYear() != 0) {
                this.setYear(Integer.toString(metadata.getYear()));
            } else {
                this.setYear("");
            }
            this.setReleaseDate(metadata.getReleaseDate());
        }
        if (config.isRating()) {
            this.setRating(metadata.getRating());
            this.setVotes(metadata.getVoteCount());
            this.setTop250(metadata.getTop250());
        }
        if (config.isRuntime()) {
            this.setRuntime(metadata.getRuntime());
        }
        this.setSpokenLanguages(StringUtils.join((Iterable)metadata.getSpokenLanguages(), (String)", "));
        this.setCountry(StringUtils.join((Iterable)metadata.getCountries(), (String)", "));
        if (config.isCertification() && metadata.getCertifications() != null && metadata.getCertifications().size() > 0) {
            this.setCertification((Certification)metadata.getCertifications().get(0));
        }
        if (config.isCast()) {
            this.setProductionCompany(StringUtils.join((Iterable)metadata.getProductionCompanies(), (String)", "));
            ArrayList<MovieActor> actors = new ArrayList<MovieActor>();
            ArrayList<MovieProducer> producers = new ArrayList<MovieProducer>();
            String director = "";
            String writer = "";
            for (MediaCastMember member : metadata.getCastMembers()) {
                switch (member.getType()) {
                    case ACTOR: {
                        MovieActor actor = new MovieActor();
                        actor.setName(member.getName());
                        actor.setCharacter(member.getCharacter());
                        actor.setThumbUrl(member.getImageUrl());
                        actors.add(actor);
                        break;
                    }
                    case DIRECTOR: {
                        if (!StringUtils.isEmpty((CharSequence)director)) {
                            director = director + ", ";
                        }
                        director = director + member.getName();
                        break;
                    }
                    case WRITER: {
                        if (!StringUtils.isEmpty((CharSequence)writer)) {
                            writer = writer + ", ";
                        }
                        writer = writer + member.getName();
                        break;
                    }
                    case PRODUCER: {
                        MovieProducer producer = new MovieProducer();
                        producer.setName(member.getName());
                        producer.setRole(member.getPart());
                        producer.setThumbUrl(member.getImageUrl());
                        producers.add(producer);
                        break;
                    }
                }
            }
            this.setActors(actors);
            this.setDirector(director);
            this.setWriter(writer);
            this.setProducers(producers);
            this.writeActorImages();
        }
        if (config.isGenres()) {
            this.setGenres(metadata.getGenres());
        }
        if (config.isTags()) {
            for (String tag : metadata.getTags()) {
                this.addToTags(tag);
            }
        }
        this.setScraped(true);
        if (config.isCollection()) {
            int col = 0;
            try {
                col = (Integer)metadata.getId("tmdbSet");
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (col != 0) {
                MovieSet movieSet = MovieList.getInstance().getMovieSet(metadata.getCollectionName(), col);
                if (movieSet != null && movieSet.getTmdbId() == 0) {
                    movieSet.setTmdbId(col);
                    try {
                        List<MediaScraper> sets = MediaScraper.getMediaScrapers(ScraperType.MOVIE_SET);
                        if (sets != null && sets.size() > 0) {
                            MediaScraper first = sets.get(0);
                            IMovieSetMetadataProvider mp = (IMovieSetMetadataProvider)first.getMediaProvider();
                            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE_SET);
                            options.setTmdbId(col);
                            options.setLanguage(LocaleUtils.toLocale((String)MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().name()));
                            options.setCountry(MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry());
                            MediaMetadata info = mp.getMetadata(options);
                            if (info != null && StringUtils.isNotBlank((CharSequence)info.getTitle())) {
                                movieSet.setTitle(info.getTitle());
                                movieSet.setPlot(info.getPlot());
                                if (!info.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
                                    movieSet.setArtworkUrl(((MediaArtwork)info.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).get(0)).getDefaultUrl(), MediaFileType.POSTER);
                                }
                                if (!info.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).isEmpty()) {
                                    movieSet.setArtworkUrl(((MediaArtwork)info.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).get(0)).getDefaultUrl(), MediaFileType.FANART);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (movieSet != null) {
                    this.setMovieSet(null);
                    this.setMovieSet(movieSet);
                    movieSet.insertMovie(this);
                    movieSet.saveToDb();
                }
            }
        }
        this.writeNFO();
        this.saveToDb();
        if (MovieModuleManager.MOVIE_SETTINGS.isMovieRenameAfterScrape()) {
            MovieRenamer.renameMovie(this);
        }
    }

    @JsonSetter
    public void setTrailers(List<MovieTrailer> trailers) {
        MovieTrailer preferredTrailer = null;
        this.removeAllTrailers();
        if (MovieModuleManager.MOVIE_SETTINGS.isUseTrailerPreference()) {
            MovieTrailerQuality desiredQuality = MovieModuleManager.MOVIE_SETTINGS.getTrailerQuality();
            MovieTrailerSources desiredSource = MovieModuleManager.MOVIE_SETTINGS.getTrailerSource();
            for (MovieTrailer trailer : trailers) {
                if (!desiredQuality.containsQuality(trailer.getQuality()) || !desiredSource.containsSource(trailer.getProvider())) continue;
                trailer.setInNfo(Boolean.TRUE);
                preferredTrailer = trailer;
                break;
            }
            if (preferredTrailer == null) {
                for (MovieTrailer trailer : trailers) {
                    if (!desiredQuality.containsQuality(trailer.getQuality())) continue;
                    trailer.setInNfo(Boolean.TRUE);
                    preferredTrailer = trailer;
                    break;
                }
            }
            if (preferredTrailer == null) {
                ArrayList<MovieTrailer> sortedTrailers = new ArrayList<MovieTrailer>(trailers);
                Collections.sort(sortedTrailers, TRAILER_QUALITY_COMPARATOR);
                for (MovieTrailer trailer : sortedTrailers) {
                    if (desiredQuality.ordinal() < MovieTrailerQuality.getMovieTrailerQuality(trailer.getQuality()).ordinal()) continue;
                    trailer.setInNfo(Boolean.TRUE);
                    preferredTrailer = trailer;
                    break;
                }
            }
        }
        if (preferredTrailer == null && !trailers.isEmpty()) {
            ArrayList<MovieTrailer> sortedTrailers = new ArrayList<MovieTrailer>(trailers);
            Collections.sort(sortedTrailers, TRAILER_QUALITY_COMPARATOR);
            preferredTrailer = (MovieTrailer)sortedTrailers.get(0);
            preferredTrailer.setInNfo(Boolean.TRUE);
        }
        if (preferredTrailer != null) {
            this.addTrailer(preferredTrailer);
        }
        for (MovieTrailer trailer : trailers) {
            if (preferredTrailer != null && preferredTrailer == trailer) continue;
            if (preferredTrailer == null && this.trailer.size() == 0 && !trailer.getUrl().startsWith("file")) {
                trailer.setInNfo(Boolean.TRUE);
            }
            this.addTrailer(trailer);
        }
        if (MovieModuleManager.MOVIE_SETTINGS.isUseTrailerPreference() && MovieModuleManager.MOVIE_SETTINGS.isAutomaticTrailerDownload() && this.getMediaFiles(MediaFileType.TRAILER).isEmpty() && !this.trailer.isEmpty()) {
            MovieTrailer trailer = this.trailer.get(0);
            MovieTrailerDownloadTask task = new MovieTrailerDownloadTask(trailer, this);
            TmmTaskManager.getInstance().addDownloadTask(task);
        }
        this.writeNFO();
        this.saveToDb();
    }

    public MediaMetadata getMetadata() {
        MediaMetadata md = new MediaMetadata("");
        for (Map.Entry entry : this.ids.entrySet()) {
            md.setId((String)entry.getKey(), entry.getValue());
        }
        md.setTitle(this.title);
        md.setOriginalTitle(this.originalTitle);
        md.setTagline(this.tagline);
        md.setPlot(this.plot);
        try {
            md.setYear(Integer.parseInt(this.year));
        }
        catch (Exception exception) {
            // empty catch block
        }
        md.setRating(this.rating);
        md.setVoteCount(this.votes);
        md.setRuntime(this.runtime);
        md.addCertification(this.certification);
        return md;
    }

    public void setArtwork(MediaMetadata md, MovieScraperMetadataConfig config) {
        this.setArtwork(md.getMediaArt(MediaArtwork.MediaArtworkType.ALL), config);
    }

    public void setArtwork(List<MediaArtwork> artwork, MovieScraperMetadataConfig config) {
        if (config.isArtwork()) {
            MovieArtworkHelper.setArtwork(this, artwork);
        }
    }

    @JsonSetter
    public void setActors(List<MovieActor> newActors) {
        MovieActor actor2;
        int i;
        for (i = this.actors.size() - 1; i >= 0; --i) {
            actor2 = this.actors.get(i);
            if (newActors.contains(actor2)) continue;
            this.actors.remove(actor2);
        }
        for (i = 0; i < newActors.size(); ++i) {
            actor2 = newActors.get(i);
            if (!this.actors.contains(actor2)) {
                try {
                    this.actors.add(i, actor2);
                }
                catch (IndexOutOfBoundsException e) {
                    this.actors.add(actor2);
                }
                continue;
            }
            int indexOldList = this.actors.indexOf(actor2);
            if (i == indexOldList) continue;
            MovieActor oldActor = this.actors.remove(indexOldList);
            try {
                this.actors.add(i, oldActor);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                this.actors.add(oldActor);
            }
        }
        for (MovieActor actor2 : this.actors) {
            if (!StringUtils.isBlank((CharSequence)actor2.getEntityRoot())) continue;
            actor2.setEntityRoot(this.getPathNIO());
        }
        this.firePropertyChange("actors", null, this.getActors());
    }

    @Override
    public void setTitle(String newValue) {
        String oldValue = this.title;
        super.setTitle(newValue);
        this.firePropertyChange("titleForUi", oldValue, newValue);
        oldValue = this.titleSortable;
        this.titleSortable = "";
        this.firePropertyChange("titleSortable", oldValue, this.titleSortable);
    }

    public void setRuntime(int newValue) {
        int oldValue = this.runtime;
        this.runtime = newValue;
        this.firePropertyChange("runtime", oldValue, newValue);
    }

    public void setTagline(String newValue) {
        String oldValue = this.tagline;
        this.tagline = newValue;
        this.firePropertyChange("tagline", oldValue, newValue);
    }

    @Override
    public void setYear(String newValue) {
        String oldValue = this.year;
        super.setYear(newValue);
        this.firePropertyChange("titleForUi", oldValue, newValue);
    }

    public String getNfoFilename(MovieNfoNaming nfo) {
        List<MediaFile> mfs = this.getMediaFiles(MediaFileType.VIDEO);
        if (mfs != null && mfs.size() > 0) {
            String name = mfs.get(0).getFilename();
            if (this.isStacked()) {
                name = Utils.cleanStackingMarkers(name);
            }
            return this.getNfoFilename(nfo, name);
        }
        return this.getNfoFilename(nfo, "");
    }

    public String getNfoFilename(MovieNfoNaming nfo, String newMovieFilename) {
        String filename = "";
        switch (nfo) {
            case FILENAME_NFO: {
                if (this.isDisc()) {
                    if (Files.exists(this.getPathNIO().resolve("VIDEO_TS.ifo"), new LinkOption[0]) || Files.exists(this.getPathNIO().resolve("VIDEO_TS"), new LinkOption[0])) {
                        filename = "VIDEO_TS.nfo";
                        break;
                    }
                    if (Files.exists(this.getPathNIO().resolve("index.bdmv"), new LinkOption[0])) {
                        filename = "index.nfo";
                        break;
                    }
                    if (!Files.exists(this.getPathNIO().resolve("BDMV"), new LinkOption[0])) break;
                    filename = "BDMV.nfo";
                    break;
                }
                String movieFilename = FilenameUtils.getBaseName((String)newMovieFilename);
                filename = filename + movieFilename + ".nfo";
                break;
            }
            case MOVIE_NFO: {
                filename = filename + "movie.nfo";
                break;
            }
            case DISC_NFO: {
                if (!this.isDisc()) break;
                Path dir = this.getPathNIO().resolve("VIDEO_TS");
                if (Files.isDirectory(dir, new LinkOption[0])) {
                    filename = dir.resolve("VIDEO_TS.nfo").toString();
                }
                if (!Files.isDirectory(dir = this.getPathNIO().resolve("BDMV"), new LinkOption[0])) break;
                filename = dir.resolve("index.nfo").toString();
                break;
            }
            default: {
                filename = "";
            }
        }
        return filename;
    }

    public String getTrailerBasename() {
        List<MediaFile> mfs = this.getMediaFiles(MediaFileType.VIDEO);
        if (mfs != null && mfs.size() > 0) {
            return FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mfs.get(0).getFilename()));
        }
        return null;
    }

    public void downloadArtwork(MediaFileType type) {
        MovieArtworkHelper.downloadArtwork(this, type);
    }

    public void writeActorImages() {
        if (!MovieModuleManager.MOVIE_SETTINGS.isWriteActorImages() || this.isMultiMovieDir()) {
            return;
        }
        MovieActorImageFetcher task = new MovieActorImageFetcher(this);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public void writeNFO() {
        if (MovieModuleManager.MOVIE_SETTINGS.getMovieNfoFilenames().isEmpty()) {
            LOGGER.info("Not writing any NFO file, because NFO filename preferences were empty...");
            return;
        }
        if (MovieModuleManager.MOVIE_SETTINGS.getMovieConnector() == MovieConnectors.MP) {
            MovieToMpNfoConnector.setData(this);
        } else if (MovieModuleManager.MOVIE_SETTINGS.getMovieConnector() == MovieConnectors.XBMC) {
            MovieToXbmcNfoConnector.setData(this);
        } else {
            MovieToKodiNfoConnector.setData(this);
        }
        this.firePropertyChange("hasNfoFile", false, true);
    }

    public void setDirector(String newValue) {
        String oldValue = this.director;
        this.director = newValue;
        this.firePropertyChange("director", oldValue, newValue);
    }

    public void setWriter(String newValue) {
        String oldValue = this.writer;
        this.writer = newValue;
        this.firePropertyChange("writer", oldValue, newValue);
    }

    public List<MediaGenres> getGenres() {
        return this.genresForAccess;
    }

    public void addGenre(MediaGenres newValue) {
        if (!this.genresForAccess.contains(newValue)) {
            this.genresForAccess.add(newValue);
            if (!this.genres.contains(newValue.name())) {
                this.genres.add(newValue.name());
            }
            this.firePropertyChange("genre", null, newValue);
            this.firePropertyChange("genresAsString", null, newValue);
        }
    }

    @JsonSetter
    public void setGenres(List<MediaGenres> newGenres) {
        MediaGenres genre2;
        int i;
        for (i = this.genresForAccess.size() - 1; i >= 0; --i) {
            genre2 = this.genresForAccess.get(i);
            if (newGenres.contains(genre2)) continue;
            this.genresForAccess.remove(genre2);
        }
        for (i = 0; i < newGenres.size(); ++i) {
            genre2 = newGenres.get(i);
            if (!this.genresForAccess.contains(genre2)) {
                try {
                    this.genresForAccess.add(i, genre2);
                }
                catch (IndexOutOfBoundsException e) {
                    this.genresForAccess.add(genre2);
                }
                continue;
            }
            int indexOldList = this.genresForAccess.indexOf(genre2);
            if (i == indexOldList) continue;
            MediaGenres oldGenre = this.genresForAccess.remove(indexOldList);
            try {
                this.genresForAccess.add(i, oldGenre);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                this.genresForAccess.add(oldGenre);
            }
        }
        this.genres.clear();
        for (MediaGenres genre2 : this.genresForAccess) {
            this.genres.add(genre2.name());
        }
        this.firePropertyChange("genre", null, this.genres);
        this.firePropertyChange("genresAsString", null, this.genres);
    }

    public void removeGenre(MediaGenres genre) {
        if (this.genresForAccess.contains(genre)) {
            this.genresForAccess.remove(genre);
            this.genres.remove(genre.name());
            this.firePropertyChange("genre", null, genre);
            this.firePropertyChange("genresAsString", null, genre);
        }
    }

    public Certification getCertification() {
        return this.certification;
    }

    public void setCertification(Certification newValue) {
        this.certification = newValue;
        this.firePropertyChange("certification", null, newValue);
    }

    public boolean getHasRating() {
        return this.rating > 0.0f || this.scraped;
    }

    public String getGenresAsString() {
        StringBuilder sb = new StringBuilder();
        for (MediaGenres genre : this.genresForAccess) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(genre != null ? genre.getLocalizedName() : "null");
        }
        return sb.toString();
    }

    public boolean isWatched() {
        return this.watched;
    }

    public void setWatched(boolean newValue) {
        boolean oldValue = this.watched;
        this.watched = newValue;
        this.firePropertyChange("watched", oldValue, newValue);
    }

    public boolean isMultiMovieDir() {
        return this.multiMovieDir;
    }

    public void setMultiMovieDir(boolean multiDir) {
        this.multiMovieDir = multiDir;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public MovieSet getMovieSet() {
        return this.movieSet;
    }

    public void setMovieSet(MovieSet newValue) {
        MovieSet oldValue = this.movieSet;
        this.movieSet = newValue;
        this.movieSetId = newValue == null ? null : newValue.getDbId();
        this.firePropertyChange("movieset", oldValue, newValue);
        this.firePropertyChange("movieSetTitle", oldValue, newValue);
    }

    public void movieSetTitleChanged() {
        this.firePropertyChange("movieSetTitle", null, "");
    }

    public String getMovieSetTitle() {
        if (this.movieSet != null) {
            return this.movieSet.getTitle();
        }
        return "";
    }

    public void removeFromMovieSet() {
        if (this.movieSet != null) {
            this.movieSet.removeMovie(this, true);
        }
        this.setMovieSet(null);
    }

    public boolean isDisc() {
        return this.isDisc;
    }

    public void setDisc(boolean isDisc) {
        this.isDisc = isDisc;
    }

    public String getMediaInfoVideoFormat() {
        List<MediaFile> videos = this.getMediaFiles(MediaFileType.VIDEO);
        if (videos.size() > 0) {
            MediaFile mediaFile = videos.get(0);
            return mediaFile.getVideoFormat();
        }
        return "";
    }

    public String getMediaInfoVideoCodec() {
        List<MediaFile> videos = this.getMediaFiles(MediaFileType.VIDEO);
        if (videos.size() > 0) {
            MediaFile mediaFile = videos.get(0);
            return mediaFile.getVideoCodec();
        }
        return "";
    }

    public int getMediaInfoVideoBitrate() {
        List<MediaFile> videos = this.getMediaFiles(MediaFileType.VIDEO);
        if (videos.size() > 0) {
            MediaFile mediaFile = videos.get(0);
            return mediaFile.getOverallBitRate();
        }
        return 0;
    }

    public String getMediaInfoAudioCodecAndChannels() {
        List<MediaFile> videos = this.getMediaFiles(MediaFileType.VIDEO);
        if (videos.size() > 0) {
            MediaFile mediaFile = videos.get(0);
            return mediaFile.getAudioCodec() + "_" + mediaFile.getAudioChannels();
        }
        return "";
    }

    public String getMediaInfoVideoResolution() {
        return "";
    }

    public void setSpokenLanguages(String newValue) {
        String oldValue = this.spokenLanguages;
        this.spokenLanguages = newValue;
        this.firePropertyChange("spokenLanguages", oldValue, newValue);
    }

    public String getSpokenLanguages() {
        return this.spokenLanguages;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String newValue) {
        String oldValue = this.country;
        this.country = newValue;
        this.firePropertyChange("country", oldValue, newValue);
    }

    public MediaSource getMediaSource() {
        return this.mediaSource;
    }

    public void setMediaSource(MediaSource newValue) {
        MediaSource oldValue = this.mediaSource;
        this.mediaSource = newValue;
        this.firePropertyChange("mediaSource", (Object)oldValue, (Object)newValue);
    }

    public List<Path> getImagesToCache() {
        ArrayList<Path> filesToCache = new ArrayList<Path>();
        for (MediaFile mf : this.getMediaFiles()) {
            if (!mf.isGraphic()) continue;
            filesToCache.add(mf.getFileAsPath());
        }
        if (MovieModuleManager.MOVIE_SETTINGS.isWriteActorImages()) {
            for (MovieActor actor : this.actors) {
                Path imagePath = actor.getStoragePath();
                if (imagePath == null) continue;
                filesToCache.add(imagePath);
            }
        }
        return filesToCache;
    }

    public List<MediaFile> getMediaFilesContainingAudioStreams() {
        ArrayList<MediaFile> mediaFilesWithAudioStreams = new ArrayList<MediaFile>(1);
        List<MediaFile> videoFiles = this.getMediaFiles(MediaFileType.VIDEO);
        if (videoFiles.size() > 0) {
            MediaFile videoFile = videoFiles.get(0);
            mediaFilesWithAudioStreams.add(videoFile);
        }
        for (MediaFile audioFile : this.getMediaFiles(MediaFileType.AUDIO)) {
            mediaFilesWithAudioStreams.add(audioFile);
        }
        return mediaFilesWithAudioStreams;
    }

    public List<MediaFile> getMediaFilesContainingSubtitles() {
        ArrayList<MediaFile> mediaFilesWithSubtitles = new ArrayList<MediaFile>(1);
        for (MediaFile mediaFile : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.SUBTITLE)) {
            if (!mediaFile.hasSubtitles()) continue;
            mediaFilesWithSubtitles.add(mediaFile);
        }
        return mediaFilesWithSubtitles;
    }

    public int getRuntimeFromMediaFiles() {
        int runtime = 0;
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            runtime += mf.getDuration();
        }
        return runtime;
    }

    public int getRuntimeFromMediaFilesInMinutes() {
        return this.getRuntimeFromMediaFiles() / 60;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    @JsonIgnore
    public void setReleaseDate(Date newValue) {
        Date oldValue = this.releaseDate;
        this.releaseDate = newValue;
        this.firePropertyChange("releaseDate", oldValue, newValue);
        this.firePropertyChange("releaseDateAsString", oldValue, newValue);
    }

    public String getReleaseDateFormatted() {
        if (this.releaseDate == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.releaseDate);
    }

    public String getReleaseDateAsString() {
        if (this.releaseDate == null) {
            return "";
        }
        return SimpleDateFormat.getDateInstance(2, Locale.getDefault()).format(this.releaseDate);
    }

    public void setReleaseDate(String dateAsString) {
        try {
            this.setReleaseDate(StrgUtils.parseDate((String)dateAsString));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public Date getLastWatched() {
        return this.lastWatched;
    }

    public void setLastWatched(Date lastWatched) {
        this.lastWatched = lastWatched;
    }

    @Override
    public void saveToDb() {
        MovieList.getInstance().persistMovie(this);
    }

    @Override
    public void deleteFromDb() {
        MovieList.getInstance().removeMovieFromDb(this);
    }

    @Override
    public synchronized void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
        if (MovieModuleManager.MOVIE_SETTINGS.getMovieConnector() == MovieConnectors.MP) {
            this.writeNFO();
        }
    }

    public List<MediaFile> getVideoFiles() {
        return this.getMediaFiles(MediaFileType.VIDEO);
    }

    public MediaFile getFirstVideoFile() {
        List<MediaFile> videoFiles = this.getVideoFiles();
        if (!videoFiles.isEmpty()) {
            return videoFiles.get(0);
        }
        return null;
    }

    public String getVideoBasenameWithoutStacking() {
        MediaFile mf = this.getMediaFiles(MediaFileType.VIDEO).get(0);
        return FilenameUtils.getBaseName((String)mf.getFilenameWithoutStacking());
    }

    public int getTop250() {
        return this.top250;
    }

    public void setVideoIn3D(boolean newValue) {
        boolean oldValue = this.videoIn3D;
        this.videoIn3D = newValue;
        this.firePropertyChange("videoIn3D", oldValue, newValue);
    }

    public boolean isVideoIn3D() {
        String video3DFormat = "";
        List<MediaFile> videos = this.getMediaFiles(MediaFileType.VIDEO);
        if (videos.size() > 0) {
            MediaFile mediaFile = videos.get(0);
            video3DFormat = mediaFile.getVideo3DFormat();
        }
        return this.videoIn3D || StringUtils.isNotBlank((CharSequence)video3DFormat);
    }

    public void setTop250(int newValue) {
        int oldValue = this.top250;
        this.top250 = newValue;
        this.firePropertyChange("top250", oldValue, newValue);
    }

    public void addProducer(MovieProducer obj) {
        if (StringUtils.isBlank((CharSequence)obj.getEntityRoot())) {
            obj.setEntityRoot(this.getPathNIO());
        }
        this.producers.add(obj);
        this.firePropertyChange("producers", null, this.producers);
    }

    public void removeProducer(MovieProducer obj) {
        this.producers.remove(obj);
        this.firePropertyChange("producers", null, this.producers);
    }

    @JsonSetter
    public void setProducers(List<MovieProducer> newProducers) {
        MovieProducer producer2;
        int i;
        for (i = this.producers.size() - 1; i >= 0; --i) {
            producer2 = this.producers.get(i);
            if (newProducers.contains(producer2)) continue;
            this.producers.remove(producer2);
        }
        for (i = 0; i < newProducers.size(); ++i) {
            producer2 = newProducers.get(i);
            if (!this.producers.contains(producer2)) {
                try {
                    this.producers.add(i, producer2);
                }
                catch (IndexOutOfBoundsException e) {
                    this.producers.add(producer2);
                }
                continue;
            }
            int indexOldList = this.producers.indexOf(producer2);
            if (i == indexOldList) continue;
            MovieProducer oldProducer = this.producers.remove(indexOldList);
            try {
                this.producers.add(i, oldProducer);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                this.producers.add(oldProducer);
            }
        }
        for (MovieProducer producer2 : this.producers) {
            if (!StringUtils.isBlank((CharSequence)producer2.getEntityRoot())) continue;
            producer2.setEntityRoot(this.getPathNIO());
        }
        this.firePropertyChange("producers", null, this.producers);
    }

    public List<MovieProducer> getProducers() {
        return this.producers;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public void reEvaluateStacking() {
        List<MediaFile> mfs = this.getMediaFiles(MediaFileType.VIDEO);
        if (mfs.size() > 1 && !this.isDisc()) {
            this.setStacked(true);
            for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
                mf.detectStackingInformation();
            }
        } else {
            this.setStacked(false);
            for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
                mf.removeStackingInformation();
            }
        }
    }

    public boolean deleteFilesSafely() {
        if (this.isMultiMovieDir()) {
            boolean ok = true;
            for (MediaFile mf : this.getMediaFiles()) {
                if (mf.deleteSafely(this.getDataSource())) continue;
                ok = false;
            }
            return ok;
        }
        return Utils.deleteDirectorySafely(this.getPathNIO(), this.getDataSource());
    }

    public MovieEdition getEdition() {
        return this.edition;
    }

    public String getEditionAsString() {
        return this.edition.toString();
    }

    public void setOffline(boolean newValue) {
        boolean oldValue = this.offline;
        this.offline = newValue;
        this.firePropertyChange("offline", oldValue, newValue);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setEdition(MovieEdition newValue) {
        MovieEdition oldValue = this.edition;
        this.edition = newValue;
        this.firePropertyChange("edition", (Object)oldValue, (Object)newValue);
        this.firePropertyChange("editionAsString", (Object)oldValue, (Object)newValue);
    }
}

