/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.observablecollections.ObservableCollections;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.movie.MovieFanartNaming;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieNfoNaming;
import org.tinymediamanager.core.movie.MoviePosterNaming;
import org.tinymediamanager.core.movie.MovieSearchOptions;
import org.tinymediamanager.core.movie.MovieTrailerQuality;
import org.tinymediamanager.core.movie.MovieTrailerSources;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;

@XmlRootElement(name="MovieSettings")
public class MovieSettings
extends AbstractModelObject {
    public static final String DEFAULT_RENAMER_FOLDER_PATTERN = "$T { - $U }($Y)";
    public static final String DEFAULT_RENAMER_FILE_PATTERN = "$T { - $U }($Y) $V $A";
    private static final String PATH = "path";
    private static final String FILENAME = "filename";
    private static final String MOVIE_DATA_SOURCE = "movieDataSource";
    private static final String IMAGE_POSTER_SIZE = "imagePosterSize";
    private static final String IMAGE_FANART_SIZE = "imageFanartSize";
    private static final String IMAGE_EXTRATHUMBS = "imageExtraThumbs";
    private static final String IMAGE_EXTRATHUMBS_RESIZE = "imageExtraThumbsResize";
    private static final String IMAGE_EXTRATHUMBS_SIZE = "imageExtraThumbsSize";
    private static final String IMAGE_EXTRATHUMBS_COUNT = "imageExtraThumbsCount";
    private static final String IMAGE_EXTRAFANART = "imageExtraFanart";
    private static final String IMAGE_EXTRAFANART_COUNT = "imageExtraFanartCount";
    private static final String ENABLE_MOVIESET_ARTWORK_MOVIE_FOLDER = "enableMovieSetArtworkMovieFolder";
    private static final String ENABLE_MOVIESET_ARTWORK_FOLDER = "enableMovieSetArtworkFolder";
    private static final String MOVIESET_ARTWORK_FOLDER = "movieSetArtworkFolder";
    private static final String MOVIE_CONNECTOR = "movieConnector";
    private static final String MOVIE_NFO_FILENAME = "movieNfoFilename";
    private static final String MOVIE_POSTER_FILENAME = "moviePosterFilename";
    private static final String MOVIE_FANART_FILENAME = "movieFanartFilename";
    private static final String MOVIE_RENAMER_PATHNAME = "movieRenamerPathname";
    private static final String MOVIE_RENAMER_FILENAME = "movieRenamerFilename";
    private static final String MOVIE_RENAMER_SPACE_SUBSTITUTION = "movieRenamerSpaceSubstitution";
    private static final String MOVIE_RENAMER_SPACE_REPLACEMENT = "movieRenamerSpaceReplacement";
    private static final String MOVIE_RENAMER_NFO_CLEANUP = "movieRenamerNfoCleanup";
    private static final String MOVIE_RENAMER_MOVIESET_SINGLE_MOVIE = "movieRenamerMoviesetSingleMovie";
    private static final String MOVIE_SCRAPER = "movieScraper";
    private static final String MOVIE_ARTWORK_SCRAPERS = "movieArtworkScrapers";
    private static final String MOVIE_TRAILER_SCRAPERS = "movieTrailerScrapers";
    private static final String MOVIE_SUBTITLE_SCRAPERS = "movieSubtitleScrapers";
    private static final String SCRAPE_BEST_IMAGE = "scrapeBestImage";
    private static final String WRITE_ACTOR_IMAGES = "writeActorImages";
    private static final String SCRAPER_LANGU = "scraperLanguage";
    private static final String SUBTITLE_SCRAPER_LANGU = "subtitleScraperLanguage";
    private static final String CERTIFICATION_COUNTRY = "certificationCountry";
    private static final String SCRAPER_THRESHOLD = "scraperThreshold";
    private static final String DETECT_MOVIE_MULTI_DIR = "detectMovieMultiDir";
    private static final String BUILD_IMAGE_CACHE_ON_IMPORT = "buildImageCacheOnImport";
    private static final String BAD_WORDS = "badWords";
    private static final String ENTRY = "entry";
    private static final String RUNTIME_FROM_MI = "runtimeFromMediaInfo";
    private static final String ASCII_REPLACEMENT = "asciiReplacement";
    private static final String YEAR_COLUMN_VISIBLE = "yearColumnVisible";
    private static final String NFO_COLUMN_VISIBLE = "nfoColumnVisible";
    private static final String METADATA_COLUMN_VISIBLE = "metadataColumnVisible";
    private static final String DATE_ADDED_COLUMN_VISIBLE = "dateAddedColumnVisible";
    private static final String IMAGE_COLUMN_VISIBLE = "imageColumnVisible";
    private static final String TRAILER_COLUMN_VISIBLE = "trailerColumnVisible";
    private static final String SUBTITLE_COLUMN_VISIBLE = "subtitleColumnVisible";
    private static final String WATCHED_COLUMN_VISIBLE = "watchedColumnVisible";
    private static final String SCRAPER_FALLBACK = "scraperFallback";
    private static final String UI_FILTERS = "uiFilters";
    private static final String STORE_UI_FILTERS = "storeUiFilters";
    private static final String MOVIE_SKIP_FOLDERS = "movieSkipFolders";
    @XmlElementWrapper(name="movieDataSource")
    @XmlElement(name="path")
    private final List<String> movieDataSources = ObservableCollections.observableList(new ArrayList());
    @XmlElementWrapper(name="movieNfoFilename")
    @XmlElement(name="filename")
    private final List<MovieNfoNaming> movieNfoFilenames = new ArrayList<MovieNfoNaming>();
    @XmlElementWrapper(name="moviePosterFilename")
    @XmlElement(name="filename")
    private final List<MoviePosterNaming> moviePosterFilenames = new ArrayList<MoviePosterNaming>();
    @XmlElementWrapper(name="movieFanartFilename")
    @XmlElement(name="filename")
    private final List<MovieFanartNaming> movieFanartFilenames = new ArrayList<MovieFanartNaming>();
    @XmlElementWrapper(name="badWords")
    @XmlElement(name="entry")
    private final List<String> badWords = ObservableCollections.observableList(new ArrayList());
    @XmlElementWrapper(name="movieArtworkScrapers")
    @XmlElement(name="entry")
    private final List<String> movieArtworkScrapers = ObservableCollections.observableList(new ArrayList());
    @XmlElementWrapper(name="movieTrailerScrapers")
    @XmlElement(name="entry")
    private final List<String> movieTrailerScrapers = ObservableCollections.observableList(new ArrayList());
    @XmlElementWrapper(name="movieSubtitleScrapers")
    @XmlElement(name="entry")
    private final List<String> movieSubtitleScrapers = ObservableCollections.observableList(new ArrayList());
    private Map<MovieSearchOptions, Object> uiFilters = new HashMap<MovieSearchOptions, Object>();
    @XmlElementWrapper(name="movieSkipFolders")
    @XmlElement(name="entry")
    private final List<String> movieSkipFolders = ObservableCollections.observableList(new ArrayList());
    private boolean detectMovieMultiDir = false;
    private boolean buildImageCacheOnImport = false;
    private MovieConnectors movieConnector = MovieConnectors.KODI;
    private CertificationStyle movieCertificationStyle = CertificationStyle.LARGE;
    private boolean movieRenameAfterScrape = false;
    private String movieRenamerPathname = "$T { - $U }($Y)";
    private String movieRenamerFilename = "$T { - $U }($Y) $V $A";
    private boolean movieRenamerSpaceSubstitution = false;
    private String movieRenamerSpaceReplacement = "_";
    private boolean movieRenamerNfoCleanup = false;
    private boolean movieRenamerCreateMoviesetForSingleMovie = false;
    private boolean asciiReplacement = false;
    private LanguageStyle movieRenamerLanguageStyle = LanguageStyle.ISO3T;
    private String movieScraper = "tmdb";
    private MediaLanguages scraperLanguage = MediaLanguages.en;
    private CountryCode certificationCountry = CountryCode.US;
    private double scraperThreshold = 0.75;
    private boolean scraperFallback = false;
    private MediaArtwork.PosterSizes imagePosterSize = MediaArtwork.PosterSizes.BIG;
    private MediaArtwork.FanartSizes imageFanartSize = MediaArtwork.FanartSizes.LARGE;
    private boolean imageExtraThumbs = false;
    private boolean imageExtraThumbsResize = true;
    private int imageExtraThumbsSize = 300;
    private int imageExtraThumbsCount = 5;
    private boolean imageExtraFanart = false;
    private int imageExtraFanartCount = 5;
    private boolean enableMovieSetArtworkMovieFolder = true;
    private boolean enableMovieSetArtworkFolder = false;
    private String movieSetArtworkFolder = "MoviesetArtwork";
    private boolean scrapeBestImage = true;
    private boolean imageLanguagePriority = true;
    private boolean imageLogo = true;
    private boolean imageBanner = true;
    private boolean imageClearart = true;
    private boolean imageDiscart = true;
    private boolean imageThumb = true;
    private boolean writeActorImages = false;
    private boolean useTrailerPreference = true;
    private boolean automaticTrailerDownload = false;
    private MovieTrailerQuality trailerQuality = MovieTrailerQuality.HD_720;
    private MovieTrailerSources trailerSource = MovieTrailerSources.YOUTUBE;
    private MediaLanguages subtitleScraperLanguage = MediaLanguages.en;
    private boolean runtimeFromMediaInfo = false;
    private boolean syncTrakt = false;
    private boolean yearColumnVisible = true;
    private boolean ratingColumnVisible = false;
    private boolean nfoColumnVisible = true;
    private boolean metadataColumnVisible = true;
    private boolean dateAddedColumnVisible = false;
    private boolean imageColumnVisible = true;
    private boolean trailerColumnVisible = true;
    private boolean subtitleColumnVisible = true;
    private boolean watchedColumnVisible = true;
    private boolean storeUiFilters = false;

    public void addMovieDataSources(String path) {
        if (!this.movieDataSources.contains(path)) {
            this.movieDataSources.add(path);
            this.firePropertyChange(MOVIE_DATA_SOURCE, null, this.movieDataSources);
        }
    }

    public void removeMovieDataSources(String path) {
        MovieList movieList = MovieList.getInstance();
        movieList.removeDatasource(path);
        this.movieDataSources.remove(path);
        this.firePropertyChange(MOVIE_DATA_SOURCE, null, this.movieDataSources);
    }

    public List<String> getMovieDataSource() {
        return this.movieDataSources;
    }

    public void addMovieNfoFilename(MovieNfoNaming filename) {
        if (!this.movieNfoFilenames.contains((Object)filename)) {
            this.movieNfoFilenames.add(filename);
            this.firePropertyChange(MOVIE_NFO_FILENAME, null, this.movieNfoFilenames);
        }
    }

    public void removeMovieNfoFilename(MovieNfoNaming filename) {
        if (this.movieNfoFilenames.contains((Object)filename)) {
            this.movieNfoFilenames.remove((Object)filename);
            this.firePropertyChange(MOVIE_NFO_FILENAME, null, this.movieNfoFilenames);
        }
    }

    public void clearMovieNfoFilenames() {
        this.movieNfoFilenames.clear();
        this.firePropertyChange(MOVIE_NFO_FILENAME, null, this.movieNfoFilenames);
    }

    public List<MovieNfoNaming> getMovieNfoFilenames() {
        return new ArrayList<MovieNfoNaming>(this.movieNfoFilenames);
    }

    public void addMoviePosterFilename(MoviePosterNaming filename) {
        if (!this.moviePosterFilenames.contains((Object)filename)) {
            this.moviePosterFilenames.add(filename);
            this.firePropertyChange(MOVIE_POSTER_FILENAME, null, this.moviePosterFilenames);
        }
    }

    public void removeMoviePosterFilename(MoviePosterNaming filename) {
        if (this.moviePosterFilenames.contains((Object)filename)) {
            this.moviePosterFilenames.remove((Object)filename);
            this.firePropertyChange(MOVIE_POSTER_FILENAME, null, this.moviePosterFilenames);
        }
    }

    public void clearMoviePosterFilenames() {
        this.moviePosterFilenames.clear();
        this.firePropertyChange(MOVIE_POSTER_FILENAME, null, this.moviePosterFilenames);
    }

    public List<MoviePosterNaming> getMoviePosterFilenames() {
        return new ArrayList<MoviePosterNaming>(this.moviePosterFilenames);
    }

    public void addMovieFanartFilename(MovieFanartNaming filename) {
        if (!this.movieFanartFilenames.contains((Object)filename)) {
            this.movieFanartFilenames.add(filename);
            this.firePropertyChange(MOVIE_FANART_FILENAME, null, this.movieFanartFilenames);
        }
    }

    public void removeMovieFanartFilename(MovieFanartNaming filename) {
        if (this.movieFanartFilenames.contains((Object)filename)) {
            this.movieFanartFilenames.remove((Object)filename);
            this.firePropertyChange(MOVIE_FANART_FILENAME, null, this.movieFanartFilenames);
        }
    }

    public void clearMovieFanartFilenames() {
        this.movieFanartFilenames.clear();
        this.firePropertyChange(MOVIE_FANART_FILENAME, null, this.movieFanartFilenames);
    }

    public List<MovieFanartNaming> getMovieFanartFilenames() {
        return new ArrayList<MovieFanartNaming>(this.movieFanartFilenames);
    }

    @XmlElement(name="imagePosterSize")
    public MediaArtwork.PosterSizes getImagePosterSize() {
        return this.imagePosterSize;
    }

    public void setImagePosterSize(MediaArtwork.PosterSizes newValue) {
        MediaArtwork.PosterSizes oldValue = this.imagePosterSize;
        this.imagePosterSize = newValue;
        this.firePropertyChange(IMAGE_POSTER_SIZE, oldValue, newValue);
    }

    @XmlElement(name="imageFanartSize")
    public MediaArtwork.FanartSizes getImageFanartSize() {
        return this.imageFanartSize;
    }

    public void setImageFanartSize(MediaArtwork.FanartSizes newValue) {
        MediaArtwork.FanartSizes oldValue = this.imageFanartSize;
        this.imageFanartSize = newValue;
        this.firePropertyChange(IMAGE_FANART_SIZE, oldValue, newValue);
    }

    public boolean isImageExtraThumbs() {
        return this.imageExtraThumbs;
    }

    public boolean isImageExtraThumbsResize() {
        return this.imageExtraThumbsResize;
    }

    public int getImageExtraThumbsSize() {
        return this.imageExtraThumbsSize;
    }

    public void setImageExtraThumbsResize(boolean newValue) {
        boolean oldValue = this.imageExtraThumbsResize;
        this.imageExtraThumbsResize = newValue;
        this.firePropertyChange(IMAGE_EXTRATHUMBS_RESIZE, oldValue, newValue);
    }

    public void setImageExtraThumbsSize(int newValue) {
        int oldValue = this.imageExtraThumbsSize;
        this.imageExtraThumbsSize = newValue;
        this.firePropertyChange(IMAGE_EXTRATHUMBS_SIZE, oldValue, newValue);
    }

    public int getImageExtraThumbsCount() {
        return this.imageExtraThumbsCount;
    }

    public void setImageExtraThumbsCount(int newValue) {
        int oldValue = this.imageExtraThumbsCount;
        this.imageExtraThumbsCount = newValue;
        this.firePropertyChange(IMAGE_EXTRATHUMBS_COUNT, oldValue, newValue);
    }

    public int getImageExtraFanartCount() {
        return this.imageExtraFanartCount;
    }

    public void setImageExtraFanartCount(int newValue) {
        int oldValue = this.imageExtraFanartCount;
        this.imageExtraFanartCount = newValue;
        this.firePropertyChange(IMAGE_EXTRAFANART_COUNT, oldValue, newValue);
    }

    public boolean isImageExtraFanart() {
        return this.imageExtraFanart;
    }

    public void setImageExtraThumbs(boolean newValue) {
        boolean oldValue = this.imageExtraThumbs;
        this.imageExtraThumbs = newValue;
        this.firePropertyChange(IMAGE_EXTRATHUMBS, oldValue, newValue);
    }

    public void setImageExtraFanart(boolean newValue) {
        boolean oldValue = this.imageExtraFanart;
        this.imageExtraFanart = newValue;
        this.firePropertyChange(IMAGE_EXTRAFANART, oldValue, newValue);
    }

    public boolean isEnableMovieSetArtworkMovieFolder() {
        return this.enableMovieSetArtworkMovieFolder;
    }

    public void setEnableMovieSetArtworkMovieFolder(boolean newValue) {
        boolean oldValue = this.enableMovieSetArtworkMovieFolder;
        this.enableMovieSetArtworkMovieFolder = newValue;
        this.firePropertyChange(ENABLE_MOVIESET_ARTWORK_MOVIE_FOLDER, oldValue, newValue);
    }

    public boolean isEnableMovieSetArtworkFolder() {
        return this.enableMovieSetArtworkFolder;
    }

    public void setEnableMovieSetArtworkFolder(boolean newValue) {
        boolean oldValue = this.enableMovieSetArtworkFolder;
        this.enableMovieSetArtworkFolder = newValue;
        this.firePropertyChange(ENABLE_MOVIESET_ARTWORK_FOLDER, oldValue, newValue);
    }

    public String getMovieSetArtworkFolder() {
        return this.movieSetArtworkFolder;
    }

    public void setMovieSetArtworkFolder(String newValue) {
        String oldValue = this.movieSetArtworkFolder;
        this.movieSetArtworkFolder = newValue;
        this.firePropertyChange(MOVIESET_ARTWORK_FOLDER, oldValue, newValue);
    }

    @XmlElement(name="movieConnector")
    public MovieConnectors getMovieConnector() {
        return this.movieConnector;
    }

    public void setMovieConnector(MovieConnectors newValue) {
        MovieConnectors oldValue = this.movieConnector;
        this.movieConnector = newValue;
        this.firePropertyChange(MOVIE_CONNECTOR, (Object)oldValue, (Object)newValue);
    }

    @XmlElement(name="movieRenamerPathname")
    public String getMovieRenamerPathname() {
        return this.movieRenamerPathname;
    }

    public void setMovieRenamerPathname(String newValue) {
        String oldValue = this.movieRenamerPathname;
        this.movieRenamerPathname = newValue;
        this.firePropertyChange(MOVIE_RENAMER_PATHNAME, oldValue, newValue);
    }

    @XmlElement(name="movieRenamerFilename")
    public String getMovieRenamerFilename() {
        return this.movieRenamerFilename;
    }

    public void setMovieRenamerFilename(String newValue) {
        String oldValue = this.movieRenamerFilename;
        this.movieRenamerFilename = newValue;
        this.firePropertyChange(MOVIE_RENAMER_FILENAME, oldValue, newValue);
    }

    @XmlElement(name="movieRenamerSpaceSubstitution")
    public boolean isMovieRenamerSpaceSubstitution() {
        return this.movieRenamerSpaceSubstitution;
    }

    public void setMovieRenamerSpaceSubstitution(boolean movieRenamerSpaceSubstitution) {
        this.movieRenamerSpaceSubstitution = movieRenamerSpaceSubstitution;
    }

    public void setMovieRenameAfterScrape(boolean newValue) {
        boolean oldValue = this.movieRenameAfterScrape;
        this.movieRenameAfterScrape = newValue;
        this.firePropertyChange("movieRenameAfterScrape", oldValue, newValue);
    }

    public boolean isMovieRenameAfterScrape() {
        return this.movieRenameAfterScrape;
    }

    @XmlElement(name="movieRenamerSpaceReplacement")
    public String getMovieRenamerSpaceReplacement() {
        return this.movieRenamerSpaceReplacement;
    }

    public void setMovieRenamerSpaceReplacement(String movieRenamerSpaceReplacement) {
        this.movieRenamerSpaceReplacement = movieRenamerSpaceReplacement;
    }

    public String getMovieScraper() {
        if (StringUtils.isBlank((CharSequence)this.movieScraper)) {
            return "tmdb";
        }
        return this.movieScraper;
    }

    public void setMovieScraper(String newValue) {
        String oldValue = this.movieScraper;
        this.movieScraper = newValue;
        this.firePropertyChange(MOVIE_SCRAPER, oldValue, newValue);
    }

    public void addMovieArtworkScraper(String newValue) {
        if (!this.movieArtworkScrapers.contains(newValue)) {
            this.movieArtworkScrapers.add(newValue);
            this.firePropertyChange(MOVIE_ARTWORK_SCRAPERS, null, this.movieArtworkScrapers);
        }
    }

    public void removeMovieArtworkScraper(String newValue) {
        if (this.movieArtworkScrapers.contains(newValue)) {
            this.movieArtworkScrapers.remove(newValue);
            this.firePropertyChange(MOVIE_ARTWORK_SCRAPERS, null, this.movieArtworkScrapers);
        }
    }

    public List<String> getMovieArtworkScrapers() {
        return this.movieArtworkScrapers;
    }

    public boolean isScrapeBestImage() {
        return this.scrapeBestImage;
    }

    public void setScrapeBestImage(boolean newValue) {
        boolean oldValue = this.scrapeBestImage;
        this.scrapeBestImage = newValue;
        this.firePropertyChange(SCRAPE_BEST_IMAGE, oldValue, newValue);
    }

    public void addMovieTrailerScraper(String newValue) {
        if (!this.movieTrailerScrapers.contains(newValue)) {
            this.movieTrailerScrapers.add(newValue);
            this.firePropertyChange(MOVIE_TRAILER_SCRAPERS, null, this.movieTrailerScrapers);
        }
    }

    public void removeMovieTrailerScraper(String newValue) {
        if (this.movieTrailerScrapers.contains(newValue)) {
            this.movieTrailerScrapers.remove(newValue);
            this.firePropertyChange(MOVIE_TRAILER_SCRAPERS, null, this.movieTrailerScrapers);
        }
    }

    public List<String> getMovieTrailerScrapers() {
        return this.movieTrailerScrapers;
    }

    public void addMovieSubtitleScraper(String newValue) {
        if (!this.movieSubtitleScrapers.contains(newValue)) {
            this.movieSubtitleScrapers.add(newValue);
            this.firePropertyChange(MOVIE_SUBTITLE_SCRAPERS, null, this.movieSubtitleScrapers);
        }
    }

    public void removeMovieSubtitleScraper(String newValue) {
        if (this.movieSubtitleScrapers.contains(newValue)) {
            this.movieSubtitleScrapers.remove(newValue);
            this.firePropertyChange(MOVIE_SUBTITLE_SCRAPERS, null, this.movieSubtitleScrapers);
        }
    }

    public List<String> getMovieSubtitleScrapers() {
        return this.movieSubtitleScrapers;
    }

    public void addMovieSkipFolder(String newValue) {
        if (!this.movieSkipFolders.contains(newValue)) {
            this.movieSkipFolders.add(newValue);
            this.firePropertyChange(MOVIE_SKIP_FOLDERS, null, this.movieSkipFolders);
        }
    }

    public void removeMovieSkipFolder(String newValue) {
        if (this.movieSkipFolders.contains(newValue)) {
            this.movieSkipFolders.remove(newValue);
            this.firePropertyChange(MOVIE_SKIP_FOLDERS, null, this.movieSkipFolders);
        }
    }

    public List<String> getMovieSkipFolders() {
        return this.movieSkipFolders;
    }

    public void setUiFilters(Map<MovieSearchOptions, Object> filters) {
        this.uiFilters = filters;
        this.firePropertyChange(UI_FILTERS, null, this.uiFilters);
    }

    @XmlElement(name="uiFilters")
    @XmlJavaTypeAdapter(value=MovieSearchOptions.MovieSearchOptionsAdapter.class)
    public Map<MovieSearchOptions, Object> getUiFilters() {
        if (this.storeUiFilters) {
            return this.uiFilters;
        }
        return new HashMap<MovieSearchOptions, Object>();
    }

    public void setStoreUiFilters(boolean newValue) {
        boolean oldValue = this.storeUiFilters;
        this.storeUiFilters = newValue;
        this.firePropertyChange(STORE_UI_FILTERS, oldValue, newValue);
    }

    public boolean isStoreUiFilters() {
        return this.storeUiFilters;
    }

    public boolean isWriteActorImages() {
        return this.writeActorImages;
    }

    public void setWriteActorImages(boolean newValue) {
        boolean oldValue = this.writeActorImages;
        this.writeActorImages = newValue;
        this.firePropertyChange(WRITE_ACTOR_IMAGES, oldValue, newValue);
    }

    @XmlElement(name="scraperLanguage")
    public MediaLanguages getScraperLanguage() {
        return this.scraperLanguage;
    }

    public void setScraperLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.scraperLanguage;
        this.scraperLanguage = newValue;
        this.firePropertyChange(SCRAPER_LANGU, oldValue, newValue);
    }

    @XmlElement(name="subtitleScraperLanguage")
    public MediaLanguages getSubtitleScraperLanguage() {
        return this.subtitleScraperLanguage;
    }

    public void setSubtitleScraperLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.subtitleScraperLanguage;
        this.subtitleScraperLanguage = newValue;
        this.firePropertyChange(SUBTITLE_SCRAPER_LANGU, oldValue, newValue);
    }

    @XmlElement(name="certificationCountry")
    public CountryCode getCertificationCountry() {
        return this.certificationCountry;
    }

    public void setCertificationCountry(CountryCode newValue) {
        CountryCode oldValue = this.certificationCountry;
        this.certificationCountry = newValue;
        this.firePropertyChange(CERTIFICATION_COUNTRY, oldValue, newValue);
    }

    @XmlElement(name="scraperThreshold")
    public double getScraperThreshold() {
        return this.scraperThreshold;
    }

    public void setScraperThreshold(double newValue) {
        double oldValue = this.scraperThreshold;
        this.scraperThreshold = newValue;
        this.firePropertyChange(SCRAPER_THRESHOLD, oldValue, newValue);
    }

    @XmlElement(name="movieRenamerNfoCleanup")
    public boolean isMovieRenamerNfoCleanup() {
        return this.movieRenamerNfoCleanup;
    }

    public void setMovieRenamerNfoCleanup(boolean newValue) {
        boolean oldValue = this.movieRenamerNfoCleanup;
        this.movieRenamerNfoCleanup = newValue;
        this.firePropertyChange(MOVIE_RENAMER_NFO_CLEANUP, oldValue, newValue);
    }

    @Deprecated
    public boolean isDetectMovieMultiDir() {
        return this.detectMovieMultiDir;
    }

    @Deprecated
    public void setDetectMovieMultiDir(boolean newValue) {
        boolean oldValue = this.detectMovieMultiDir;
        this.detectMovieMultiDir = newValue;
        this.firePropertyChange(DETECT_MOVIE_MULTI_DIR, oldValue, newValue);
    }

    public boolean isBuildImageCacheOnImport() {
        return this.buildImageCacheOnImport;
    }

    public void setBuildImageCacheOnImport(boolean newValue) {
        boolean oldValue = this.buildImageCacheOnImport;
        this.buildImageCacheOnImport = newValue;
        this.firePropertyChange(BUILD_IMAGE_CACHE_ON_IMPORT, oldValue, newValue);
    }

    public boolean isMovieRenamerCreateMoviesetForSingleMovie() {
        return this.movieRenamerCreateMoviesetForSingleMovie;
    }

    public void setMovieRenamerCreateMoviesetForSingleMovie(boolean newValue) {
        boolean oldValue = this.movieRenamerCreateMoviesetForSingleMovie;
        this.movieRenamerCreateMoviesetForSingleMovie = newValue;
        this.firePropertyChange(MOVIE_RENAMER_MOVIESET_SINGLE_MOVIE, oldValue, newValue);
    }

    public boolean isRuntimeFromMediaInfo() {
        return this.runtimeFromMediaInfo;
    }

    public void setRuntimeFromMediaInfo(boolean newValue) {
        boolean oldValue = this.runtimeFromMediaInfo;
        this.runtimeFromMediaInfo = newValue;
        this.firePropertyChange(RUNTIME_FROM_MI, oldValue, newValue);
    }

    public boolean isAsciiReplacement() {
        return this.asciiReplacement;
    }

    public void setAsciiReplacement(boolean newValue) {
        boolean oldValue = this.asciiReplacement;
        this.asciiReplacement = newValue;
        this.firePropertyChange(ASCII_REPLACEMENT, oldValue, newValue);
    }

    public void addBadWord(String badWord) {
        if (!this.badWords.contains(badWord.toLowerCase(Locale.ROOT))) {
            this.badWords.add(badWord.toLowerCase(Locale.ROOT));
            this.firePropertyChange(BAD_WORDS, null, this.badWords);
        }
    }

    public void removeBadWord(String badWord) {
        this.badWords.remove(badWord.toLowerCase(Locale.ROOT));
        this.firePropertyChange(BAD_WORDS, null, this.badWords);
    }

    public List<String> getBadWords() {
        ListIterator<String> iterator = this.badWords.listIterator();
        while (iterator.hasNext()) {
            iterator.set(iterator.next().toLowerCase(Locale.ROOT));
        }
        return this.badWords;
    }

    public boolean isYearColumnVisible() {
        return this.yearColumnVisible;
    }

    public void setYearColumnVisible(boolean newValue) {
        boolean oldValue = this.yearColumnVisible;
        this.yearColumnVisible = newValue;
        this.firePropertyChange(YEAR_COLUMN_VISIBLE, oldValue, newValue);
    }

    public boolean isRatingColumnVisible() {
        return this.ratingColumnVisible;
    }

    public void setRatingColumnVisible(boolean newValue) {
        boolean oldValue = this.ratingColumnVisible;
        this.ratingColumnVisible = newValue;
        this.firePropertyChange("ratingColumnVisible", oldValue, newValue);
    }

    public boolean isNfoColumnVisible() {
        return this.nfoColumnVisible;
    }

    public void setNfoColumnVisible(boolean newValue) {
        boolean oldValue = this.nfoColumnVisible;
        this.nfoColumnVisible = newValue;
        this.firePropertyChange(NFO_COLUMN_VISIBLE, oldValue, newValue);
    }

    public boolean isMetadataColumnVisible() {
        return this.metadataColumnVisible;
    }

    public void setMetadataColumnVisible(boolean newValue) {
        boolean oldValue = this.metadataColumnVisible;
        this.metadataColumnVisible = newValue;
        this.firePropertyChange(METADATA_COLUMN_VISIBLE, oldValue, newValue);
    }

    public boolean isDateAddedColumnVisible() {
        return this.dateAddedColumnVisible;
    }

    public void setDateAddedColumnVisible(boolean newValue) {
        boolean oldValue = this.dateAddedColumnVisible;
        this.dateAddedColumnVisible = newValue;
        this.firePropertyChange(DATE_ADDED_COLUMN_VISIBLE, oldValue, newValue);
    }

    public boolean isImageColumnVisible() {
        return this.imageColumnVisible;
    }

    public void setImageColumnVisible(boolean newValue) {
        boolean oldValue = this.imageColumnVisible;
        this.imageColumnVisible = newValue;
        this.firePropertyChange(IMAGE_COLUMN_VISIBLE, oldValue, newValue);
    }

    public boolean isTrailerColumnVisible() {
        return this.trailerColumnVisible;
    }

    public void setTrailerColumnVisible(boolean newValue) {
        boolean oldValue = this.trailerColumnVisible;
        this.trailerColumnVisible = newValue;
        this.firePropertyChange(TRAILER_COLUMN_VISIBLE, oldValue, newValue);
    }

    public boolean isSubtitleColumnVisible() {
        return this.subtitleColumnVisible;
    }

    public void setSubtitleColumnVisible(boolean newValue) {
        boolean oldValue = this.subtitleColumnVisible;
        this.subtitleColumnVisible = newValue;
        this.firePropertyChange(SUBTITLE_COLUMN_VISIBLE, oldValue, newValue);
    }

    public boolean isWatchedColumnVisible() {
        return this.watchedColumnVisible;
    }

    public void setWatchedColumnVisible(boolean newValue) {
        boolean oldValue = this.watchedColumnVisible;
        this.watchedColumnVisible = newValue;
        this.firePropertyChange(WATCHED_COLUMN_VISIBLE, oldValue, newValue);
    }

    public boolean isScraperFallback() {
        return this.scraperFallback;
    }

    public void setScraperFallback(boolean newValue) {
        boolean oldValue = this.scraperFallback;
        this.scraperFallback = newValue;
        this.firePropertyChange(SCRAPER_FALLBACK, oldValue, newValue);
    }

    public boolean isImageLogo() {
        return this.imageLogo;
    }

    public boolean isImageBanner() {
        return this.imageBanner;
    }

    public boolean isImageClearart() {
        return this.imageClearart;
    }

    public boolean isImageDiscart() {
        return this.imageDiscart;
    }

    public boolean isImageThumb() {
        return this.imageThumb;
    }

    public void setImageLogo(boolean newValue) {
        boolean oldValue = this.imageLogo;
        this.imageLogo = newValue;
        this.firePropertyChange("imageLogo", oldValue, newValue);
    }

    public void setImageBanner(boolean newValue) {
        boolean oldValue = this.imageBanner;
        this.imageBanner = newValue;
        this.firePropertyChange("imageBanner", oldValue, newValue);
    }

    public void setImageClearart(boolean newValue) {
        boolean oldValue = this.imageClearart;
        this.imageClearart = newValue;
        this.firePropertyChange("imageClearart", oldValue, newValue);
    }

    public void setImageDiscart(boolean newValue) {
        boolean oldValue = this.imageDiscart;
        this.imageDiscart = newValue;
        this.firePropertyChange("imageDiscart", oldValue, newValue);
    }

    public void setImageThumb(boolean newValue) {
        boolean oldValue = this.imageThumb;
        this.imageThumb = newValue;
        this.firePropertyChange("imageThumb", oldValue, newValue);
    }

    public boolean isUseTrailerPreference() {
        return this.useTrailerPreference;
    }

    public void setUseTrailerPreference(boolean newValue) {
        boolean oldValue = this.useTrailerPreference;
        this.useTrailerPreference = newValue;
        this.firePropertyChange("useTrailerPreference", oldValue, newValue);
    }

    public boolean isAutomaticTrailerDownload() {
        return this.automaticTrailerDownload;
    }

    public void setAutomaticTrailerDownload(boolean newValue) {
        boolean oldValue = this.automaticTrailerDownload;
        this.automaticTrailerDownload = newValue;
        this.firePropertyChange("automaticTrailerDownload", oldValue, newValue);
    }

    public MovieTrailerQuality getTrailerQuality() {
        return this.trailerQuality;
    }

    public void setTrailerQuality(MovieTrailerQuality newValue) {
        MovieTrailerQuality oldValue = this.trailerQuality;
        this.trailerQuality = newValue;
        this.firePropertyChange("trailerQuality", (Object)oldValue, (Object)newValue);
    }

    public MovieTrailerSources getTrailerSource() {
        return this.trailerSource;
    }

    public void setTrailerSource(MovieTrailerSources newValue) {
        MovieTrailerSources oldValue = this.trailerSource;
        this.trailerSource = newValue;
        this.firePropertyChange("trailerSource", (Object)oldValue, (Object)newValue);
    }

    public void setSyncTrakt(boolean newValue) {
        boolean oldValue = this.syncTrakt;
        this.syncTrakt = newValue;
        this.firePropertyChange("syncTrakt", oldValue, newValue);
    }

    public boolean getSyncTrakt() {
        return this.syncTrakt;
    }

    public boolean isImageLanguagePriority() {
        return this.imageLanguagePriority;
    }

    public void setImageLanguagePriority(boolean newValue) {
        boolean oldValue = this.imageLanguagePriority;
        this.imageLanguagePriority = newValue;
        this.firePropertyChange("imageLanguagePriority", oldValue, newValue);
    }

    public CertificationStyle getMovieCertificationStyle() {
        return this.movieCertificationStyle;
    }

    public void setMovieCertificationStyle(CertificationStyle newValue) {
        CertificationStyle oldValue = this.movieCertificationStyle;
        this.movieCertificationStyle = newValue;
        this.firePropertyChange("movieCertificationStyle", (Object)oldValue, (Object)newValue);
    }

    public LanguageStyle getMovieRenamerLanguageStyle() {
        return this.movieRenamerLanguageStyle;
    }

    public void setMovieRenamerLanguageStyle(LanguageStyle newValue) {
        LanguageStyle oldValue = this.movieRenamerLanguageStyle;
        this.movieRenamerLanguageStyle = newValue;
        this.firePropertyChange("movieRenamerLanguageStyle", (Object)oldValue, (Object)newValue);
    }
}

