/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.h2.mvstore.MVMap;
import org.jdesktop.observablecollections.ObservableCollections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;

public class MovieList
extends AbstractModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieList.class);
    private static MovieList instance;
    private final MovieSettings movieSettings;
    private final List<Movie> movieList;
    private final List<MovieSet> movieSetList;
    private final List<String> tagsObservable;
    private final List<String> videoCodecsObservable;
    private final List<String> audioCodecsObservable;
    private final List<Certification> certificationsObservable;
    private final PropertyChangeListener tagListener;
    private final Comparator<MovieSet> movieSetComparator = new MovieSetComparator();

    private MovieList() {
        this.movieList = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Movie.class));
        this.movieSetList = ObservableCollections.observableList(Collections.synchronizedList(new ArrayList()));
        this.tagsObservable = ObservableCollections.observableList(new CopyOnWriteArrayList());
        this.videoCodecsObservable = ObservableCollections.observableList(new CopyOnWriteArrayList());
        this.audioCodecsObservable = ObservableCollections.observableList(new CopyOnWriteArrayList());
        this.certificationsObservable = ObservableCollections.observableList(new CopyOnWriteArrayList());
        this.tagListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Movie movie;
                if ("tag".equals(evt.getPropertyName())) {
                    movie = (Movie)evt.getSource();
                    MovieList.this.updateTags(movie);
                }
                if ("mediaFiles".equals(evt.getPropertyName()) || "mediaInformation".equals(evt.getPropertyName())) {
                    movie = (Movie)evt.getSource();
                    MovieList.this.updateMediaInformationLists(movie);
                }
                if ("certification".equals(evt.getPropertyName())) {
                    movie = (Movie)evt.getSource();
                    MovieList.this.updateCertifications(movie);
                }
            }
        };
        this.movieSettings = MovieModuleManager.MOVIE_SETTINGS;
    }

    public static synchronized MovieList getInstance() {
        if (instance == null) {
            instance = new MovieList();
        }
        return instance;
    }

    public void addMovie(Movie movie) {
        if (!this.movieList.contains(movie)) {
            int oldValue = this.movieList.size();
            this.movieList.add(movie);
            this.updateTags(movie);
            movie.addPropertyChangeListener(this.tagListener);
            this.firePropertyChange("movies", null, this.movieList);
            this.firePropertyChange("movieCount", oldValue, this.movieList.size());
        }
    }

    public void removeDatasource(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return;
        }
        ArrayList<Movie> moviesToRemove = new ArrayList<Movie>();
        for (int i = this.movieList.size() - 1; i >= 0; --i) {
            Movie movie = this.movieList.get(i);
            if (!new File(path).equals(new File(movie.getDataSource()))) continue;
            moviesToRemove.add(movie);
        }
        this.removeMovies(moviesToRemove);
    }

    public List<Movie> getUnscrapedMovies() {
        ArrayList<Movie> unscrapedMovies = new ArrayList<Movie>();
        for (Movie movie : this.movieList) {
            if (movie.isScraped()) continue;
            unscrapedMovies.add(movie);
        }
        return unscrapedMovies;
    }

    public List<Movie> getNewMovies() {
        ArrayList<Movie> newMovies = new ArrayList<Movie>();
        for (Movie movie : this.movieList) {
            if (!movie.isNewlyAdded()) continue;
            newMovies.add(movie);
        }
        return newMovies;
    }

    public void removeMovies(List<Movie> movies) {
        if (movies == null || movies.size() == 0) {
            return;
        }
        HashSet<MovieSet> modifiedMovieSets = new HashSet<MovieSet>();
        int oldValue = this.movieList.size();
        for (int i = movies.size() - 1; i >= 0; --i) {
            Movie movie = movies.get(i);
            this.movieList.remove(movie);
            if (movie.getMovieSet() != null) {
                MovieSet movieSet = movie.getMovieSet();
                movieSet.removeMovie(movie, false);
                modifiedMovieSets.add(movieSet);
                movie.setMovieSet(null);
            }
            try {
                MovieModuleManager.getInstance().removeMovieFromDb(movie);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error removing movie from DB: " + e.getMessage());
            }
        }
        this.firePropertyChange("movies", null, this.movieList);
        this.firePropertyChange("movieCount", oldValue, this.movieList.size());
    }

    public void deleteMovies(List<Movie> movies) {
        if (movies == null || movies.size() == 0) {
            return;
        }
        HashSet<MovieSet> modifiedMovieSets = new HashSet<MovieSet>();
        int oldValue = this.movieList.size();
        for (int i = movies.size() - 1; i >= 0; --i) {
            Movie movie = movies.get(i);
            movie.deleteFilesSafely();
            this.movieList.remove(movie);
            if (movie.getMovieSet() != null) {
                MovieSet movieSet = movie.getMovieSet();
                movieSet.removeMovie(movie, false);
                modifiedMovieSets.add(movieSet);
                movie.setMovieSet(null);
            }
            try {
                MovieModuleManager.getInstance().removeMovieFromDb(movie);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error removing movie from DB: " + e.getMessage());
            }
        }
        this.firePropertyChange("movies", null, this.movieList);
        this.firePropertyChange("movieCount", oldValue, this.movieList.size());
    }

    public List<Movie> getMovies() {
        return this.movieList;
    }

    void loadMoviesFromDatabase(MVMap<UUID, String> movieMap, ObjectMapper objectMapper) {
        ObjectReader movieObjectReader = objectMapper.readerFor(Movie.class);
        for (UUID uuid : new ArrayList(movieMap.keyList())) {
            String json = "";
            try {
                json = (String)movieMap.get((Object)uuid);
                Movie movie = (Movie)movieObjectReader.readValue(json);
                movie.setDbId(uuid);
                this.movieList.add(movie);
            }
            catch (Exception e) {
                LOGGER.warn("problem decoding movie json string: " + e.getMessage());
                LOGGER.info("dropping corrupt movie");
                movieMap.remove((Object)uuid);
            }
        }
        LOGGER.info("found " + this.movieList.size() + " movies in database");
    }

    void loadMovieSetsFromDatabase(MVMap<UUID, String> movieSetMap, ObjectMapper objectMapper) {
        ObjectReader movieSetObjectReader = objectMapper.readerFor(MovieSet.class);
        for (UUID uuid : new ArrayList(movieSetMap.keyList())) {
            try {
                MovieSet movieSet = (MovieSet)movieSetObjectReader.readValue((String)movieSetMap.get((Object)uuid));
                movieSet.setDbId(uuid);
                this.movieSetList.add(movieSet);
            }
            catch (Exception e) {
                LOGGER.warn("problem decoding movie set json string: " + e.getMessage());
                LOGGER.info("dropping corrupt movie set");
                movieSetMap.remove((Object)uuid);
            }
        }
        LOGGER.info("found " + this.movieSetList.size() + " movieSets in database");
    }

    void initDataAfterLoading() {
        this.checkAndCleanupMediaFiles();
        for (Movie movie : this.movieList) {
            movie.initializeAfterLoading();
            this.updateTags(movie);
            this.updateMediaInformationLists(movie);
            this.updateCertifications(movie);
            movie.addPropertyChangeListener(this.tagListener);
        }
        for (MovieSet movieSet : this.movieSetList) {
            movieSet.initializeAfterLoading();
        }
    }

    public void persistMovie(Movie movie) {
        try {
            MovieModuleManager.getInstance().persistMovie(movie);
        }
        catch (Exception e) {
            LOGGER.error("failed to persist movie: " + movie.getTitle());
        }
    }

    public void removeMovieFromDb(Movie movie) {
        try {
            MovieModuleManager.getInstance().removeMovieFromDb(movie);
        }
        catch (Exception e) {
            LOGGER.error("failed to remove movie: " + movie.getTitle());
        }
    }

    public void persistMovieSet(MovieSet movieSet) {
        try {
            MovieModuleManager.getInstance().persistMovieSet(movieSet);
        }
        catch (Exception e) {
            LOGGER.error("failed to persist movie set: " + movieSet.getTitle());
        }
    }

    public void removeMovieSetFromDb(MovieSet movieSet) {
        try {
            MovieModuleManager.getInstance().removeMovieSetFromDb(movieSet);
        }
        catch (Exception e) {
            LOGGER.error("failed to remove movie set: " + movieSet.getTitle());
        }
    }

    public MovieSet lookupMovieSet(UUID uuid) {
        for (MovieSet movieSet : this.movieSetList) {
            if (!movieSet.getDbId().equals(uuid)) continue;
            return movieSet;
        }
        return null;
    }

    public Movie lookupMovie(UUID uuid) {
        for (Movie movie : this.movieList) {
            if (!movie.getDbId().equals(uuid)) continue;
            return movie;
        }
        return null;
    }

    @Deprecated
    public synchronized Movie getMovieByPath(File path) {
        return this.getMovieByPath(path.toPath());
    }

    public synchronized Movie getMovieByPath(Path path) {
        for (Movie movie : this.movieList) {
            if (movie.getPathNIO().compareTo(path.toAbsolutePath()) != 0) continue;
            LOGGER.debug("Ok, found already existing movie '" + movie.getTitle() + "' in DB (path: " + path + ")");
            return movie;
        }
        return null;
    }

    @Deprecated
    public synchronized List<Movie> getMoviesByPath(File path) {
        return this.getMoviesByPath(path.toPath());
    }

    public synchronized List<Movie> getMoviesByPath(Path path) {
        ArrayList<Movie> movies = new ArrayList<Movie>();
        for (Movie movie : this.movieList) {
            if (Paths.get(movie.getPath(), new String[0]).compareTo(path) != 0) continue;
            movies.add(movie);
        }
        return movies;
    }

    public List<MediaSearchResult> searchMovie(String searchTerm, Movie movie, MediaScraper metadataScraper) {
        return this.searchMovie(searchTerm, movie, metadataScraper, this.movieSettings.getScraperLanguage());
    }

    public List<MediaSearchResult> searchMovie(String searchTerm, Movie movie, MediaScraper mediaScraper, MediaLanguages langu) {
        List sr;
        block15: {
            sr = null;
            try {
                IMovieMetadataProvider provider = mediaScraper == null ? (IMovieMetadataProvider)this.getDefaultMediaScraper().getMediaProvider() : (IMovieMetadataProvider)mediaScraper.getMediaProvider();
                boolean idFound = false;
                MediaSearchOptions options = new MediaSearchOptions(MediaType.MOVIE);
                options.setLanguage(LocaleUtils.toLocale((String)langu.name()));
                options.setCountry(this.movieSettings.getCertificationCountry());
                if (movie != null) {
                    if (Utils.isValidImdbId(movie.getImdbId())) {
                        options.setImdbId(movie.getImdbId());
                        idFound = true;
                    }
                    if (movie.getTmdbId() != 0) {
                        options.setTmdbId(movie.getTmdbId());
                        idFound = true;
                    }
                    options.setQuery(movie.getTitle());
                    if (!movie.getYear().isEmpty()) {
                        try {
                            options.setYear(Integer.parseInt(movie.getYear()));
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                    }
                }
                if (!searchTerm.isEmpty()) {
                    if (idFound) {
                        if (!searchTerm.equals(movie.getTitle())) {
                            options.setQuery(searchTerm);
                        }
                    } else {
                        options.setQuery(searchTerm);
                    }
                }
                LOGGER.info("=====================================================");
                LOGGER.info("Searching with scraper: " + provider.getProviderInfo().getId() + ", " + provider.getProviderInfo().getVersion());
                LOGGER.info(options.toString());
                LOGGER.info("=====================================================");
                sr = provider.search(options);
                if (!sr.isEmpty() || !this.movieSettings.isScraperFallback()) break block15;
                for (MediaScraper ms : this.getAvailableMediaScrapers()) {
                    if (!ms.isEnabled() || provider.getProviderInfo().equals(ms.getMediaProvider().getProviderInfo()) || ms.getMediaProvider().getProviderInfo().getName().startsWith("Kodi")) continue;
                    LOGGER.info("no result yet - trying alternate scraper: " + ms.getName());
                    try {
                        LOGGER.info("=====================================================");
                        LOGGER.info("Searching with alternate scraper: " + ms.getMediaProvider().getProviderInfo().getId() + ", " + provider.getProviderInfo().getVersion());
                        LOGGER.info(options.toString());
                        LOGGER.info("=====================================================");
                        sr = ((IMovieMetadataProvider)ms.getMediaProvider()).search(options);
                    }
                    catch (Exception e) {
                        LOGGER.error("searchMovieFallback", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.movie.searcherror", new String[]{":", e.getLocalizedMessage()}));
                    }
                    if (sr.isEmpty()) continue;
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error("searchMovie", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.movie.searcherror", new String[]{":", e.getLocalizedMessage()}));
            }
        }
        return sr;
    }

    public List<MediaScraper> getAvailableMediaScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.MOVIE);
        Collections.sort(availableScrapers, new MovieMediaScraperComparator());
        return availableScrapers;
    }

    public MediaScraper getDefaultMediaScraper() {
        MediaScraper scraper = MediaScraper.getMediaScraperById(this.movieSettings.getMovieScraper(), ScraperType.MOVIE);
        if (scraper == null) {
            scraper = MediaScraper.getMediaScraperById("tmdb", ScraperType.MOVIE);
        }
        return scraper;
    }

    public MediaScraper getMediaScraperById(String providerId) {
        return MediaScraper.getMediaScraperById(providerId, ScraperType.MOVIE);
    }

    public List<MediaScraper> getAvailableArtworkScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.MOVIE_ARTWORK);
        Collections.sort(availableScrapers, new MovieMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getArtworkScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> artworkScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper artworkScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (artworkScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.MOVIE_ARTWORK)) == null) continue;
            artworkScrapers.add(artworkScraper);
        }
        return artworkScrapers;
    }

    public List<MediaScraper> getDefaultArtworkScrapers() {
        return this.getArtworkScrapers(this.movieSettings.getMovieArtworkScrapers());
    }

    public List<MediaScraper> getAvailableTrailerScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.MOVIE_TRAILER);
        Collections.sort(availableScrapers, new MovieMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getDefaultTrailerScrapers() {
        return this.getTrailerScrapers(this.movieSettings.getMovieTrailerScrapers());
    }

    public List<MediaScraper> getTrailerScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> trailerScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper trailerScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (trailerScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.MOVIE_TRAILER)) == null) continue;
            trailerScrapers.add(trailerScraper);
        }
        return trailerScrapers;
    }

    public List<MediaScraper> getAvailableSubtitleScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.SUBTITLE);
        Collections.sort(availableScrapers, new MovieMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getDefaultSubtitleScrapers() {
        return this.getSubtitleScrapers(this.movieSettings.getMovieSubtitleScrapers());
    }

    public List<MediaScraper> getSubtitleScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> subtitleScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper subtitleScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (subtitleScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.SUBTITLE)) == null) continue;
            subtitleScrapers.add(subtitleScraper);
        }
        return subtitleScrapers;
    }

    public int getMovieCount() {
        int size = this.movieList.size();
        return size;
    }

    public int getMovieSetCount() {
        int size = this.movieSetList.size();
        return size;
    }

    public List<String> getTagsInMovies() {
        return this.tagsObservable;
    }

    private void updateTags(Movie movie) {
        ArrayList<String> availableTags = new ArrayList<String>(this.tagsObservable);
        for (String tagInMovie : new ArrayList<String>(movie.getTags())) {
            boolean tagFound = false;
            for (String tag : availableTags) {
                if (!tagInMovie.equals(tag)) continue;
                tagFound = true;
                break;
            }
            if (tagFound) continue;
            this.addTag(tagInMovie);
        }
    }

    private void updateMediaInformationLists(Movie movie) {
        ArrayList<String> availableCodecs = new ArrayList<String>(this.videoCodecsObservable);
        for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO)) {
            String codec = mf.getVideoCodec();
            boolean codecFound = false;
            for (String mfCodec : availableCodecs) {
                if (!mfCodec.equals(codec)) continue;
                codecFound = true;
                break;
            }
            if (codecFound) continue;
            this.addVideoCodec(codec);
        }
        availableCodecs = new ArrayList<String>(this.audioCodecsObservable);
        for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO)) {
            for (MediaFileAudioStream audio : mf.getAudioStreams()) {
                String codec = audio.getCodec();
                boolean codecFound = false;
                for (String mfCodec : availableCodecs) {
                    if (!mfCodec.equals(codec)) continue;
                    codecFound = true;
                    break;
                }
                if (codecFound) continue;
                this.addAudioCodec(codec);
            }
        }
    }

    private void updateCertifications(Movie movie) {
        if (!this.certificationsObservable.contains(movie.getCertification())) {
            this.addCertification(movie.getCertification());
        }
    }

    public List<String> getVideoCodecsInMovies() {
        return this.videoCodecsObservable;
    }

    public List<String> getAudioCodecsInMovies() {
        return this.audioCodecsObservable;
    }

    public List<Certification> getCertificationsInMovies() {
        return this.certificationsObservable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTag(String newTag) {
        if (StringUtils.isBlank((CharSequence)newTag)) {
            return;
        }
        List<String> list = this.tagsObservable;
        synchronized (list) {
            if (this.tagsObservable.contains(newTag)) {
                return;
            }
            this.tagsObservable.add(newTag);
        }
        this.firePropertyChange("tag", null, this.tagsObservable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVideoCodec(String newCodec) {
        if (StringUtils.isBlank((CharSequence)newCodec)) {
            return;
        }
        List<String> list = this.videoCodecsObservable;
        synchronized (list) {
            if (this.videoCodecsObservable.contains(newCodec)) {
                return;
            }
            this.videoCodecsObservable.add(newCodec);
        }
        this.firePropertyChange("videoCodec", null, this.videoCodecsObservable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAudioCodec(String newCodec) {
        if (StringUtils.isBlank((CharSequence)newCodec)) {
            return;
        }
        List<String> list = this.audioCodecsObservable;
        synchronized (list) {
            if (this.audioCodecsObservable.contains(newCodec)) {
                return;
            }
            this.audioCodecsObservable.add(newCodec);
        }
        this.firePropertyChange("audioCodec", null, this.audioCodecsObservable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCertification(Certification newCert) {
        if (newCert == null) {
            return;
        }
        List<Certification> list = this.certificationsObservable;
        synchronized (list) {
            if (this.certificationsObservable.contains(newCert)) {
                return;
            }
            this.certificationsObservable.add(newCert);
        }
        this.firePropertyChange("certification", null, this.certificationsObservable);
    }

    public void searchDuplicates() {
        HashMap<String, Movie> imdbDuplicates = new HashMap<String, Movie>();
        HashMap<Integer, Movie> tmdbDuplicates = new HashMap<Integer, Movie>();
        for (Movie movie : this.movieList) {
            Movie movie2;
            movie.clearDuplicate();
            if (StringUtils.isNotEmpty((CharSequence)movie.getImdbId())) {
                if (imdbDuplicates.containsKey(movie.getImdbId())) {
                    movie.setDuplicate();
                    movie2 = (Movie)imdbDuplicates.get(movie.getImdbId());
                    movie2.setDuplicate();
                } else {
                    imdbDuplicates.put(movie.getImdbId(), movie);
                }
            }
            if (movie.getTmdbId() <= 0) continue;
            if (tmdbDuplicates.containsKey(movie.getTmdbId())) {
                movie.setDuplicate();
                movie2 = (Movie)tmdbDuplicates.get(movie.getTmdbId());
                movie2.setDuplicate();
                continue;
            }
            tmdbDuplicates.put(movie.getTmdbId(), movie);
        }
    }

    public List<MovieSet> getMovieSetList() {
        return this.movieSetList;
    }

    public List<MovieSet> getSortedMovieSetList() {
        ArrayList<MovieSet> sortedMovieSets = new ArrayList<MovieSet>(this.getMovieSetList());
        Collections.sort(sortedMovieSets, this.movieSetComparator);
        return sortedMovieSets;
    }

    public void addMovieSet(MovieSet movieSet) {
        int oldValue = this.movieSetList.size();
        this.movieSetList.add(movieSet);
        this.firePropertyChange("addedMovieSet", null, movieSet);
        this.firePropertyChange("movieSetCount", oldValue, this.movieSetList.size());
    }

    public void removeMovieSet(MovieSet movieSet) {
        int oldValue = this.movieSetList.size();
        movieSet.removeAllMovies();
        try {
            this.movieSetList.remove(movieSet);
            MovieModuleManager.getInstance().removeMovieSetFromDb(movieSet);
        }
        catch (Exception e) {
            LOGGER.error("Error removing movie set from DB: " + e.getMessage());
        }
        this.firePropertyChange("removedMovieSet", null, movieSet);
        this.firePropertyChange("movieSetCount", oldValue, this.movieSetList.size());
    }

    private MovieSet findMovieSet(String title, int tmdbId) {
        if (tmdbId > 0) {
            for (MovieSet movieSet : this.movieSetList) {
                if (movieSet.getTmdbId() != tmdbId) continue;
                return movieSet;
            }
        }
        for (MovieSet movieSet : this.movieSetList) {
            if (!movieSet.getTitle().equals(title)) continue;
            return movieSet;
        }
        return null;
    }

    public synchronized MovieSet getMovieSet(String title, int tmdbId) {
        MovieSet movieSet = this.findMovieSet(title, tmdbId);
        if (movieSet == null && StringUtils.isNotBlank((CharSequence)title)) {
            movieSet = new MovieSet(title);
            movieSet.saveToDb();
            this.addMovieSet(movieSet);
        }
        return movieSet;
    }

    public void sortMoviesInMovieSet(MovieSet movieSet) {
        if (movieSet.getMovies().size() > 1) {
            movieSet.sortMovies();
        }
        this.firePropertyChange("sortedMovieSets", null, this.movieSetList);
    }

    private void checkAndCleanupMediaFiles() {
        ArrayList<Movie> moviesToRemove = new ArrayList<Movie>();
        for (Movie movie : this.movieList) {
            List<MediaFile> mfs = movie.getMediaFiles(MediaFileType.VIDEO);
            if (!mfs.isEmpty()) continue;
            moviesToRemove.add(movie);
        }
        if (!moviesToRemove.isEmpty()) {
            this.removeMovies(moviesToRemove);
            LOGGER.warn("movies without VIDEOs detected");
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    Message message = new Message(Message.MessageLevel.SEVERE, "tmm.movies", "message.database.corrupteddata");
                    MessageManager.instance.pushMessage(message);
                }
            });
            thread.start();
        }
    }

    public void invalidateTitleSortable() {
        for (Movie movie : new ArrayList<Movie>(this.movieList)) {
            movie.clearTitleSortable();
        }
    }

    public void addOfflineMovie(String title, String datasource) {
        this.addOfflineMovie(title, datasource, MediaSource.UNKNOWN);
    }

    public void addOfflineMovie(String title, String datasource, MediaSource mediaSource) {
        if (!this.movieSettings.getMovieDataSource().contains(datasource)) {
            return;
        }
        int i = 1;
        Path stubFolder = Paths.get(datasource, title);
        while (Files.exists(stubFolder, new LinkOption[0])) {
            stubFolder = Paths.get(datasource, title + "(" + i++ + ")");
        }
        Path stubFile = stubFolder.resolve(title + ".disc");
        try {
            Files.createDirectory(stubFolder, new FileAttribute[0]);
            Files.createFile(stubFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("could not create stub file: " + e.getMessage());
            return;
        }
        MediaFile mf = new MediaFile(stubFile);
        mf.gatherMediaInformation();
        Movie movie = new Movie();
        movie.setTitle(title);
        movie.setPath(stubFolder.toAbsolutePath().toString());
        movie.setDataSource(datasource);
        movie.setMediaSource(mediaSource);
        movie.setDateAdded(new Date());
        movie.addToMediaFiles(mf);
        movie.setOffline(true);
        movie.setNewlyAdded(true);
        this.addMovie(movie);
        movie.saveToDb();
    }

    private class MovieMediaScraperComparator
    implements Comparator<MediaScraper> {
        private MovieMediaScraperComparator() {
        }

        @Override
        public int compare(MediaScraper o1, MediaScraper o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }

    private class MovieSetComparator
    implements Comparator<MovieSet> {
        private MovieSetComparator() {
        }

        @Override
        public int compare(MovieSet o1, MovieSet o2) {
            if (o1 == null || o2 == null || o1.getTitleSortable() == null || o2.getTitleSortable() == null) {
                return 0;
            }
            return o1.getTitleSortable().compareToIgnoreCase(o2.getTitleSortable());
        }
    }
}

