/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.UpdaterTask;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieRenameTask;
import org.tinymediamanager.core.movie.tasks.MovieScrapeTask;
import org.tinymediamanager.core.movie.tasks.MovieUpdateDatasourceTask2;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowEpisodeScrapeTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowRenameTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowScrapeTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowUpdateDatasourceTask2;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TinyMediaManagerCMD {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyMediaManagerCMD.class);
    private static boolean updateMovies = false;
    private static boolean updateTv = false;
    private static boolean scrapeAll = false;
    private static boolean scrapeNew = false;
    private static boolean scrapeUnscraped = false;
    private static boolean rename = false;
    private static boolean dryRun = false;
    private static boolean checkFiles = false;
    private static HashSet<Integer> updateMovieDs = new HashSet();
    private static HashSet<Integer> updateTvDs = new HashSet();

    static void parseParams(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            if (cmd.equalsIgnoreCase("-updateMovies")) {
                updateMovies = true;
                continue;
            }
            if (cmd.matches("(?)-updateMovies[1-9]")) {
                updateMovies = true;
                updateMovieDs.add(Integer.parseInt(StrgUtils.substr((String)cmd, (String)"(?)-updateMovies(\\d)")));
                continue;
            }
            if (cmd.equalsIgnoreCase("-updateTv")) {
                updateTv = true;
                continue;
            }
            if (cmd.matches("(?)-updateTv[1-9]")) {
                updateTv = true;
                updateTvDs.add(Integer.parseInt(StrgUtils.substr((String)cmd, (String)"(?)-updateTv(\\d)")));
                continue;
            }
            if (cmd.equalsIgnoreCase("-update")) {
                updateMovies = true;
                updateTv = true;
                continue;
            }
            if (cmd.equalsIgnoreCase("-scrapeNew")) {
                scrapeNew = true;
                continue;
            }
            if (cmd.equalsIgnoreCase("-scrapeAll")) {
                scrapeAll = true;
                continue;
            }
            if (cmd.equalsIgnoreCase("-scrapeUnscraped")) {
                scrapeUnscraped = true;
                continue;
            }
            if (cmd.equalsIgnoreCase("-dryRun")) {
                dryRun = true;
                if (args.length != 1) continue;
                TinyMediaManagerCMD.printSyntax();
                System.exit(0);
                continue;
            }
            if (cmd.equalsIgnoreCase("-checkFiles")) {
                checkFiles = true;
                continue;
            }
            if (cmd.equalsIgnoreCase("-rename") || cmd.equalsIgnoreCase("-renameNew")) {
                rename = true;
                continue;
            }
            if (cmd.equalsIgnoreCase("-config")) {
                String file;
                if (++i == args.length) {
                    System.out.println("ERROR: config not specified!");
                    TinyMediaManagerCMD.printSyntax();
                    System.exit(0);
                }
                if (Files.exists(Paths.get("data", file = args[i]), new LinkOption[0])) {
                    Settings.getInstance("data", file);
                    continue;
                }
                System.out.println("ERROR: config file not found! " + file);
                TinyMediaManagerCMD.printSyntax();
                System.exit(0);
                continue;
            }
            if (cmd.toLowerCase(Locale.ROOT).contains("help")) {
                TinyMediaManagerCMD.printSyntax();
                System.exit(0);
                continue;
            }
            System.out.println("ERROR: unrecognized command " + cmd);
            TinyMediaManagerCMD.printSyntax();
            System.exit(0);
        }
    }

    static void printSyntax() {
        System.out.println("\n=====================================================\n=== tinyMediaManager (c) 2012-2016 Manuel Laggner ===\n=====================================================\n\nSYNTAX:    Windows:   tinyMediaManagerCMD.exe <parameters>\n           Linux:   ./tinyMediaManagerCMD.sh  <parameters>\n\n\nPARAMETERS:\n\n    UPDATE: Will scan your folders, and adds all found items to database\n            Keeps an internal list of 'new' items (for this run only!)\n\n    -updateMovies        update all movie datasources\n    -updateMoviesX       replace X with 1-9 - just updates a single movie datasource; ordering like GUI\n    -updateTv            update all TvShow\n    -updateTvX           replace X with 1-9 - just updates a single TvShow datasource; ordering like GUI\n    -update              update all (short for '-updateMovies -updateTv')\n\n    SCRAPE: auto-scrapes (force best match) your specified items:\n    -scrapeNew           only NEW FOUND movies/TvShows/episodes from former update\n    -scrapeUnscraped     all movies/TvShows/episodes, which have not yet been scraped\n    -scrapeAll           ALL movies/TvShows/episodes, whether they have already been scraped or not\n\n    -rename              rename & cleanup all the movies/TvShows/episodes from former scrape command\n    -config file.xml     specify an alternative configuration xml file\n    -checkFiles          does a physical check, if all files in DB are existent on filesystem (might take long!)\n\n\nEXAMPLES:\n\n    tinyMediaManagerCMD.exe -updateMovies -updateTv3 -scrapeNew -rename\n    tinyMediaManagerCMD.exe -scrapeUnscraped -rename\n\n");
    }

    /*
     * WARNING - void declaration
     */
    static void startCommandLineTasks() {
        try {
            void var4_24;
            TmmTask task = null;
            boolean updateAvailable = false;
            if (scrapeNew || scrapeUnscraped || scrapeAll) {
                Utils.trackEvent("cmd");
                UpdaterTask updateWorker = new UpdaterTask();
                updateWorker.run();
                updateAvailable = (Boolean)updateWorker.get();
                if (updateAvailable) {
                    LOGGER.warn("There's a new TMM update available!");
                    LOGGER.warn("Please update to remove waiting time ;)");
                    for (int i = 20; i > 0; --i) {
                        System.out.print(i + "..");
                        Thread.sleep(1000L);
                    }
                    System.out.println("0");
                }
            }
            if (updateMovies) {
                LOGGER.info("Commandline - updating movies...");
                if (updateMovieDs.isEmpty()) {
                    task = new MovieUpdateDatasourceTask2();
                    task.run();
                } else {
                    ArrayList<String> dataSources = new ArrayList<String>(MovieModuleManager.MOVIE_SETTINGS.getMovieDataSource());
                    for (Integer n : updateMovieDs) {
                        if (dataSources == null || dataSources.size() < n - 1) continue;
                        task = new MovieUpdateDatasourceTask2((String)dataSources.get(n - 1));
                        task.run();
                    }
                }
                LOGGER.info("Found " + MovieList.getInstance().getNewMovies().size() + " new movies");
            }
            List<Object> moviesToScrape = new ArrayList();
            if (scrapeAll) {
                LOGGER.info("Commandline - scraping ALL movies...");
                if (MovieList.getInstance().getMovieCount() > 0) {
                    moviesToScrape = MovieList.getInstance().getMovies();
                }
            } else {
                HashSet<Movie> scrape = new HashSet<Movie>();
                if (scrapeNew) {
                    LOGGER.info("Commandline - scraping new movies...");
                    List<Movie> list = MovieList.getInstance().getNewMovies();
                    if (list.size() > 0) {
                        scrape.addAll(list);
                    }
                }
                if (scrapeUnscraped) {
                    LOGGER.info("Commandline - scraping all unscraped movies...");
                    List<Movie> list = MovieList.getInstance().getUnscrapedMovies();
                    if (list.size() > 0) {
                        scrape.addAll(list);
                    }
                }
                moviesToScrape.addAll(new ArrayList(scrape));
            }
            if (moviesToScrape.size() > 0) {
                MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions();
                options.loadDefaults();
                if (dryRun) {
                    for (Movie movie : moviesToScrape) {
                        LOGGER.info("DRYRUN: would have scraped " + movie.getTitle());
                    }
                } else {
                    task = new MovieScrapeTask(moviesToScrape, true, options);
                    task.run();
                    while (TmmTaskManager.getInstance().poolRunning()) {
                        Thread.sleep(2000L);
                    }
                }
            }
            if (rename) {
                LOGGER.info("Commandline - rename & cleanup movies...");
                if (moviesToScrape.size() > 0) {
                    if (dryRun) {
                        for (Movie movie : moviesToScrape) {
                            LOGGER.info("DRYRUN: would have renamed " + movie.getTitle());
                        }
                    } else {
                        task = new MovieRenameTask(moviesToScrape);
                        task.run();
                    }
                }
            }
            if (updateTv) {
                LOGGER.info("Commandline - updating TvShows and episodes...");
                if (updateTvDs.isEmpty()) {
                    task = new TvShowUpdateDatasourceTask2();
                    task.run();
                } else {
                    ArrayList<String> dataSources = new ArrayList<String>(TvShowModuleManager.SETTINGS.getTvShowDataSource());
                    for (Integer n : updateTvDs) {
                        if (dataSources == null || dataSources.size() < n - 1) continue;
                        task = new TvShowUpdateDatasourceTask2((String)dataSources.get(n - 1));
                        task.run();
                    }
                }
                LOGGER.info("Commandline - found " + TvShowList.getInstance().getNewTvShows().size() + " TvShow(s) containing " + TvShowList.getInstance().getNewEpisodes().size() + " new episode(s)");
            }
            List<Object> showToScrape = new ArrayList();
            ArrayList arrayList = new ArrayList();
            if (scrapeAll) {
                LOGGER.info("Commandline - scraping ALL TvShows...");
                if (TvShowList.getInstance().getTvShowCount() > 0) {
                    showToScrape = TvShowList.getInstance().getTvShows();
                    arrayList.clear();
                }
            } else {
                HashSet<TvShow> hashSet = new HashSet<TvShow>();
                HashSet<TvShowEpisode> scrapeEpisode = new HashSet<TvShowEpisode>();
                if (scrapeNew) {
                    List<TvShow> list = TvShowList.getInstance().getNewTvShows();
                    List<TvShowEpisode> newEp = TvShowList.getInstance().getNewEpisodes();
                    LOGGER.info("Commandline - scraping new TvShows...");
                    if (list.size() > 0) {
                        hashSet.addAll(list);
                    }
                    LOGGER.info("Commandline - scraping new episodes...");
                    if (newEp.size() > 0) {
                        scrapeEpisode.addAll(newEp);
                    }
                }
                if (scrapeUnscraped) {
                    LOGGER.info("Commandline - scraping unscraped TvShows...");
                    List<TvShow> list = TvShowList.getInstance().getUnscrapedTvShows();
                    List<TvShowEpisode> unscrapedEpisodes = TvShowList.getInstance().getUnscrapedEpisodes();
                    if (list.size() > 0) {
                        hashSet.addAll(list);
                    }
                    LOGGER.info("Commandline - scraping unscraped episodes...");
                    if (unscrapedEpisodes.size() > 0) {
                        scrapeEpisode.addAll(unscrapedEpisodes);
                    }
                }
                HashSet<TvShowEpisode> hashSet2 = new HashSet<TvShowEpisode>();
                for (TvShowEpisode ep : scrapeEpisode) {
                    if (!hashSet.contains(ep.getTvShow())) continue;
                    hashSet2.add(ep);
                }
                scrapeEpisode.removeAll(hashSet2);
                showToScrape = new ArrayList(hashSet);
                ArrayList arrayList2 = new ArrayList(scrapeEpisode);
            }
            TvShowSearchAndScrapeOptions tvShowSearchAndScrapeOptions = new TvShowSearchAndScrapeOptions();
            tvShowSearchAndScrapeOptions.loadDefaults();
            if (showToScrape.size() > 0) {
                if (dryRun) {
                    for (TvShow tvShow : showToScrape) {
                        LOGGER.info("DRYRUN: would have scraped show " + tvShow.getTitle() + " with " + tvShow.getEpisodeCount() + " episodes");
                    }
                } else {
                    task = new TvShowScrapeTask(showToScrape, true, tvShowSearchAndScrapeOptions);
                    task.run();
                    while (TmmTaskManager.getInstance().poolRunning()) {
                        Thread.sleep(2000L);
                    }
                }
            }
            if (var4_24.size() > 0) {
                if (dryRun) {
                    for (TvShowEpisode tvShowEpisode : var4_24) {
                        LOGGER.info("DRYRUN: would have scraped episode " + tvShowEpisode.getTvShow().getTitle() + " S:" + tvShowEpisode.getSeason() + " E:" + tvShowEpisode.getEpisode());
                    }
                } else {
                    task = new TvShowEpisodeScrapeTask((List<TvShowEpisode>)var4_24, tvShowSearchAndScrapeOptions.getMetadataScraper());
                    task.run();
                    while (TmmTaskManager.getInstance().poolRunning()) {
                        Thread.sleep(2000L);
                    }
                }
            }
            if (rename) {
                LOGGER.info("Commandline - rename & cleanup new shows...");
                if (showToScrape.size() > 0) {
                    if (dryRun) {
                        for (TvShow tvShow : showToScrape) {
                            LOGGER.info("DRYRUN: would have renamed show " + tvShow.getTitle() + " with " + tvShow.getEpisodeCount() + " episodes");
                        }
                    } else {
                        task = new TvShowRenameTask(showToScrape, null, true);
                        task.run();
                        while (TmmTaskManager.getInstance().poolRunning()) {
                            Thread.sleep(2000L);
                        }
                    }
                }
                LOGGER.info("Commandline - rename & cleanup new episodes...");
                if (var4_24.size() > 0) {
                    if (dryRun) {
                        for (TvShowEpisode tvShowEpisode : var4_24) {
                            LOGGER.info("DRYRUN: would have renamed episode " + tvShowEpisode.getTvShow().getTitle() + " S:" + tvShowEpisode.getSeason() + " E:" + tvShowEpisode.getEpisode());
                        }
                    } else {
                        task = new TvShowRenameTask(null, (List<TvShowEpisode>)var4_24, true);
                        task.run();
                    }
                }
            }
            if (checkFiles) {
                boolean allOk = true;
                LOGGER.info("Check all files if existing");
                for (Movie m : MovieList.getInstance().getMovies()) {
                    System.out.print(".");
                    for (MediaFile mf : m.getMediaFiles()) {
                        if (mf.exists()) continue;
                        System.out.println();
                        LOGGER.warn("MediaFile not found! " + mf.getFileAsPath());
                        allOk = false;
                    }
                }
                for (TvShow s : TvShowList.getInstance().getTvShows()) {
                    System.out.print(".");
                    for (MediaFile mf : s.getMediaFiles()) {
                        if (mf.exists()) continue;
                        System.out.println();
                        LOGGER.warn("MediaFile not found! " + mf.getFileAsPath());
                        allOk = false;
                    }
                    for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(s.getEpisodes())) {
                        for (MediaFile mf : episode.getMediaFiles()) {
                            if (mf.exists()) continue;
                            System.out.println();
                            LOGGER.warn("MediaFile not found! " + mf.getFileAsPath());
                            allOk = false;
                        }
                    }
                }
                System.out.println();
                if (allOk) {
                    LOGGER.info("no problems found - everything ok :)");
                }
            }
            if (updateAvailable) {
                LOGGER.warn("=====================================================");
                LOGGER.warn("There's a new TMM version available! Please update!");
                LOGGER.warn("=====================================================");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error executing command line task!", (Throwable)e);
        }
    }
}

