/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thetvdb;

import com.omertron.thetvdbapi.TheTVDBApi;
import com.omertron.thetvdbapi.model.Actor;
import com.omertron.thetvdbapi.model.Banner;
import com.omertron.thetvdbapi.model.BannerType;
import com.omertron.thetvdbapi.model.Banners;
import com.omertron.thetvdbapi.model.Episode;
import com.omertron.thetvdbapi.model.Series;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaEpisode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.ApiKey;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.scraper.util.TvUtils;

@PluginImplementation
public class TheTvDbMetadataProvider
implements ITvShowMetadataProvider,
ITvShowArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TheTvDbMetadataProvider.class);
    private static TheTVDBApi tvdb;
    private static MediaProviderInfo providerInfo;

    public TheTvDbMetadataProvider() throws Exception {
        TheTvDbMetadataProvider.initAPI();
    }

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("tvdb", "thetvdb.com", "<html><h3>The TV DB</h3><br />An open database for television fans. This scraper is able to scrape TV series metadata and artwork", TheTvDbMetadataProvider.class.getResource("/thetvdb_com.png"));
        providerInfo.setVersion(TheTvDbMetadataProvider.class);
        return providerInfo;
    }

    private static synchronized void initAPI() throws Exception {
        if (tvdb == null) {
            try {
                tvdb = new TheTVDBApi(ApiKey.decryptApikey((String)"7bHHg4k0XhRERM8xd3l+ElhMUXOA5Ou4vQUEzYLGHt8="));
            }
            catch (Exception e) {
                LOGGER.error("TheTvDbMetadataProvider", (Throwable)e);
                throw e;
            }
        }
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    public MediaMetadata getMetadata(MediaScrapeOptions mediaScrapeOptions) throws Exception {
        LOGGER.debug("getting metadata: " + mediaScrapeOptions);
        switch (mediaScrapeOptions.getType()) {
            case TV_SHOW: {
                return this.getTvShowMetadata(mediaScrapeOptions);
            }
            case TV_EPISODE: {
                return this.getEpisodeMetadata(mediaScrapeOptions);
            }
        }
        throw new UnsupportedMediaTypeException(mediaScrapeOptions.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaSearchResult> search(MediaSearchOptions options) throws Exception {
        MediaSearchResult sr;
        LOGGER.debug("search() " + options.toString());
        ArrayList<MediaSearchResult> results = new ArrayList<MediaSearchResult>();
        if (options.getMediaType() != MediaType.TV_SHOW) {
            throw new UnsupportedMediaTypeException(options.getMediaType());
        }
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getQuery())) {
            searchString = options.getQuery();
        }
        if (StringUtils.isEmpty((CharSequence)searchString)) {
            return results;
        }
        String language = options.getLanguage().getLanguage();
        String country = options.getCountry().name();
        List<Series> series = null;
        TheTVDBApi theTVDBApi = tvdb;
        synchronized (theTVDBApi) {
            series = tvdb.searchSeries(searchString, language);
        }
        if (series == null || series.isEmpty()) {
            return results;
        }
        HashMap<String, MediaSearchResult> storedResults = new HashMap<String, MediaSearchResult>();
        for (Series show : series) {
            if (!show.getLanguage().equalsIgnoreCase(language) || storedResults.containsKey(show.getId())) continue;
            sr = this.createSearchResult(show, options, searchString);
            results.add(sr);
            storedResults.put(show.getId(), sr);
        }
        for (Series show : series) {
            if (storedResults.containsKey(show.getId())) continue;
            sr = this.createSearchResult(show, options, searchString);
            results.add(sr);
            storedResults.put(show.getId(), sr);
        }
        if (results.isEmpty() && searchString.matches("^[0-9]+$")) {
            MediaScrapeOptions scrapeOptions = new MediaScrapeOptions(MediaType.TV_SHOW);
            scrapeOptions.setId(providerInfo.getId(), searchString);
            scrapeOptions.setLanguage(options.getLanguage());
            scrapeOptions.setCountry(CountryCode.valueOf((String)country));
            MediaMetadata md = this.getTvShowMetadata(scrapeOptions);
            if (md != null && StringUtils.isNotBlank((CharSequence)md.getTitle())) {
                MediaSearchResult result = new MediaSearchResult(providerInfo.getId(), options.getMediaType());
                result.setId((String)md.getId(providerInfo.getId()));
                result.setTitle(md.getTitle());
                if (!md.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
                    MediaArtwork poster = (MediaArtwork)md.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).get(0);
                    result.setPosterUrl(poster.getPreviewUrl());
                }
                results.add(result);
            }
        }
        Collections.sort(results);
        Collections.reverse(results);
        return results;
    }

    private MediaSearchResult createSearchResult(Series show, MediaSearchOptions options, String searchString) {
        MediaSearchResult sr = new MediaSearchResult(providerInfo.getId(), options.getMediaType());
        sr.setId(show.getId());
        sr.setIMDBId(show.getImdbId());
        sr.setTitle(show.getSeriesName());
        sr.setPosterUrl(show.getPoster());
        if (show.getFirstAired() != null && show.getFirstAired().length() > 3) {
            try {
                sr.setYear(Integer.parseInt(show.getFirstAired().substring(0, 4)));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        float score = MetadataUtil.calculateScore((String)searchString, (String)show.getSeriesName());
        if (this.yearDiffers(options.getYear(), sr.getYear())) {
            float diff = (float)Math.abs(options.getYear() - sr.getYear()) / 100.0f;
            LOGGER.debug("parsed year does not match search result year - downgrading score by " + diff);
            score -= diff;
        }
        sr.setScore(score);
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaMetadata getTvShowMetadata(MediaScrapeOptions options) throws Exception {
        Object calendar;
        MediaMetadata md = new MediaMetadata(providerInfo.getId());
        String id = "";
        if (options.getResult() != null) {
            id = options.getResult().getId();
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = options.getId(providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = options.getId("tvdb");
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            return md;
        }
        Series show = null;
        TheTVDBApi theTVDBApi = tvdb;
        synchronized (theTVDBApi) {
            show = tvdb.getSeries(id, options.getLanguage().getLanguage());
        }
        if (show == null) {
            return md;
        }
        md.setId(providerInfo.getId(), (Object)show.getId());
        md.setTitle(show.getSeriesName());
        md.setId("imdb", (Object)show.getImdbId());
        md.setPlot(show.getOverview());
        try {
            md.setRuntime(Integer.valueOf(show.getRuntime()));
        }
        catch (NumberFormatException e) {
            md.setRuntime(0);
        }
        MediaArtwork ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
        ma.setPreviewUrl(show.getPoster());
        ma.setDefaultUrl(show.getPoster());
        ma.setLanguage(options.getLanguage().getLanguage());
        md.addMediaArt(ma);
        md.setRating(NumberUtils.toFloat((String)show.getRating()));
        md.setVoteCount(TvUtils.parseInt((Object[])new Object[]{show.getRatingCount()}));
        try {
            md.setReleaseDate(StrgUtils.parseDate((String)show.getFirstAired()));
        }
        catch (ParseException ignored) {
            // empty catch block
        }
        try {
            Date date = StrgUtils.parseDate((String)show.getFirstAired());
            calendar = Calendar.getInstance();
            ((Calendar)calendar).setTime(date);
            int y = ((Calendar)calendar).get(1);
            md.setYear(y);
            if (y != 0 && md.getTitle().contains(String.valueOf(y))) {
                LOGGER.debug("Weird TVDB entry - removing date " + y + " from title");
                String t = show.getSeriesName().replaceAll(String.valueOf(y), "").replaceAll("\\(\\)", "").trim();
                md.setTitle(t);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        md.setStatus(show.getStatus());
        md.addProductionCompany(show.getNetwork());
        ArrayList<Actor> actors = new ArrayList<Actor>();
        calendar = tvdb;
        synchronized (calendar) {
            actors.addAll(tvdb.getActors(id));
        }
        for (Actor actor : actors) {
            MediaCastMember member = new MediaCastMember(MediaCastMember.CastType.ACTOR);
            member.setName(actor.getName());
            member.setCharacter(actor.getRole());
            member.setImageUrl(actor.getImage());
            md.addCastMember(member);
        }
        md.addCertification(Certification.findCertification((String)show.getContentRating()));
        for (String genreAsString : show.getGenres()) {
            md.addGenre(this.getTmmGenre(genreAsString));
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaMetadata getEpisodeMetadata(MediaScrapeOptions options) throws Exception {
        MediaMetadata md = new MediaMetadata(providerInfo.getId());
        boolean useDvdOrder = false;
        String id = "";
        if (options.getResult() != null) {
            id = options.getResult().getId();
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = options.getId(providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = options.getId("tvdb");
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            return md;
        }
        int seasonNr = -1;
        int episodeNr = -1;
        try {
            String option = options.getId("seasonNr");
            if (option != null) {
                seasonNr = Integer.parseInt(options.getId("seasonNr"));
                episodeNr = Integer.parseInt(options.getId("episodeNr"));
            } else {
                seasonNr = Integer.parseInt(options.getId("dvdSeasonNr"));
                episodeNr = Integer.parseInt(options.getId("dvdEpisodeNr"));
                useDvdOrder = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("error parsing season/episode number");
        }
        System.out.println("search for " + seasonNr + " " + episodeNr);
        String aired = "";
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            aired = formatter.format((Object)options.getMetadata().getReleaseDate());
        }
        if (aired.isEmpty() && (seasonNr == -1 || episodeNr == -1)) {
            return md;
        }
        ArrayList<Episode> episodes = new ArrayList<Episode>();
        TheTVDBApi theTVDBApi = tvdb;
        synchronized (theTVDBApi) {
            episodes.addAll(tvdb.getAllEpisodes(id, options.getLanguage().getLanguage()));
        }
        Episode episode = null;
        for (Episode ep : episodes) {
            if (useDvdOrder) {
                int s = TvUtils.getSeasonNumber((Object[])new Object[]{ep.getDvdSeason()});
                int e = TvUtils.getEpisodeNumber((Object[])new Object[]{ep.getDvdEpisodeNumber()});
                if (s != seasonNr || e != episodeNr) continue;
                episode = ep;
                break;
            }
            if (TvUtils.getSeasonNumber((Object[])new Object[]{ep.getSeasonNumber()}) != seasonNr || TvUtils.getEpisodeNumber((Object[])new Object[]{ep.getEpisodeNumber()}) != episodeNr) continue;
            episode = ep;
            break;
        }
        if (episode == null && !aired.isEmpty()) {
            for (Episode ep : episodes) {
                if (!ep.getFirstAired().equals(aired)) continue;
                episode = ep;
                break;
            }
        }
        if (episode == null) {
            return md;
        }
        md.setEpisodeNumber(TvUtils.getEpisodeNumber((Object[])new Object[]{episode.getEpisodeNumber()}));
        md.setSeasonNumber(TvUtils.getSeasonNumber((Object[])new Object[]{episode.getSeasonNumber()}));
        md.setDvdEpisodeNumber(TvUtils.getEpisodeNumber((Object[])new Object[]{episode.getDvdEpisodeNumber()}));
        md.setDvdSeasonNumber(TvUtils.getSeasonNumber((Object[])new Object[]{episode.getDvdSeason()}));
        md.setAbsoluteNumber(TvUtils.getEpisodeNumber((Object[])new Object[]{episode.getAbsoluteNumber()}));
        md.setTitle(episode.getEpisodeName());
        md.setPlot(episode.getOverview());
        md.setRating(NumberUtils.toFloat((String)episode.getRating()));
        md.setVoteCount(TvUtils.parseInt((Object[])new Object[]{episode.getRatingCount()}));
        try {
            md.setReleaseDate(StrgUtils.parseDate((String)episode.getFirstAired()));
        }
        catch (ParseException ignored) {
            // empty catch block
        }
        md.setId(providerInfo.getId(), (Object)episode.getId());
        for (String director : episode.getDirectors()) {
            MediaCastMember cm = new MediaCastMember(MediaCastMember.CastType.DIRECTOR);
            cm.setName(director);
            md.addCastMember(cm);
        }
        for (String writer : episode.getWriters()) {
            MediaCastMember cm = new MediaCastMember(MediaCastMember.CastType.WRITER);
            cm.setName(writer);
            md.addCastMember(cm);
        }
        for (String guest : episode.getGuestStars()) {
            MediaCastMember cm = new MediaCastMember(MediaCastMember.CastType.ACTOR);
            cm.setName(guest);
            md.addCastMember(cm);
        }
        if (options.getArtworkType() == MediaArtwork.MediaArtworkType.ALL || options.getArtworkType() == MediaArtwork.MediaArtworkType.THUMB) {
            MediaArtwork ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.THUMB);
            ma.setPreviewUrl(episode.getFilename());
            ma.setDefaultUrl(episode.getFilename());
            md.addMediaArt(ma);
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaArtwork> getArtwork(MediaScrapeOptions options) throws Exception {
        LOGGER.debug("getting artwork: " + options);
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        String id = "";
        if (options.getMetadata() != null) {
            id = (String)options.getMetadata().getId(providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = options.getId(providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = options.getId("tvdb");
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            return artwork;
        }
        Banners banners = null;
        TheTVDBApi theTVDBApi = tvdb;
        synchronized (theTVDBApi) {
            banners = tvdb.getBanners(id);
        }
        List<Banner> bannerList = null;
        switch (options.getArtworkType()) {
            case ALL: {
                bannerList = new ArrayList<Banner>(banners.getSeasonList());
                bannerList.addAll(banners.getSeriesList());
                bannerList.addAll(banners.getPosterList());
                bannerList.addAll(banners.getFanartList());
                bannerList.addAll(banners.getSeasonList());
                break;
            }
            case POSTER: {
                bannerList = banners.getPosterList();
                break;
            }
            case BACKGROUND: {
                bannerList = banners.getFanartList();
                break;
            }
            case SEASON: {
                bannerList = banners.getSeasonList();
                break;
            }
            case BANNER: {
                bannerList = banners.getSeriesList();
                break;
            }
        }
        if (bannerList == null) {
            return artwork;
        }
        Collections.sort(bannerList, new BannerComparator(options.getLanguage().getLanguage()));
        block17: for (Banner banner : bannerList) {
            MediaArtwork ma = null;
            switch (banner.getBannerType()) {
                case POSTER: {
                    ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
                    break;
                }
                case SERIES: {
                    ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.BANNER);
                    break;
                }
                case SEASON: {
                    if (banner.getBannerType2() == BannerType.SEASONWIDE) continue block17;
                    ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.SEASON);
                    ma.setSeason(banner.getSeason());
                    break;
                }
                default: {
                    ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
                    if (!StringUtils.isNotBlank((CharSequence)banner.getBannerType2().getType())) break;
                    try {
                        Pattern pattern = Pattern.compile("([0-9]{3,4})x([0-9]{3,4})");
                        Matcher matcher = pattern.matcher(banner.getBannerType2().getType());
                        if (!matcher.matches() || matcher.groupCount() <= 1) break;
                        ma.addImageSize(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), banner.getUrl());
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.debug("could not extract size from bannertype 2: " + (Object)((Object)banner.getBannerType2()));
                    }
                }
            }
            ma.setDefaultUrl(banner.getUrl());
            if (StringUtils.isNotBlank((CharSequence)banner.getThumb())) {
                ma.setPreviewUrl(banner.getThumb());
            } else {
                ma.setPreviewUrl(banner.getUrl());
            }
            ma.setLanguage(banner.getLanguage());
            artwork.add(ma);
        }
        return artwork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaEpisode> getEpisodeList(MediaScrapeOptions options) throws Exception {
        LOGGER.debug("getting episode list: " + options);
        ArrayList<MediaEpisode> episodes = new ArrayList<MediaEpisode>();
        String id = "";
        if (options.getResult() != null) {
            id = options.getResult().getId();
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = options.getId(providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = options.getId("tvdb");
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            return episodes;
        }
        ArrayList<Episode> eps = new ArrayList<Episode>();
        TheTVDBApi theTVDBApi = tvdb;
        synchronized (theTVDBApi) {
            eps.addAll(tvdb.getAllEpisodes(id, options.getLanguage().getLanguage()));
        }
        for (Episode ep : eps) {
            MediaCastMember cm;
            MediaEpisode episode = new MediaEpisode(providerInfo.getId());
            episode.season = TvUtils.getSeasonNumber((Object[])new Object[]{ep.getSeasonNumber()});
            episode.episode = TvUtils.getEpisodeNumber((Object[])new Object[]{ep.getEpisodeNumber()});
            episode.dvdSeason = TvUtils.getSeasonNumber((Object[])new Object[]{ep.getDvdSeason()});
            episode.dvdEpisode = TvUtils.getEpisodeNumber((Object[])new Object[]{ep.getDvdEpisodeNumber()});
            episode.title = ep.getEpisodeName();
            episode.plot = ep.getOverview();
            episode.rating = NumberUtils.toFloat((String)ep.getRating());
            episode.voteCount = TvUtils.parseInt((Object[])new Object[]{ep.getRatingCount()});
            episode.firstAired = ep.getFirstAired();
            episode.ids.put(providerInfo.getId(), ep.getId());
            for (String director : ep.getDirectors()) {
                cm = new MediaCastMember(MediaCastMember.CastType.DIRECTOR);
                cm.setName(director);
                episode.castMembers.add(cm);
            }
            for (String writer : ep.getWriters()) {
                cm = new MediaCastMember(MediaCastMember.CastType.WRITER);
                cm.setName(writer);
                episode.castMembers.add(cm);
            }
            for (String guest : ep.getGuestStars()) {
                cm = new MediaCastMember(MediaCastMember.CastType.ACTOR);
                cm.setName(guest);
                episode.castMembers.add(cm);
            }
            MediaArtwork ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.THUMB);
            ma.setDefaultUrl(ep.getFilename());
            episode.artwork.add(ma);
            episodes.add(episode);
        }
        return episodes;
    }

    private MediaGenres getTmmGenre(String genre) {
        MediaGenres g = null;
        if (genre.isEmpty()) {
            return g;
        }
        if (genre.equals("Action")) {
            g = MediaGenres.ACTION;
        } else if (genre.equals("Adventure")) {
            g = MediaGenres.ADVENTURE;
        } else if (genre.equals("Animation")) {
            g = MediaGenres.ANIMATION;
        } else if (genre.equals("Children")) {
            g = MediaGenres.FAMILY;
        } else if (genre.equals("Comedy")) {
            g = MediaGenres.COMEDY;
        } else if (genre.equals("Crime")) {
            g = MediaGenres.CRIME;
        } else if (genre.equals("Documentary")) {
            g = MediaGenres.DOCUMENTARY;
        } else if (genre.equals("Drama")) {
            g = MediaGenres.DRAMA;
        } else if (genre.equals("Family")) {
            g = MediaGenres.FAMILY;
        } else if (genre.equals("Fantasy")) {
            g = MediaGenres.FANTASY;
        } else if (genre.equals("Food")) {
            g = MediaGenres.DOCUMENTARY;
        } else if (genre.equals("Game Show")) {
            g = MediaGenres.GAME_SHOW;
        } else if (genre.equals("Home and Garden")) {
            g = MediaGenres.DOCUMENTARY;
        } else if (genre.equals("Horror")) {
            g = MediaGenres.HORROR;
        } else if (genre.equals("Mini-Series")) {
            g = MediaGenres.SERIES;
        } else if (genre.equals("News")) {
            g = MediaGenres.NEWS;
        } else if (genre.equals("Reality")) {
            g = MediaGenres.REALITY_TV;
        } else if (genre.equals("Science-Fiction")) {
            g = MediaGenres.SCIENCE_FICTION;
        } else if (genre.equals("Soap")) {
            g = MediaGenres.SERIES;
        } else if (genre.equals("Special Interest")) {
            g = MediaGenres.INDIE;
        } else if (genre.equals("Sport")) {
            g = MediaGenres.SPORT;
        } else if (genre.equals("Suspense")) {
            g = MediaGenres.SUSPENSE;
        } else if (genre.equals("Talk Show")) {
            g = MediaGenres.TALK_SHOW;
        } else if (genre.equals("Thriller")) {
            g = MediaGenres.THRILLER;
        } else if (genre.equals("Travel")) {
            g = MediaGenres.HOLIDAY;
        } else if (genre.equals("Western")) {
            g = MediaGenres.WESTERN;
        }
        if (g == null) {
            g = MediaGenres.getGenre((String)genre);
        }
        return g;
    }

    private boolean yearDiffers(Integer i1, Integer i2) {
        return i1 != null && i1 != 0 && i2 != null && i2 != 0 && i1 != i2;
    }

    static {
        providerInfo = TheTvDbMetadataProvider.createMediaProviderInfo();
    }

    private static class BannerComparator
    implements Comparator<Banner> {
        private String preferredLangu;

        private BannerComparator(String language) {
            this.preferredLangu = language;
        }

        @Override
        public int compare(Banner arg0, Banner arg1) {
            if (this.preferredLangu.equals(arg0.getLanguage()) && !this.preferredLangu.equals(arg1.getLanguage())) {
                return -1;
            }
            if (!this.preferredLangu.equals(arg0.getLanguage()) && this.preferredLangu.equals(arg1.getLanguage())) {
                return 1;
            }
            if ("en".equals(arg0.getLanguage()) && !"en".equals(arg1.getLanguage())) {
                return -1;
            }
            if (!"en".equals(arg0.getLanguage()) && "en".equals(arg1.getLanguage())) {
                return 1;
            }
            if (arg0.getRating().equals(arg1.getRating())) {
                return 0;
            }
            return arg0.getRating().floatValue() > arg1.getRating().floatValue() ? -1 : 1;
        }
    }
}

